/*
 * Copyright (c) 2019. NUM Technology Ltd
 */

package uk.num.numlib.internal.module;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import uk.num.numlib.api.UserVariable;

/**
 * A class to represent the Module Configuration data obtained from DNS.
 *
 * @author tonywalmsley
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@Getter
@Setter
@ToString
public class Module {
    /**
     * The module name
     */
    private String name;
    /**
     * Required User Variables: Which variables (if any) must be collected by the client from the user, along with any prompts.
     */
    private UserVariable[] uv;
    /**
     * Branch Populator Service Query: Whether the client should run a populator query Content further up this document. for branch records.
     */
    private boolean psq;
    /**
     * DNS(SEC) Required: Whether records must be DNS(SEC) signed.
     */
    private boolean dsr;

    /**
     * Default constructor
     */
    public Module() {
        uv = new UserVariable[0];
    }

}
