/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.internal.module;

import java.net.MalformedURLException;
import java.util.Arrays;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.num.numlib.exc.NumBadURLException;
import uk.num.numlib.exc.NumInvalidParameterException;
import uk.num.numlib.exc.NumInvalidRedirectException;
import uk.num.numlib.internal.ctx.AppContext;
import uk.num.numlib.internal.util.BaseLookupGenerator;
import uk.num.numlib.internal.util.DomainLookupGenerator;
import uk.num.numlib.internal.util.EmailLookupGenerator;
import uk.num.numlib.internal.util.NonBlankString;
import uk.num.numlib.internal.util.URLLookupGenerator;

public class ModuleDNSQueries {
    private static final Logger log = LogManager.getLogger(ModuleDNSQueries.class);
    @NonNull
    private final String moduleId;
    @NonNull
    private final String numId;
    private String independentRecordLocation;
    private String rootIndependentRecordLocation;
    private String hostedRecordLocation;
    private String rootHostedRecordLocation;
    private String populatorLocation;
    private boolean rootQuery = true;

    public ModuleDNSQueries(@NonNull NonBlankString moduleId, @NonNull NonBlankString numId) {
        if (moduleId == null) {
            throw new NullPointerException("moduleId is marked @NonNull but is null");
        }
        if (numId == null) {
            throw new NullPointerException("numId is marked @NonNull but is null");
        }
        log.debug("ModuleDNSQueries({}, {})", (Object)moduleId, (Object)numId);
        this.moduleId = moduleId.value;
        this.numId = numId.value;
    }

    public void initialise(AppContext appContext) throws NumBadURLException, NumInvalidParameterException {
        BaseLookupGenerator lookupGenerator;
        log.trace("initialise()");
        if (this.numId.contains("@")) {
            lookupGenerator = new EmailLookupGenerator(appContext, this.numId);
        } else if (this.numId.startsWith("http")) {
            try {
                lookupGenerator = new URLLookupGenerator(appContext, this.numId);
            }
            catch (MalformedURLException e) {
                throw new NumBadURLException(e);
            }
        } else {
            lookupGenerator = new DomainLookupGenerator(appContext, this.numId);
        }
        this.independentRecordLocation = lookupGenerator.getIndependentLocation(this.moduleId);
        this.rootIndependentRecordLocation = lookupGenerator.getRootIndependentLocation(this.moduleId);
        this.hostedRecordLocation = lookupGenerator.getHostedLocation(this.moduleId);
        this.rootHostedRecordLocation = lookupGenerator.getRootHostedLocation(this.moduleId);
        this.rootQuery = lookupGenerator.isDomainRoot();
        if (this.rootQuery) {
            this.populatorLocation = lookupGenerator.getPopulatorLocation(this.moduleId);
        }
    }

    public void setRootRedirectIndependentRecordLocation(AppContext appContext, NonBlankString redirectTo) throws NumInvalidParameterException, NumBadURLException, NumInvalidRedirectException {
        String newLocation = redirectTo.value + "." + this.rootIndependentRecordLocation;
        if (this.independentRecordLocation.equals(newLocation)) {
            log.debug("Attempted redirect to same location: {}", (Object)newLocation);
            throw new NumInvalidRedirectException("Cannot redirect back to the same location.");
        }
        this.independentRecordLocation = newLocation;
    }

    public void setRelativeRedirectIndependentRecordLocation(AppContext appContext, NonBlankString redirect, int levels) throws NumInvalidRedirectException, NumInvalidParameterException, NumBadURLException {
        String newLocation;
        String[] split = this.independentRecordLocation.split("\\.");
        if (levels < split.length) {
            CharSequence[] parts = Arrays.copyOfRange(split, levels, split.length);
            String ancestor = String.join((CharSequence)".", parts);
            newLocation = redirect + "." + ancestor + ".";
            if (!newLocation.endsWith(this.rootIndependentRecordLocation)) {
                throw new NumInvalidRedirectException("Cannot redirect " + this.independentRecordLocation + " using " + redirect + " and " + levels + " levels");
            }
            if (this.independentRecordLocation.equals(newLocation)) {
                log.debug("Attempted redirect to same location: {}", (Object)newLocation);
                throw new NumInvalidRedirectException("Cannot redirect back to the same location.");
            }
        } else {
            throw new NumInvalidRedirectException("Cannot redirect " + this.independentRecordLocation + " using " + redirect + " and " + levels + " levels");
        }
        this.independentRecordLocation = newLocation;
    }

    public void setRootRedirectHostedRecordLocation(AppContext appContext, NonBlankString redirect) throws NumInvalidParameterException, NumBadURLException, NumInvalidRedirectException {
        String newLocation = redirect.value + "." + this.rootHostedRecordLocation;
        if (this.hostedRecordLocation.equals(newLocation)) {
            log.debug("Attempted redirect to same location: {}", (Object)newLocation);
            throw new NumInvalidRedirectException("Cannot redirect back to the same location.");
        }
        this.hostedRecordLocation = newLocation;
    }

    public void setRelativeRedirectHostedRecordLocation(AppContext appContext, NonBlankString redirect, int levels) throws NumInvalidRedirectException, NumInvalidParameterException, NumBadURLException {
        String newLocation;
        String[] split = this.hostedRecordLocation.split("\\.");
        if (levels < split.length) {
            CharSequence[] parts = Arrays.copyOfRange(split, levels, split.length);
            String ancestor = String.join((CharSequence)".", parts);
            newLocation = redirect + "." + ancestor + ".";
            if (!newLocation.endsWith(this.rootHostedRecordLocation)) {
                throw new NumInvalidRedirectException("Cannot redirect " + this.hostedRecordLocation + " using " + redirect + " and " + levels + " levels");
            }
            if (this.hostedRecordLocation.equals(newLocation)) {
                log.debug("Attempted redirect to same location: {}", (Object)newLocation);
                throw new NumInvalidRedirectException("Cannot redirect back to the same location.");
            }
        } else {
            throw new NumInvalidRedirectException("Cannot redirect " + this.hostedRecordLocation + " using " + redirect + " and " + levels + " levels");
        }
        this.hostedRecordLocation = newLocation;
    }

    public void redirectIndependentRecordLocationRelativeToCurrent(NonBlankString redirectTo) {
        this.independentRecordLocation = redirectTo + "." + this.independentRecordLocation;
    }

    public void redirectHostedRecordLocationRelativeToCurrent(NonBlankString redirectTo) {
        this.hostedRecordLocation = redirectTo + "." + this.hostedRecordLocation;
    }

    public void setEmailRecordDistributionLevels(AppContext appContext, int levels) {
        if (this.numId.contains("@")) {
            EmailLookupGenerator generator = new EmailLookupGenerator(appContext, this.numId);
            this.independentRecordLocation = generator.getDistributedIndependentLocation(this.moduleId, levels);
            this.hostedRecordLocation = generator.getDistributedHostedLocation(this.moduleId, levels);
        } else {
            log.warn("Attempt to distribute a non-email lookup using a Zone Distribution Record.");
        }
    }

    @NonNull
    public String getModuleId() {
        return this.moduleId;
    }

    public String getIndependentRecordLocation() {
        return this.independentRecordLocation;
    }

    public String getRootIndependentRecordLocation() {
        return this.rootIndependentRecordLocation;
    }

    public String getHostedRecordLocation() {
        return this.hostedRecordLocation;
    }

    public String getRootHostedRecordLocation() {
        return this.rootHostedRecordLocation;
    }

    public String getPopulatorLocation() {
        return this.populatorLocation;
    }

    public boolean isRootQuery() {
        return this.rootQuery;
    }
}

