/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.internal.ctx;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.num.numlib.api.NumAPICallbacks;
import uk.num.numlib.api.NumAPIContext;
import uk.num.numlib.api.UserVariable;
import uk.num.numlib.exc.NumInvalidDNSQueryException;
import uk.num.numlib.exc.NumInvalidRedirectException;
import uk.num.numlib.exc.NumMaximumRedirectsExceededException;
import uk.num.numlib.exc.NumUserVariablesException;
import uk.num.numlib.exc.RelativePathException;
import uk.num.numlib.internal.module.ModuleConfig;
import uk.num.numlib.internal.module.ModuleDNSQueries;
import uk.num.numlib.internal.util.NonBlankString;
import uk.num.numlib.internal.util.UrlRelativePathResolver;

public class NumAPIContextBase
implements NumAPIContext {
    private static final Logger log = LogManager.getLogger(NumAPIContextBase.class);
    private static final int MAX_NUM_REDIRECTS = 3;
    private ModuleDNSQueries moduleDNSQueries;
    private ModuleConfig moduleConfig;
    private int redirectCount = 0;
    private NumAPICallbacks.Location location;

    private int incrementRedirectCount() {
        ++this.redirectCount;
        return this.redirectCount;
    }

    @Override
    public UserVariable[] getRequiredUserVariables() {
        return this.moduleConfig.getModule().getUv();
    }

    @Override
    public void setRequiredUserVariables(UserVariable[] userVariables) throws NumUserVariablesException {
        StringBuilder errors = new StringBuilder();
        boolean errorsFound = false;
        for (UserVariable v : userVariables) {
            if (!v.isReq() || v.getValue() != null && v.getValue().trim().length() != 0) continue;
            errorsFound = true;
            errors.append("Variable '");
            errors.append(v.getKey());
            errors.append("' should not be null or empty.\n");
            log.trace("Required User Variable: key={}, prompt={}, value={}", (Object)v.getKey(), (Object)v.getName(), (Object)v.getValue());
        }
        if (errorsFound) {
            log.error("Error in Required User Variables: {}", (Object)errors.toString());
            throw new NumUserVariablesException("Error in Required User Variables: " + errors.toString());
        }
        this.moduleConfig.getModule().setUv(userVariables);
    }

    public String getRecordLocation() {
        switch (this.location) {
            case INDEPENDENT: {
                return this.moduleDNSQueries.getIndependentRecordLocation();
            }
            case HOSTED: {
                return this.moduleDNSQueries.getHostedRecordLocation();
            }
            case POPULATOR: {
                return this.moduleDNSQueries.getPopulatorLocation();
            }
        }
        return "STOP";
    }

    public void handleQueryRedirect(NonBlankString redirect, NumAPIContextBase context) throws NumMaximumRedirectsExceededException, NumInvalidDNSQueryException, NumInvalidRedirectException {
        log.info("Query Redirected to: {}", (Object)redirect);
        int redirectCount = context.incrementRedirectCount();
        if (redirectCount >= 3) {
            log.error("Maximum Redirects Exceeded. (max={})", (Object)3);
            throw new NumMaximumRedirectsExceededException();
        }
        switch (this.location) {
            case INDEPENDENT: {
                this.handleIndependentQueryRedirect(redirect);
            }
            case HOSTED: {
                this.handleHostedQueryRedirect(redirect);
            }
        }
    }

    private void handleHostedQueryRedirect(NonBlankString redirectTo) throws NumInvalidDNSQueryException, NumInvalidRedirectException {
        String hostedRecordPath = this.moduleDNSQueries.getHostedRecordPath();
        try {
            this.moduleDNSQueries.redirectHostedPath(UrlRelativePathResolver.resolve(hostedRecordPath, redirectTo.value));
        }
        catch (RelativePathException e) {
            throw new NumInvalidRedirectException(e);
        }
    }

    private void handleIndependentQueryRedirect(NonBlankString redirectTo) throws NumInvalidRedirectException, NumInvalidDNSQueryException {
        String independentRecordPath = this.moduleDNSQueries.getIndependentRecordPath();
        try {
            this.moduleDNSQueries.redirectIndependentPath(UrlRelativePathResolver.resolve(independentRecordPath, redirectTo.value));
        }
        catch (RelativePathException e) {
            throw new NumInvalidRedirectException(e);
        }
    }

    public ModuleDNSQueries getModuleDNSQueries() {
        return this.moduleDNSQueries;
    }

    public void setModuleDNSQueries(ModuleDNSQueries moduleDNSQueries) {
        this.moduleDNSQueries = moduleDNSQueries;
    }

    public void setModuleConfig(ModuleConfig moduleConfig) {
        this.moduleConfig = moduleConfig;
    }

    public ModuleConfig getModuleConfig() {
        return this.moduleConfig;
    }

    public NumAPICallbacks.Location getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(NumAPICallbacks.Location location) {
        this.location = location;
    }
}

