/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.internal.util;

import java.net.URL;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import uk.num.numlib.exc.NumBadURLException;
import uk.num.numlib.exc.NumInvalidParameterException;
import uk.num.numlib.internal.util.DomainNameUtils;
import uk.num.numlib.internal.util.HashUtils;
import uk.num.numlib.internal.util.StringConstants;

public class URLUtils {
    private static URLUtils _instance;

    private URLUtils() {
    }

    public static URLUtils instance() {
        if (_instance == null) {
            _instance = new URLUtils();
        }
        return _instance;
    }

    public String toIndependentRecordQuery(URL url, String moduleId) throws NumInvalidParameterException, NumBadURLException {
        this.validateParams(url, moduleId);
        String normalisedDomain = DomainNameUtils.instance().normaliseDomainName(url.getHost());
        String normalisedPath = this.normalisePath(url.getPath());
        return String.format("%s%s%s%s.", normalisedPath, moduleId, StringConstants.instance().UTILITY_MODULE_PREFIX(), normalisedDomain);
    }

    private void validateParams(URL url, String moduleId) throws NumInvalidParameterException {
        if (url == null) {
            throw new NumInvalidParameterException("Cannot normalise a null URL");
        }
        if (moduleId == null) {
            throw new NumInvalidParameterException("The moduleId cannot be null");
        }
        if (moduleId.trim().isEmpty()) {
            throw new NumInvalidParameterException("The moduleId cannot be empty");
        }
    }

    public String toManagedRecordQuery(URL url, String moduleId) throws NumInvalidParameterException, NumBadURLException {
        this.validateParams(url, moduleId);
        String normalisedDomain = DomainNameUtils.instance().normaliseDomainName(url.getHost());
        String normalisedPath = this.normalisePath(url.getPath());
        String hashValue = HashUtils.instance().hash(normalisedDomain);
        return String.format("%s%s.%s%s%s%s.", normalisedPath, moduleId, StringConstants.instance().DOMAIN_NAME_PREFIX(), normalisedDomain, hashValue, StringConstants.instance().MANAGED_RECORD_SUFFIX());
    }

    public String toPrePopulatedRecordQuery(URL url, String moduleId) throws NumInvalidParameterException, NumBadURLException {
        this.validateParams(url, moduleId);
        String normalisedDomain = DomainNameUtils.instance().normaliseDomainName(url.getHost());
        String normalisedPath = this.normalisePath(url.getPath());
        String hashValue = HashUtils.instance().hash(normalisedDomain);
        return String.format("%s%s.%s%s%s%s.", normalisedPath, moduleId, StringConstants.instance().DOMAIN_NAME_PREFIX(), normalisedDomain, hashValue, StringConstants.instance().PREPOPULATED_RECORD_SUFFIX());
    }

    public String toPopulatorQuery(URL url, String moduleId) throws NumInvalidParameterException, NumBadURLException {
        this.validateParams(url, moduleId);
        String normalisedDomain = DomainNameUtils.instance().normaliseDomainName(url.getHost());
        String normalisedPath = this.normalisePath(url.getPath());
        String hashValue = HashUtils.instance().hash(normalisedDomain);
        return String.format("%s%s.%s%s%s%s.", normalisedPath, moduleId, StringConstants.instance().DOMAIN_NAME_PREFIX(), normalisedDomain, hashValue, StringConstants.instance().POPULATOR_SERVICE_SUFFIX());
    }

    private String normalisePath(String path) {
        String result = "";
        if (path != null && !path.isEmpty()) {
            Object[] pathComponents = path.split("[/.]");
            ArrayUtils.reverse((Object[])pathComponents);
            result = StringConstants.instance().DOMAIN_NAME_PREFIX() + StringUtils.join((Object[])pathComponents, (String)".");
            result = result.replaceAll(" ", "_");
        }
        return result;
    }
}

