/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.internal.module;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.num.numlib.exc.NumBadURLException;
import uk.num.numlib.exc.NumInvalidParameterException;
import uk.num.numlib.exc.NumInvalidRedirectException;
import uk.num.numlib.internal.ctx.AppContext;

public class ModuleDNSQueries {
    private static final Logger LOG = LoggerFactory.getLogger(ModuleDNSQueries.class);
    private String moduleId;
    private String domainName;
    private String independentRecordLocation;
    private String managedRecordLocation;
    private String prepopulatedRecordLocation;
    private String populatorLocation;
    private boolean rootQuery = true;

    public ModuleDNSQueries(String moduleId, String domainName) throws NumInvalidParameterException {
        if (moduleId == null || moduleId.trim().length() == 0) {
            LOG.error("moduleId is null or empty");
            throw new NumInvalidParameterException("moduleId cannot be null or empty");
        }
        if (domainName == null || domainName.trim().length() == 0) {
            LOG.error("domainName is null or empty");
            throw new NumInvalidParameterException("domainName cannot be null or empty");
        }
        LOG.trace("ModuleDNSQueries({}, {})", (Object)moduleId, (Object)domainName);
        this.moduleId = moduleId;
        this.domainName = domainName;
    }

    public boolean isRootQuery() {
        return this.rootQuery;
    }

    public void initialise() throws NumBadURLException, NumInvalidParameterException {
        LOG.trace("initialise()");
        if (this.domainName.startsWith("http")) {
            LOG.trace("initialise() - URL branch query");
            this.rootQuery = false;
            try {
                URL url = new URL(this.domainName);
                this.independentRecordLocation = AppContext.urlUtils.toIndependentRecordQuery(url, this.moduleId);
                this.managedRecordLocation = AppContext.urlUtils.toManagedRecordQuery(url, this.moduleId);
                this.prepopulatedRecordLocation = AppContext.urlUtils.toPrePopulatedRecordQuery(url, this.moduleId);
                this.populatorLocation = AppContext.urlUtils.toPopulatorQuery(url, this.moduleId);
            }
            catch (MalformedURLException e) {
                LOG.error("Bad URL.", (Throwable)e);
                throw new NumBadURLException("The supplied URL cannot be parsed.");
            }
        } else if (this.domainName.contains("@")) {
            LOG.trace("initialise() - email branch query");
            this.rootQuery = false;
            this.independentRecordLocation = AppContext.emailAddressUtils.toIndependentRecordQuery(this.domainName, this.moduleId);
            this.managedRecordLocation = AppContext.emailAddressUtils.toManagedRecordQuery(this.domainName, this.moduleId);
            this.prepopulatedRecordLocation = AppContext.emailAddressUtils.toPrePopulatedRecordQuery(this.domainName, this.moduleId);
            this.populatorLocation = AppContext.emailAddressUtils.toPopulatorQuery(this.domainName, this.moduleId);
        } else {
            LOG.trace("initialise() - root query");
            this.rootQuery = true;
            this.independentRecordLocation = AppContext.domainNameUtils.toIndependentRecordQuery(this.domainName, this.moduleId);
            this.managedRecordLocation = AppContext.domainNameUtils.toManagedRecordQuery(this.domainName, this.moduleId);
            this.prepopulatedRecordLocation = AppContext.domainNameUtils.toPrePopulatedRecordQuery(this.domainName, this.moduleId);
            this.populatorLocation = AppContext.domainNameUtils.toPopulatorQuery(this.domainName, this.moduleId);
        }
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getIndependentRecordLocation() {
        return this.independentRecordLocation;
    }

    public void setIndependentRecordLocation(String location) {
        this.independentRecordLocation = location;
    }

    public String getManagedRecordLocation() {
        return this.managedRecordLocation;
    }

    public void setManagedRecordLocation(String location) {
        this.managedRecordLocation = location;
    }

    public String getPrepopulatedRecordLocation() {
        return this.prepopulatedRecordLocation;
    }

    public void setPrepopulatedRecordLocation(String location) {
        this.prepopulatedRecordLocation = location;
    }

    public String getPopulatorLocation() {
        return this.populatorLocation;
    }

    public void setRootRedirectIndependentRecordLocation(String redirectTo) throws NumInvalidParameterException, NumBadURLException, NumInvalidRedirectException {
        String originalLocation = this.independentRecordLocation;
        String root = this.independentRecordLocation;
        if (!this.rootQuery) {
            root = this.getIndependentRootFromBranch(this.domainName);
        } else if (StringUtils.isEmpty((CharSequence)redirectTo)) {
            throw new NumInvalidRedirectException("Cannot redirect back to the same location.");
        }
        this.independentRecordLocation = StringUtils.isEmpty((CharSequence)redirectTo) ? root : redirectTo + "." + root;
        if (this.independentRecordLocation.equals(originalLocation)) {
            throw new NumInvalidRedirectException("Cannot redirect back to the same location.");
        }
        this.rootQuery = false;
    }

    public void setRelativeRedirectIndependentRecordLocation(String redirect, int levels) throws NumInvalidRedirectException, NumInvalidParameterException, NumBadURLException {
        if (this.rootQuery) {
            throw new NumInvalidRedirectException("Too many ^ symbols in redirect instruction");
        }
        String root = this.getIndependentRootFromBranch(this.domainName);
        String[] parts = this.independentRecordLocation.split("\\.");
        if (levels < parts.length) {
            StringBuilder builder = new StringBuilder();
            builder.append(redirect);
            builder.append(".");
            for (int i = levels; i < parts.length; ++i) {
                builder.append(parts[i]);
                builder.append(".");
            }
            this.independentRecordLocation = builder.toString();
            if (!this.independentRecordLocation.endsWith(root)) {
                throw new NumInvalidRedirectException("Too many ^ symbols in redirect instruction");
            }
        } else {
            throw new NumInvalidRedirectException("Too many ^ symbols in redirect instruction");
        }
        this.rootQuery = false;
    }

    private String getIndependentRootFromBranch(String branch) throws NumBadURLException, NumInvalidParameterException {
        if (this.domainName.contains("@")) {
            String[] parts = this.domainName.split("@");
            return AppContext.domainNameUtils.toIndependentRecordQuery(parts[1], this.moduleId);
        }
        if (this.domainName.startsWith("http")) {
            try {
                URL url = new URL(this.domainName);
                return AppContext.domainNameUtils.toIndependentRecordQuery(url.getHost(), this.moduleId);
            }
            catch (MalformedURLException e) {
                throw new NumBadURLException(this.domainName);
            }
        }
        return branch;
    }

    private String getManagedRootFromBranch(String branch) throws NumBadURLException, NumInvalidParameterException {
        if (this.domainName.contains("@")) {
            String[] parts = this.domainName.split("@");
            return AppContext.domainNameUtils.toManagedRecordQuery(parts[1], this.moduleId);
        }
        if (this.domainName.startsWith("http")) {
            try {
                URL url = new URL(this.domainName);
                return AppContext.domainNameUtils.toManagedRecordQuery(url.getHost(), this.moduleId);
            }
            catch (MalformedURLException e) {
                throw new NumBadURLException(this.domainName);
            }
        }
        return AppContext.domainNameUtils.toManagedRecordQuery(branch, this.moduleId);
    }

    public void setRootRedirectManagedRecordLocation(String redirect) throws NumInvalidParameterException, NumBadURLException, NumInvalidRedirectException {
        String originalLocation = this.managedRecordLocation;
        String root = this.managedRecordLocation;
        if (!this.rootQuery) {
            root = this.getManagedRootFromBranch(this.domainName);
        } else if (StringUtils.isEmpty((CharSequence)redirect)) {
            throw new NumInvalidRedirectException("Cannot redirect back to the same location.");
        }
        this.managedRecordLocation = StringUtils.isEmpty((CharSequence)redirect) ? root : redirect + "." + root;
        if (this.managedRecordLocation.equals(originalLocation)) {
            throw new NumInvalidRedirectException("Cannot redirect back to the same location.");
        }
        this.rootQuery = false;
    }

    public void setRelativeRedirectManagedRecordLocation(String redirect, int levels) throws NumInvalidRedirectException, NumInvalidParameterException, NumBadURLException {
        if (this.rootQuery) {
            throw new NumInvalidRedirectException("Too many ^ symbols in redirect instruction");
        }
        String root = this.getManagedRootFromBranch(this.domainName);
        String[] parts = this.managedRecordLocation.split("\\.");
        if (levels < parts.length) {
            StringBuilder builder = new StringBuilder();
            builder.append(redirect);
            builder.append(".");
            for (int i = levels; i < parts.length; ++i) {
                builder.append(parts[i]);
                builder.append(".");
            }
            this.managedRecordLocation = builder.toString();
            if (!this.managedRecordLocation.endsWith(root)) {
                throw new NumInvalidRedirectException("Too many ^ symbols in redirect instruction");
            }
        } else {
            throw new NumInvalidRedirectException("Too many ^ symbols in redirect instruction");
        }
        this.rootQuery = false;
    }

    public void setRootRedirectPrepopulatedRecordLocation(String redirect) throws NumBadURLException, NumInvalidParameterException, NumInvalidRedirectException {
        String originalLocation = this.prepopulatedRecordLocation;
        String root = this.prepopulatedRecordLocation;
        if (!this.rootQuery) {
            root = this.getPrepopulatedRootFromBranch(this.domainName);
        } else if (StringUtils.isEmpty((CharSequence)redirect)) {
            throw new NumInvalidRedirectException("Cannot redirect back to the same location.");
        }
        this.prepopulatedRecordLocation = StringUtils.isEmpty((CharSequence)redirect) ? root : redirect + "." + root;
        if (this.prepopulatedRecordLocation.equals(originalLocation)) {
            throw new NumInvalidRedirectException("Cannot redirect back to the same location.");
        }
        this.rootQuery = false;
    }

    private String getPrepopulatedRootFromBranch(String branch) throws NumInvalidParameterException, NumBadURLException {
        if (branch.contains("@")) {
            String[] parts = branch.split("@");
            return AppContext.domainNameUtils.toPrePopulatedRecordQuery(parts[1], this.moduleId);
        }
        if (branch.startsWith("http")) {
            try {
                URL url = new URL(branch);
                return AppContext.domainNameUtils.toPrePopulatedRecordQuery(url.getHost(), this.moduleId);
            }
            catch (MalformedURLException e) {
                throw new NumBadURLException(branch);
            }
        }
        return AppContext.domainNameUtils.toPrePopulatedRecordQuery(branch, this.moduleId);
    }

    public void setRelativeRedirectPrepopulatedRecordLocation(String redirect, int levels) throws NumBadURLException, NumInvalidParameterException, NumInvalidRedirectException {
        if (this.rootQuery) {
            throw new NumInvalidRedirectException("Too many ^ symbols in redirect instruction");
        }
        String root = this.getPrepopulatedRootFromBranch(this.domainName);
        String[] parts = this.prepopulatedRecordLocation.split("\\.");
        if (levels < parts.length) {
            StringBuilder builder = new StringBuilder();
            builder.append(redirect);
            builder.append(".");
            for (int i = levels; i < parts.length; ++i) {
                builder.append(parts[i]);
                builder.append(".");
            }
            this.prepopulatedRecordLocation = builder.toString();
            if (!this.prepopulatedRecordLocation.endsWith(root)) {
                throw new NumInvalidRedirectException("Too many ^ symbols in redirect instruction");
            }
        } else {
            throw new NumInvalidRedirectException("Too many ^ symbols in redirect instruction");
        }
        this.rootQuery = false;
    }
}

