/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.internal.util;

import java.net.IDN;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import uk.num.numlib.exc.NumBadURLException;
import uk.num.numlib.exc.NumInvalidParameterException;
import uk.num.numlib.internal.ctx.AppContext;
import uk.num.numlib.internal.util.HashUtils;

public class DomainNameUtils {
    public String toIndependentRecordQuery(String domainName, String moduleId) throws NumBadURLException, NumInvalidParameterException {
        this.validateParams(domainName, moduleId);
        String normalisedDomain = this.normaliseDomainName(domainName);
        return String.format("%s%s%s.", moduleId, AppContext.stringConstants.UTILITY_MODULE_PREFIX(), normalisedDomain);
    }

    private void validateParams(String domainName, String moduleId) throws NumInvalidParameterException {
        if (domainName == null) {
            throw new NumInvalidParameterException("Cannot normalise a null domainName");
        }
        if (domainName.trim().isEmpty()) {
            throw new NumInvalidParameterException("The domainName cannot be empty");
        }
        if (moduleId == null) {
            throw new NumInvalidParameterException("The moduleId cannot be null");
        }
        if (moduleId.trim().isEmpty()) {
            throw new NumInvalidParameterException("The moduleId cannot be empty");
        }
    }

    public String toManagedRecordQuery(String domainName, String moduleId) throws NumInvalidParameterException, NumBadURLException {
        this.validateParams(domainName, moduleId);
        String normalisedDomain = this.normaliseDomainName(domainName);
        String hashValue = HashUtils.hash(normalisedDomain);
        return String.format("%s.%s%s%s%s.", moduleId, AppContext.stringConstants.DOMAIN_NAME_PREFIX(), normalisedDomain, hashValue, AppContext.stringConstants.MANAGED_RECORD_SUFFIX());
    }

    public String toPrePopulatedRecordQuery(String domainName, String moduleId) throws NumBadURLException, NumInvalidParameterException {
        this.validateParams(domainName, moduleId);
        String normalisedDomain = this.normaliseDomainName(domainName);
        String hashValue = HashUtils.hash(normalisedDomain);
        return String.format("%s.%s%s%s%s.", moduleId, AppContext.stringConstants.DOMAIN_NAME_PREFIX(), normalisedDomain, hashValue, AppContext.stringConstants.PREPOPULATED_RECORD_SUFFIX());
    }

    public String toPopulatorQuery(String domainName, String moduleId) throws NumBadURLException, NumInvalidParameterException {
        this.validateParams(domainName, moduleId);
        String normalisedDomain = this.normaliseDomainName(domainName);
        String hashValue = HashUtils.hash(normalisedDomain);
        return String.format("%s.%s%s%s%s.", moduleId, AppContext.stringConstants.DOMAIN_NAME_PREFIX(), normalisedDomain, hashValue, AppContext.stringConstants.POPULATOR_SERVICE_SUFFIX());
    }

    public String normaliseDomainName(String domainName) throws NumInvalidParameterException, NumBadURLException {
        if (domainName == null) {
            throw new NumInvalidParameterException("Null domain name cannot be normalised");
        }
        if (domainName.trim().isEmpty()) {
            throw new NumInvalidParameterException("Empty domain name cannot be normalised");
        }
        if (domainName.startsWith("http")) {
            try {
                URL url = new URL(domainName);
                String host = url.getHost();
                return this.normaliseDomainName(host);
            }
            catch (MalformedURLException e) {
                throw new NumBadURLException("Invalid URL: " + domainName);
            }
        }
        String result = domainName;
        if (result.startsWith("www.")) {
            result = result.substring(4);
        }
        if (result.startsWith(".")) {
            result = result.substring(1);
        }
        if (result.endsWith(".")) {
            result = result.substring(0, result.length() - 1);
        }
        if (!StringUtils.isAsciiPrintable((CharSequence)result)) {
            Object[] parts = result.split("\\.");
            for (int i = 0; i < parts.length; ++i) {
                if (StringUtils.isAsciiPrintable((CharSequence)parts[i])) continue;
                parts[i] = IDN.toASCII((String)parts[i]);
            }
            result = StringUtils.join((Object[])parts, (String)".");
        }
        return result;
    }
}

