/*
 * Decompiled with CFR 0.152.
 */
package uk.num.net;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import uk.num.net.NUMURLConnection;

public final class NumProtocolSupport {
    public static final String NUM_PROTOCOL = "num://";
    public static final String HTTPS_PROTOCOL = "https://";
    public static final String HTTP_PROTOCOL = "http://";
    public static final Pattern NUM_DOMAIN_REGEX = Pattern.compile("^(([^.\\s\f\t\r\b]+?\\.)*?([^!\"#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~\\s\f\t\r\b]+?\\.)([^!\"#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~\\s\f\t\r\b]+?))\\.??$");
    public static final Pattern NUM_PATH_REGEX = Pattern.compile("^(/[^;,/?:@&=+$.\\s]+?)*?/??$");
    public static final Pattern NUM_EMAIL_REGEX = Pattern.compile("^(?!\\s)[^@\f\t\r\b\n]+?(?<!\\s)@(([^.\\s\f\t\r\b\n]+?\\.)*?([^!\"#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~\\s\f\t\r\b\n]+?\\.)([^!\"#$%&'()*+,./:;<=>?@\\[\\]^_`{|}~\\s\f\t\r\b\n]+?))\\.??$");

    public static URL toUrl(String numAddress) throws MalformedURLException {
        String email;
        String lowerCase = numAddress.toLowerCase();
        URL result = lowerCase.startsWith(HTTPS_PROTOCOL) ? new URL(NUM_PROTOCOL + StringUtils.removeStart((String)numAddress, (String)HTTPS_PROTOCOL)) : (lowerCase.startsWith(HTTP_PROTOCOL) ? new URL(NUM_PROTOCOL + StringUtils.removeStart((String)numAddress, (String)HTTP_PROTOCOL)) : (!numAddress.startsWith(NUM_PROTOCOL) ? new URL(NUM_PROTOCOL + numAddress) : new URL(numAddress)));
        if (!NUM_DOMAIN_REGEX.matcher(result.getHost()).matches()) {
            throw new MalformedURLException("Invalid domain URI for the NUM protocol: " + numAddress);
        }
        if (!NUM_PATH_REGEX.matcher(result.getPath()).matches()) {
            throw new MalformedURLException("Invalid Path in the URI: " + numAddress);
        }
        if (StringUtils.isNotEmpty((CharSequence)result.getUserInfo()) && !NUM_EMAIL_REGEX.matcher(email = result.getUserInfo() + "@" + result.getHost()).matches()) {
            throw new MalformedURLException("Invalid email URI for the NUM protocol: " + numAddress);
        }
        return result;
    }

    public static void init() {
    }

    static {
        URL.setURLStreamHandlerFactory(new NumStreamHandlerFactory());
    }

    private static class NumStreamHandlerFactory
    implements URLStreamHandlerFactory {
        private NumStreamHandlerFactory() {
        }

        @Override
        public URLStreamHandler createURLStreamHandler(String protocol) {
            if ("num".equalsIgnoreCase(protocol)) {
                return new URLStreamHandler(){

                    @Override
                    protected URLConnection openConnection(URL u) {
                        return new NUMURLConnection(u);
                    }
                };
            }
            return null;
        }
    }
}

