/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.internal.module;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.num.numlib.exc.NumInvalidParameterException;
import uk.num.numlib.internal.module.ModuleDNSQueries;
import uk.num.numlib.internal.util.SimpleCache;

public final class ModuleFactory {
    private static final Logger log = LogManager.getLogger(ModuleFactory.class);
    private final SimpleCache<String, ModuleDNSQueries> moduleMap = new SimpleCache();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleDNSQueries getInstance(int moduleNumber, String numId) throws NumInvalidParameterException {
        ModuleDNSQueries result;
        if (moduleNumber < 0) {
            throw new NumInvalidParameterException("Module number should be >= 0 but is: " + moduleNumber);
        }
        String key = moduleNumber + "_" + numId;
        SimpleCache<String, ModuleDNSQueries> simpleCache = this.moduleMap;
        synchronized (simpleCache) {
            result = this.moduleMap.get(key);
            if (result == null) {
                result = new ModuleDNSQueries(moduleNumber, numId);
                result.initialise();
                this.moduleMap.put(key, result);
                log.trace("Cached a new set of ModuleDNSQueries.");
            } else {
                log.trace("Using cached ModuleDNSQueries.");
            }
        }
        return result;
    }
}

