/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.zed.library;

import us.ihmc.tools.nativelibraries.NativeLibraryDescription;
import us.ihmc.tools.nativelibraries.NativeLibraryLoader;
import us.ihmc.tools.nativelibraries.NativeLibraryWithDependencies;

public class ZEDJavaAPINativeLibrary
implements NativeLibraryDescription {
    private static boolean loaded = false;

    public String getPackage(NativeLibraryDescription.OperatingSystem os, NativeLibraryDescription.Architecture arch) {
        String archPackage = "";
        if (arch == NativeLibraryDescription.Architecture.x64) {
            archPackage = switch (os) {
                default -> throw new IncompatibleClassChangeError();
                case NativeLibraryDescription.OperatingSystem.WIN64 -> "windows-x86_64";
                case NativeLibraryDescription.OperatingSystem.MACOSX64 -> throw new RuntimeException("Unsupported platform");
                case NativeLibraryDescription.OperatingSystem.LINUX64 -> "linux-x86_64";
            };
        } else if (arch == NativeLibraryDescription.Architecture.arm64) {
            switch (os) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case WIN64: 
                case MACOSX64: {
                    throw new RuntimeException("Unsupported platform");
                }
                case LINUX64: 
            }
            archPackage = "linux-arm64";
        }
        return "zed-java-api.native." + archPackage;
    }

    public NativeLibraryWithDependencies getLibraryWithDependencies(NativeLibraryDescription.OperatingSystem os, NativeLibraryDescription.Architecture arch) {
        switch (os) {
            case LINUX64: {
                return NativeLibraryWithDependencies.fromFilename((String)"libjnized.so", (String[])new String[]{"libsl_zed_c.so"});
            }
            case WIN64: {
                return NativeLibraryWithDependencies.fromFilename((String)"jnized.dll", (String[])new String[]{"sl_zed_c.dll"});
            }
            case MACOSX64: {
                throw new RuntimeException("Unsupported platform");
            }
        }
        return null;
    }

    public static boolean load() {
        if (!loaded) {
            ZEDJavaAPINativeLibrary lib = new ZEDJavaAPINativeLibrary();
            loaded = NativeLibraryLoader.loadLibrary((NativeLibraryDescription)lib);
        }
        return loaded;
    }
}

