/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.zed.library;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import us.ihmc.tools.nativelibraries.NativeLibraryDescription;
import us.ihmc.tools.nativelibraries.NativeLibraryLoader;
import us.ihmc.tools.nativelibraries.NativeLibraryWithDependencies;

public class ZEDJavaAPINativeLibrary
implements NativeLibraryDescription {
    private static final int ZED_SDK_COMPATIBILITY_MAJOR_VERSION = 4;
    private static final int ZED_SDK_COMPATIBILITY_MINOR_VERSION = 2;
    private static boolean loaded = false;

    public String getPackage(NativeLibraryDescription.OperatingSystem os, NativeLibraryDescription.Architecture arch) {
        String archPackage = "";
        if (arch == NativeLibraryDescription.Architecture.x64) {
            archPackage = switch (os) {
                default -> throw new IncompatibleClassChangeError();
                case NativeLibraryDescription.OperatingSystem.WIN64 -> "windows-x86_64";
                case NativeLibraryDescription.OperatingSystem.MACOSX64 -> throw new RuntimeException("Unsupported platform");
                case NativeLibraryDescription.OperatingSystem.LINUX64 -> "linux-x86_64";
            };
        } else if (arch == NativeLibraryDescription.Architecture.arm64) {
            switch (os) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case WIN64: 
                case MACOSX64: {
                    throw new RuntimeException("Unsupported platform");
                }
                case LINUX64: 
            }
            archPackage = "linux-arm64";
        }
        return "zed-java-api.native." + archPackage;
    }

    public NativeLibraryWithDependencies getLibraryWithDependencies(NativeLibraryDescription.OperatingSystem os, NativeLibraryDescription.Architecture arch) {
        switch (os) {
            case LINUX64: {
                return NativeLibraryWithDependencies.fromFilename((String)"libjnized.so", (String[])new String[]{"libsl_zed_c.so"});
            }
            case WIN64: {
                return NativeLibraryWithDependencies.fromFilename((String)"jnized.dll", (String[])new String[]{"sl_zed_c.dll"});
            }
            case MACOSX64: {
                throw new RuntimeException("Unsupported platform");
            }
        }
        return null;
    }

    public static boolean load() {
        String installedZEDSDKVersion = ZEDJavaAPINativeLibrary.getZEDSDKCMakePackageVersion();
        int installedZEDSDKMajorVersion = 0;
        int installedZEDSDKMinorVersion = 0;
        if (installedZEDSDKVersion != null) {
            String[] installedZEDSDKVersionParts = installedZEDSDKVersion.split("\\.");
            try {
                installedZEDSDKMajorVersion = Integer.parseInt(installedZEDSDKVersionParts[0]);
                installedZEDSDKMinorVersion = Integer.parseInt(installedZEDSDKVersionParts[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (installedZEDSDKMajorVersion > 4 || installedZEDSDKMajorVersion == 4 && installedZEDSDKMinorVersion >= 2) {
            if (!loaded) {
                ZEDJavaAPINativeLibrary lib = new ZEDJavaAPINativeLibrary();
                loaded = NativeLibraryLoader.loadLibrary((NativeLibraryDescription)lib);
            }
        } else {
            System.err.println("Incompatible ZED SDK installation (" + installedZEDSDKVersion + ") found. Please install 4.2 or higher.");
        }
        return loaded;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getZEDSDKCMakePackageVersion() {
        String cmakePackageFile = System.getProperty("os.name").contains("Windows") ? "C:/Program Files (x86)/ZED SDK/zed-config-version.cmake" : "/usr/local/zed/zed-config-version.cmake";
        try (BufferedReader br = new BufferedReader(new FileReader(cmakePackageFile));){
            String line;
            Matcher matcher;
            Pattern pattern = Pattern.compile("set\\(PACKAGE_VERSION \"(\\d+\\.\\d+\\.\\d+)\"\\)");
            do {
                if ((line = br.readLine()) == null) return null;
            } while (!(matcher = pattern.matcher(line)).find());
            String string = matcher.group(1).trim();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

