/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.zed;

import us.ihmc.zed.ZEDException;

public final class ZEDTools {
    public static String errorName(int zedErrorCode) {
        return switch (zedErrorCode) {
            case -2 -> "SL_ERROR_CODE_CORRUPTED_FRAME";
            case -1 -> "SL_ERROR_CODE_CAMERA_REBOOTING";
            case 0 -> "SL_ERROR_CODE_SUCCESS";
            case 1 -> "SL_ERROR_CODE_FAILURE";
            case 2 -> "SL_ERROR_CODE_NO_GPU_COMPATIBLE";
            case 3 -> "SL_ERROR_CODE_NOT_ENOUGH_GPU_MEMORY";
            case 4 -> "SL_ERROR_CODE_CAMERA_NOT_DETECTED";
            case 5 -> "SL_ERROR_CODE_SENSORS_NOT_INITIALIZED";
            case 6 -> "SL_ERROR_CODE_SENSORS_NOT_AVAILABLE";
            case 7 -> "SL_ERROR_CODE_INVALID_RESOLUTION";
            case 8 -> "SL_ERROR_CODE_LOW_USB_BANDWIDTH";
            case 9 -> "SL_ERROR_CODE_CALIBRATION_FILE_NOT_AVAILABLE";
            case 10 -> "SL_ERROR_CODE_INVALID_CALIBRATION_FILE";
            case 11 -> "SL_ERROR_CODE_INVALID_SVO_FILE";
            case 12 -> "SL_ERROR_CODE_SVO_RECORDING_ERROR";
            case 13 -> "SL_ERROR_CODE_SVO_UNSUPPORTED_COMPRESSION";
            case 14 -> "SL_ERROR_CODE_END_OF_SVOFILE_REACHED";
            case 15 -> "SL_ERROR_CODE_INVALID_COORDINATE_SYSTEM";
            case 16 -> "SL_ERROR_CODE_INVALID_FIRMWARE";
            case 17 -> "SL_ERROR_CODE_INVALID_FUNCTION_PARAMETERS";
            case 18 -> "SL_ERROR_CODE_CUDA_ERROR";
            case 19 -> "SL_ERROR_CODE_CAMERA_NOT_INITIALIZED";
            case 20 -> "SL_ERROR_CODE_NVIDIA_DRIVER_OUT_OF_DATE";
            case 21 -> "SL_ERROR_CODE_INVALID_FUNCTION_CALL";
            case 22 -> "SL_ERROR_CODE_CORRUPTED_SDK_INSTALLATION";
            case 23 -> "SL_ERROR_CODE_INCOMPATIBLE_SDK_VERSION";
            case 24 -> "SL_ERROR_CODE_INVALID_AREA_FILE";
            case 25 -> "SL_ERROR_CODE_INCOMPATIBLE_AREA_FILE";
            case 26 -> "SL_ERROR_CODE_CAMERA_FAILED_TO_SETUP";
            case 27 -> "SL_ERROR_CODE_CAMERA_DETECTION_ISSUE";
            case 28 -> "SL_ERROR_CODE_CANNOT_START_CAMERA_STREAM";
            case 29 -> "SL_ERROR_CODE_NO_GPU_DETECTED";
            case 30 -> "SL_ERROR_CODE_PLANE_NOT_FOUND";
            case 31 -> "SL_ERROR_CODE_MODULE_NOT_COMPATIBLE_WITH_CAMERA";
            case 32 -> "SL_ERROR_CODE_MOTION_SENSORS_REQUIRED";
            case 33 -> "SL_ERROR_CODE_MODULE_NOT_COMPATIBLE_WITH_CUDA_VERSION";
            case -3 -> "SL_ERROR_CODE_SENSORS_DATA_REQUIRED";
            case -4 -> "SL_ERROR_CODE_CONFIGURATION_FALLBACK";
            default -> "UNKNOWN";
        };
    }

    public static String errorMessage(int zedErrorCode) {
        return "ZED Error (%d): %s".formatted(zedErrorCode, ZEDTools.errorName(zedErrorCode));
    }

    public static void throwOnError(int zedErrorCode) throws ZEDException {
        if (zedErrorCode != 0) {
            throw new ZEDException(zedErrorCode);
        }
    }
}

