/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.fcmjava.client.utils;

import com.fasterxml.jackson.databind.ObjectMapper;

public class JsonUtils {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static <TEntity> String getAsJsonString(TEntity source) {
        try {
            return JsonUtils.internalGetAsJsonString(source);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <TEntity> TEntity getEntityFromString(String source, Class<TEntity> valueType) {
        try {
            return JsonUtils.internalGetEntityFromString(source, valueType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static <TEntity> String internalGetAsJsonString(TEntity source) throws Exception {
        if (source == null) {
            throw new IllegalArgumentException("source");
        }
        return mapper.writeValueAsString(source);
    }

    private static <TEntity> TEntity internalGetEntityFromString(String source, Class<TEntity> valueType) throws Exception {
        return (TEntity)mapper.readValue(source, valueType);
    }
}

