/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator;

import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import dev.amp.validator.ValidatorProtos;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;

public final class AMPValidatorLoader {
    private static final String PROTO_ASCII_RESOURCE = "validator-all.protoascii";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValidatorProtos.ValidatorRules.Builder load(String filePath) throws IOException, URISyntaxException {
        ValidatorProtos.ValidatorRules.Builder builder;
        InputStream is;
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (filePath == null) {
            is = classLoader.getResourceAsStream(PROTO_ASCII_RESOURCE);
            if (is == null) {
                throw new IllegalArgumentException("validator-all.protoascii file is not found!");
            }
        } else {
            is = classLoader.getResourceAsStream(filePath);
        }
        try {
            StringBuilder protoAsciiRules = new StringBuilder();
            protoAsciiRules.append(this.getFileContent(is));
            TextFormat.Parser parser = TextFormat.Parser.newBuilder().setAllowUnknownFields(true).setAllowUnknownExtensions(true).build();
            builder = ValidatorProtos.ValidatorRules.newBuilder();
            parser.merge((CharSequence)protoAsciiRules.toString(), (Message.Builder)builder);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return builder;
    }

    private String getFileContent(@Nonnull InputStream is) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader buf = new BufferedReader(new InputStreamReader(is));){
            String line = buf.readLine();
            while (line != null) {
                sb.append(line).append("\n");
                line = buf.readLine();
            }
        }
        return sb.toString();
    }
}

