/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr.codecs;

import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprOverrideCodec;
import dev.argon.esexpr.ESExprTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@ESExprOverrideCodec(value=List.class)
public class ListCodec<T>
extends ESExprCodec<List<T>> {
    private final ESExprCodec<T> itemCodec;

    public ListCodec(ESExprCodec<T> itemCodec) {
        this.itemCodec = itemCodec;
    }

    @Override
    @NotNull
    public @NotNull Set<@NotNull ESExprTag> tags() {
        return Set.of(new ESExprTag.Constructor("list"));
    }

    @Override
    @NotNull
    public ESExpr encode(@NotNull List<T> value) {
        return new ESExpr.Constructor("list", value.stream().map(this.itemCodec::encode).toList(), new HashMap<String, ESExpr>());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public List<T> decode(@NotNull ESExpr expr, @NotNull ESExprCodec.FailurePath path) throws DecodeException {
        Map<String, ESExpr> args;
        block5: {
            if (!(expr instanceof ESExpr.Constructor)) throw new DecodeException("Expected a list constructor", path);
            ESExpr.Constructor constructor = (ESExpr.Constructor)expr;
            Map<String, ESExpr> map = constructor.constructor();
            String name = map;
            args = map = constructor.args();
            try {
                Map<String, ESExpr> kwargs = map = constructor.kwargs();
                if (!name.equals("list")) throw new DecodeException("Expected a list constructor", path);
                if (kwargs.isEmpty()) break block5;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            throw new DecodeException("Unexpected keyword arguments for list.", path.withConstructor("list"));
        }
        ArrayList<T> res = new ArrayList<T>(args.size());
        int i = 0;
        Iterator iterator = args.iterator();
        while (iterator.hasNext()) {
            ESExpr item = (ESExpr)iterator.next();
            res.add(this.itemCodec.decode(item, path.append("list", i)));
            ++i;
        }
        return res;
    }
}

