/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr.codecs;

import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprCodecOverrideList;
import dev.argon.esexpr.ESExprCodecTags;
import dev.argon.esexpr.ESExprOverrideCodec;
import dev.argon.esexpr.ESExprTag;
import dev.argon.esexpr.Unsigned;
import dev.argon.esexpr.codecs.IntCodecBase;
import java.math.BigInteger;

public class UnsignedByteCodec
extends IntCodecBase<Byte> {
    @ESExprCodecOverrideList(value={@ESExprOverrideCodec(value=byte.class, requiredAnnotations={Unsigned.class}), @ESExprOverrideCodec(value=Byte.class, requiredAnnotations={Unsigned.class})})
    @ESExprCodecTags(scalar={ESExprTag.Scalar.INT})
    public static final ESExprCodec<Byte> INSTANCE = new UnsignedByteCodec();

    private UnsignedByteCodec() {
        super(BigInteger.ZERO, BigInteger.valueOf(255L));
    }

    @Override
    public boolean isEncodedEqual(Byte x, Byte y) {
        return x.byteValue() == y.byteValue();
    }

    @Override
    protected Byte fromBigInt(BigInteger value) {
        return value.byteValue();
    }

    @Override
    protected BigInteger toBigInt(Byte value) {
        return BigInteger.valueOf(Byte.toUnsignedLong(value));
    }
}

