/*
 * Decompiled with CFR 0.152.
 */
package dev.argon.esexpr.codecs;

import dev.argon.esexpr.DecodeException;
import dev.argon.esexpr.ESExpr;
import dev.argon.esexpr.ESExprCodec;
import dev.argon.esexpr.ESExprCodecTags;
import dev.argon.esexpr.ESExprOverrideCodec;
import dev.argon.esexpr.ESExprTag;
import dev.argon.esexpr.ESExprTagSet;
import org.eclipse.collections.api.list.primitive.ImmutableLongList;

public class ImmutableLongListCodec
extends ESExprCodec<ImmutableLongList> {
    @ESExprOverrideCodec(value=ImmutableLongList.class)
    @ESExprCodecTags(scalar={ESExprTag.Scalar.ARRAY64})
    public static final ESExprCodec<ImmutableLongList> INSTANCE = new ImmutableLongListCodec();

    private ImmutableLongListCodec() {
    }

    @Override
    public ESExprTagSet tags() {
        return ESExprTagSet.of(ESExprTag.ARRAY64);
    }

    @Override
    public boolean isEncodedEqual(ImmutableLongList x, ImmutableLongList y) {
        return x.equals((Object)y);
    }

    @Override
    public ESExpr encode(ImmutableLongList value) {
        return new ESExpr.Array64(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ImmutableLongList decode(ESExpr expr, ESExprCodec.FailurePath path) throws DecodeException {
        if (!(expr instanceof ESExpr.Array64)) throw new DecodeException("Expected an array64 value", path);
        ESExpr.Array64 array64 = (ESExpr.Array64)expr;
        try {
            ImmutableLongList immutableLongList = array64.b();
            return immutableLongList;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }
}

