/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.fnjl.math;

import dev.felnull.fnjl.math.FNVec2i;
import java.util.Objects;

public class FNVec2d {
    private double x;
    private double y;

    public FNVec2d(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double distance(FNVec2i vec) {
        return Math.sqrt(Math.pow(this.x - (double)vec.getX(), 2.0) + Math.pow(this.y - (double)vec.getY(), 2.0));
    }

    public FNVec2d add(FNVec2d vec) {
        this.x += vec.getX();
        this.y += vec.getY();
        return this;
    }

    public FNVec2d sub(FNVec2d vec) {
        this.x -= vec.getX();
        this.y -= vec.getY();
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FNVec2d fnVec2d = (FNVec2d)o;
        return Double.compare(fnVec2d.x, this.x) == 0 && Double.compare(fnVec2d.y, this.y) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public String toString() {
        return "FNVec2d{x=" + this.x + ", y=" + this.y + '}';
    }
}

