/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.core;

import android.app.Activity;
import android.app.Fragment;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import com.google.firebase.firestore.ListenerRegistration;
import com.google.firebase.firestore.util.Assert;
import java.util.ArrayList;
import java.util.List;

public class ActivityScope {
    private static final String SUPPORT_FRAGMENT_TAG = "FirestoreOnStopObserverSupportFragment";
    private static final String FRAGMENT_TAG = "FirestoreOnStopObserverFragment";

    @Nullable
    private static <T> T castFragment(Class<T> fragmentClass, @Nullable Object fragment, String tag) {
        try {
            if (fragment == null) {
                return null;
            }
            return fragmentClass.cast(fragment);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Fragment with tag '" + tag + "' is a " + fragment.getClass().getName() + " but should be a " + fragmentClass.getName());
        }
    }

    private static void onActivityStopCallOnce(Activity activity, Runnable callback) {
        Assert.hardAssert(!(activity instanceof FragmentActivity), "onActivityStopCallOnce must be called with a *non*-FragmentActivity Activity.", new Object[0]);
        activity.runOnUiThread(() -> {
            StopListenerFragment fragment = ActivityScope.castFragment(StopListenerFragment.class, activity.getFragmentManager().findFragmentByTag(FRAGMENT_TAG), FRAGMENT_TAG);
            if (fragment == null || fragment.isRemoving()) {
                fragment = new StopListenerFragment();
                activity.getFragmentManager().beginTransaction().add((Fragment)fragment, FRAGMENT_TAG).commitAllowingStateLoss();
                activity.getFragmentManager().executePendingTransactions();
            }
            fragment.callbacks.add(callback);
        });
    }

    private static void onFragmentActivityStopCallOnce(FragmentActivity activity, Runnable callback) {
        activity.runOnUiThread(() -> {
            StopListenerSupportFragment fragment = ActivityScope.castFragment(StopListenerSupportFragment.class, activity.getSupportFragmentManager().findFragmentByTag(SUPPORT_FRAGMENT_TAG), SUPPORT_FRAGMENT_TAG);
            if (fragment == null || fragment.isRemoving()) {
                fragment = new StopListenerSupportFragment();
                activity.getSupportFragmentManager().beginTransaction().add(fragment, SUPPORT_FRAGMENT_TAG).commitAllowingStateLoss();
                activity.getSupportFragmentManager().executePendingTransactions();
            }
            fragment.callbacks.add(callback);
        });
    }

    public static ListenerRegistration bind(@Nullable Activity activity, ListenerRegistration registration) {
        if (activity != null) {
            if (activity instanceof FragmentActivity) {
                ActivityScope.onFragmentActivityStopCallOnce((FragmentActivity)activity, registration::remove);
            } else {
                ActivityScope.onActivityStopCallOnce(activity, registration::remove);
            }
        }
        return registration;
    }

    public static class StopListenerFragment
    extends Fragment {
        CallbackList callbacks = new CallbackList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onStop() {
            CallbackList callbacksCopy;
            super.onStop();
            CallbackList callbackList = this.callbacks;
            synchronized (callbackList) {
                callbacksCopy = this.callbacks;
                this.callbacks = new CallbackList();
            }
            callbacksCopy.run();
        }
    }

    public static class StopListenerSupportFragment
    extends androidx.fragment.app.Fragment {
        CallbackList callbacks = new CallbackList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStop() {
            CallbackList callbacksCopy;
            super.onStop();
            CallbackList callbackList = this.callbacks;
            synchronized (callbackList) {
                callbacksCopy = this.callbacks;
                this.callbacks = new CallbackList();
            }
            callbacksCopy.run();
        }
    }

    private static class CallbackList {
        private final List<Runnable> callbacks = new ArrayList<Runnable>();

        private CallbackList() {
        }

        void run() {
            for (Runnable callback : this.callbacks) {
                if (callback == null) continue;
                callback.run();
            }
        }

        synchronized void add(Runnable callback) {
            this.callbacks.add(callback);
        }
    }
}

