/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.encoders.json;

import android.util.Base64;
import android.util.JsonWriter;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.encoders.EncodingException;
import com.google.firebase.encoders.FieldDescriptor;
import com.google.firebase.encoders.ObjectEncoder;
import com.google.firebase.encoders.ObjectEncoderContext;
import com.google.firebase.encoders.ValueEncoder;
import com.google.firebase.encoders.ValueEncoderContext;
import com.google.firebase.encoders.json.NumberedEnum;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

final class JsonValueObjectEncoderContext
implements ObjectEncoderContext,
ValueEncoderContext {
    private JsonValueObjectEncoderContext childContext = null;
    private boolean active = true;
    private final JsonWriter jsonWriter;
    private final Map<Class<?>, ObjectEncoder<?>> objectEncoders;
    private final Map<Class<?>, ValueEncoder<?>> valueEncoders;
    private final ObjectEncoder<Object> fallbackEncoder;
    private final boolean ignoreNullValues;

    JsonValueObjectEncoderContext(@NonNull Writer writer, @NonNull Map<Class<?>, ObjectEncoder<?>> objectEncoders, @NonNull Map<Class<?>, ValueEncoder<?>> valueEncoders, ObjectEncoder<Object> fallbackEncoder, boolean ignoreNullValues) {
        this.jsonWriter = new JsonWriter(writer);
        this.objectEncoders = objectEncoders;
        this.valueEncoders = valueEncoders;
        this.fallbackEncoder = fallbackEncoder;
        this.ignoreNullValues = ignoreNullValues;
    }

    private JsonValueObjectEncoderContext(JsonValueObjectEncoderContext anotherContext) {
        this.jsonWriter = anotherContext.jsonWriter;
        this.objectEncoders = anotherContext.objectEncoders;
        this.valueEncoders = anotherContext.valueEncoders;
        this.fallbackEncoder = anotherContext.fallbackEncoder;
        this.ignoreNullValues = anotherContext.ignoreNullValues;
    }

    @NonNull
    public JsonValueObjectEncoderContext add(@NonNull String name, @Nullable Object o) throws IOException {
        if (this.ignoreNullValues) {
            return this.internalAddIgnoreNullValues(name, o);
        }
        return this.internalAdd(name, o);
    }

    @NonNull
    public JsonValueObjectEncoderContext add(@NonNull String name, double value) throws IOException {
        this.maybeUnNest();
        this.jsonWriter.name(name);
        return this.add(value);
    }

    @NonNull
    public JsonValueObjectEncoderContext add(@NonNull String name, int value) throws IOException {
        this.maybeUnNest();
        this.jsonWriter.name(name);
        return this.add(value);
    }

    @NonNull
    public JsonValueObjectEncoderContext add(@NonNull String name, long value) throws IOException {
        this.maybeUnNest();
        this.jsonWriter.name(name);
        return this.add(value);
    }

    @NonNull
    public JsonValueObjectEncoderContext add(@NonNull String name, boolean value) throws IOException {
        this.maybeUnNest();
        this.jsonWriter.name(name);
        return this.add(value);
    }

    @NonNull
    public ObjectEncoderContext add(@NonNull FieldDescriptor field, @Nullable Object obj) throws IOException {
        return this.add(field.getName(), obj);
    }

    @NonNull
    public ObjectEncoderContext add(@NonNull FieldDescriptor field, float value) throws IOException {
        return this.add(field.getName(), (double)value);
    }

    @NonNull
    public ObjectEncoderContext add(@NonNull FieldDescriptor field, double value) throws IOException {
        return this.add(field.getName(), value);
    }

    @NonNull
    public ObjectEncoderContext add(@NonNull FieldDescriptor field, int value) throws IOException {
        return this.add(field.getName(), value);
    }

    @NonNull
    public ObjectEncoderContext add(@NonNull FieldDescriptor field, long value) throws IOException {
        return this.add(field.getName(), value);
    }

    @NonNull
    public ObjectEncoderContext add(@NonNull FieldDescriptor field, boolean value) throws IOException {
        return this.add(field.getName(), value);
    }

    @NonNull
    public ObjectEncoderContext inline(@Nullable Object value) throws IOException {
        return this.add(value, true);
    }

    @NonNull
    public ObjectEncoderContext nested(@NonNull String name) throws IOException {
        this.maybeUnNest();
        this.childContext = new JsonValueObjectEncoderContext(this);
        this.jsonWriter.name(name);
        this.jsonWriter.beginObject();
        return this.childContext;
    }

    @NonNull
    public ObjectEncoderContext nested(@NonNull FieldDescriptor field) throws IOException {
        return this.nested(field.getName());
    }

    @NonNull
    public JsonValueObjectEncoderContext add(@Nullable String value) throws IOException {
        this.maybeUnNest();
        this.jsonWriter.value(value);
        return this;
    }

    @NonNull
    public JsonValueObjectEncoderContext add(float value) throws IOException {
        this.maybeUnNest();
        this.jsonWriter.value((double)value);
        return this;
    }

    @NonNull
    public JsonValueObjectEncoderContext add(double value) throws IOException {
        this.maybeUnNest();
        this.jsonWriter.value(value);
        return this;
    }

    @NonNull
    public JsonValueObjectEncoderContext add(int value) throws IOException {
        this.maybeUnNest();
        this.jsonWriter.value((long)value);
        return this;
    }

    @NonNull
    public JsonValueObjectEncoderContext add(long value) throws IOException {
        this.maybeUnNest();
        this.jsonWriter.value(value);
        return this;
    }

    @NonNull
    public JsonValueObjectEncoderContext add(boolean value) throws IOException {
        this.maybeUnNest();
        this.jsonWriter.value(value);
        return this;
    }

    @NonNull
    public JsonValueObjectEncoderContext add(@Nullable byte[] bytes) throws IOException {
        this.maybeUnNest();
        if (bytes == null) {
            this.jsonWriter.nullValue();
        } else {
            this.jsonWriter.value(Base64.encodeToString(bytes, 2));
        }
        return this;
    }

    @NonNull
    JsonValueObjectEncoderContext add(@Nullable Object o, boolean inline) throws IOException {
        if (inline && this.cannotBeInline(o)) {
            throw new EncodingException(String.format("%s cannot be encoded inline", o == null ? null : o.getClass()));
        }
        if (o == null) {
            this.jsonWriter.nullValue();
            return this;
        }
        if (o instanceof Number) {
            this.jsonWriter.value((Number)o);
            return this;
        }
        if (o.getClass().isArray()) {
            if (o instanceof byte[]) {
                return this.add((byte[])o);
            }
            this.jsonWriter.beginArray();
            if (o instanceof int[]) {
                for (int item : (int[])o) {
                    this.jsonWriter.value((long)item);
                }
            } else if (o instanceof long[]) {
                for (long item : (long[])o) {
                    this.add(item);
                }
            } else if (o instanceof double[]) {
                for (double item : (double[])o) {
                    this.jsonWriter.value(item);
                }
            } else if (o instanceof boolean[]) {
                for (boolean item : (boolean[])o) {
                    this.jsonWriter.value(item);
                }
            } else if (o instanceof Number[]) {
                for (Number item : (Number[])o) {
                    this.add(item, false);
                }
            } else {
                for (Object item : (Object[])o) {
                    this.add(item, false);
                }
            }
            this.jsonWriter.endArray();
            return this;
        }
        if (o instanceof Collection) {
            Collection collection = (Collection)o;
            this.jsonWriter.beginArray();
            for (Object elem : collection) {
                this.add(elem, false);
            }
            this.jsonWriter.endArray();
            return this;
        }
        if (o instanceof Map) {
            Map map2 = (Map)o;
            this.jsonWriter.beginObject();
            for (Map.Entry entry : map2.entrySet()) {
                Object key = entry.getKey();
                try {
                    this.add((String)key, entry.getValue());
                }
                catch (ClassCastException ex) {
                    throw new EncodingException(String.format("Only String keys are currently supported in maps, got %s of type %s instead.", key, key.getClass()), (Exception)ex);
                }
            }
            this.jsonWriter.endObject();
            return this;
        }
        ObjectEncoder<?> objectEncoder = this.objectEncoders.get(o.getClass());
        if (objectEncoder != null) {
            return this.doEncode(objectEncoder, o, inline);
        }
        ValueEncoder<?> valueEncoder = this.valueEncoders.get(o.getClass());
        if (valueEncoder != null) {
            valueEncoder.encode(o, (Object)this);
            return this;
        }
        if (o instanceof Enum) {
            if (o instanceof NumberedEnum) {
                this.add(((NumberedEnum)o).getNumber());
            } else {
                this.add(((Enum)o).name());
            }
            return this;
        }
        return this.doEncode(this.fallbackEncoder, o, inline);
    }

    JsonValueObjectEncoderContext doEncode(ObjectEncoder<Object> encoder, Object o, boolean inline) throws IOException {
        if (!inline) {
            this.jsonWriter.beginObject();
        }
        encoder.encode(o, (Object)this);
        if (!inline) {
            this.jsonWriter.endObject();
        }
        return this;
    }

    private boolean cannotBeInline(Object value) {
        return value == null || value.getClass().isArray() || value instanceof Collection || value instanceof Date || value instanceof Enum || value instanceof Number;
    }

    void close() throws IOException {
        this.maybeUnNest();
        this.jsonWriter.flush();
    }

    private void maybeUnNest() throws IOException {
        if (!this.active) {
            throw new IllegalStateException("Parent context used since this context was created. Cannot use this context anymore.");
        }
        if (this.childContext != null) {
            this.childContext.maybeUnNest();
            this.childContext.active = false;
            this.childContext = null;
            this.jsonWriter.endObject();
        }
    }

    private JsonValueObjectEncoderContext internalAdd(@NonNull String name, @Nullable Object o) throws IOException, EncodingException {
        this.maybeUnNest();
        this.jsonWriter.name(name);
        if (o == null) {
            this.jsonWriter.nullValue();
            return this;
        }
        return this.add(o, false);
    }

    private JsonValueObjectEncoderContext internalAddIgnoreNullValues(@NonNull String name, @Nullable Object o) throws IOException, EncodingException {
        if (o == null) {
            return this;
        }
        this.maybeUnNest();
        this.jsonWriter.name(name);
        return this.add(o, false);
    }
}

