/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore.local;

import com.google.firebase.firestore.auth.User;
import com.google.firebase.firestore.local.BundleCache;
import com.google.firebase.firestore.local.DocumentOverlayCache;
import com.google.firebase.firestore.local.IndexManager;
import com.google.firebase.firestore.local.LocalSerializer;
import com.google.firebase.firestore.local.LruGarbageCollector;
import com.google.firebase.firestore.local.MemoryBundleCache;
import com.google.firebase.firestore.local.MemoryDocumentOverlayCache;
import com.google.firebase.firestore.local.MemoryEagerReferenceDelegate;
import com.google.firebase.firestore.local.MemoryIndexManager;
import com.google.firebase.firestore.local.MemoryLruReferenceDelegate;
import com.google.firebase.firestore.local.MemoryMutationQueue;
import com.google.firebase.firestore.local.MemoryOverlayMigrationManager;
import com.google.firebase.firestore.local.MemoryRemoteDocumentCache;
import com.google.firebase.firestore.local.MemoryTargetCache;
import com.google.firebase.firestore.local.MutationQueue;
import com.google.firebase.firestore.local.OverlayMigrationManager;
import com.google.firebase.firestore.local.Persistence;
import com.google.firebase.firestore.local.ReferenceDelegate;
import com.google.firebase.firestore.util.Assert;
import com.google.firebase.firestore.util.Supplier;
import java.util.HashMap;
import java.util.Map;

public final class MemoryPersistence
extends Persistence {
    private final Map<User, MemoryMutationQueue> mutationQueues = new HashMap<User, MemoryMutationQueue>();
    private final Map<User, MemoryDocumentOverlayCache> overlays;
    private final MemoryIndexManager indexManager = new MemoryIndexManager();
    private final MemoryTargetCache targetCache = new MemoryTargetCache(this);
    private final MemoryBundleCache bundleCache = new MemoryBundleCache();
    private final MemoryRemoteDocumentCache remoteDocumentCache = new MemoryRemoteDocumentCache();
    private ReferenceDelegate referenceDelegate;
    private boolean started;

    public static MemoryPersistence createEagerGcMemoryPersistence() {
        MemoryPersistence persistence = new MemoryPersistence();
        persistence.setReferenceDelegate(new MemoryEagerReferenceDelegate(persistence));
        return persistence;
    }

    public static MemoryPersistence createLruGcMemoryPersistence(LruGarbageCollector.Params params, LocalSerializer serializer2) {
        MemoryPersistence persistence = new MemoryPersistence();
        persistence.setReferenceDelegate(new MemoryLruReferenceDelegate(persistence, params, serializer2));
        return persistence;
    }

    private MemoryPersistence() {
        this.overlays = new HashMap<User, MemoryDocumentOverlayCache>();
    }

    @Override
    public void start() {
        Assert.hardAssert(!this.started, "MemoryPersistence double-started!", new Object[0]);
        this.started = true;
    }

    @Override
    public void shutdown() {
        Assert.hardAssert(this.started, "MemoryPersistence shutdown without start", new Object[0]);
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public ReferenceDelegate getReferenceDelegate() {
        return this.referenceDelegate;
    }

    private void setReferenceDelegate(ReferenceDelegate delegate) {
        this.referenceDelegate = delegate;
    }

    @Override
    MutationQueue getMutationQueue(User user2, IndexManager indexManager) {
        MemoryMutationQueue queue = this.mutationQueues.get(user2);
        if (queue == null) {
            queue = new MemoryMutationQueue(this, user2);
            this.mutationQueues.put(user2, queue);
        }
        return queue;
    }

    Iterable<MemoryMutationQueue> getMutationQueues() {
        return this.mutationQueues.values();
    }

    @Override
    MemoryTargetCache getTargetCache() {
        return this.targetCache;
    }

    @Override
    MemoryRemoteDocumentCache getRemoteDocumentCache() {
        return this.remoteDocumentCache;
    }

    @Override
    MemoryIndexManager getIndexManager(User user2) {
        return this.indexManager;
    }

    @Override
    BundleCache getBundleCache() {
        return this.bundleCache;
    }

    @Override
    DocumentOverlayCache getDocumentOverlayCache(User user2) {
        MemoryDocumentOverlayCache overlay = this.overlays.get(user2);
        if (overlay == null) {
            overlay = new MemoryDocumentOverlayCache();
            this.overlays.put(user2, overlay);
        }
        return overlay;
    }

    @Override
    OverlayMigrationManager getOverlayMigrationManager() {
        return new MemoryOverlayMigrationManager();
    }

    @Override
    void runTransaction(String action, Runnable operation) {
        this.referenceDelegate.onTransactionStarted();
        try {
            operation.run();
        }
        finally {
            this.referenceDelegate.onTransactionCommitted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <T> T runTransaction(String action, Supplier<T> operation) {
        T result;
        this.referenceDelegate.onTransactionStarted();
        try {
            result = operation.get();
        }
        finally {
            this.referenceDelegate.onTransactionCommitted();
        }
        return result;
    }
}

