/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.tracing;

import com.google.firebase.components.Component;
import com.google.firebase.components.ComponentRegistrar;
import com.google.firebase.components.ComponentRegistrarProcessor;
import com.google.firebase.tracing.FirebaseTrace;
import java.util.ArrayList;
import java.util.List;

public class ComponentMonitor
implements ComponentRegistrarProcessor {
    @Override
    public List<Component<?>> processRegistrar(ComponentRegistrar registrar) {
        ArrayList components = new ArrayList();
        for (Component<Object> comp : registrar.getComponents()) {
            String name = comp.getName();
            if (name != null) {
                Component<?> old = comp;
                comp = old.withFactory(c -> {
                    try {
                        FirebaseTrace.pushTrace(name);
                        Object t = old.getFactory().create(c);
                        return t;
                    }
                    finally {
                        FirebaseTrace.popTrace();
                    }
                });
            }
            components.add(comp);
        }
        return components;
    }
}

