/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.storage;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.storage.FirebaseStorage;
import com.google.firebase.storage.StorageReference;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class ListResult {
    private static final String ITEMS_KEY = "items";
    private static final String NAME_KEY = "name";
    private static final String PAGE_TOKEN_KEY = "nextPageToken";
    private static final String PREFIXES_KEY = "prefixes";
    private final List<StorageReference> prefixes;
    private final List<StorageReference> items;
    @Nullable
    private final String pageToken;

    ListResult(List<StorageReference> prefixes, List<StorageReference> items, @Nullable String pageToken) {
        this.prefixes = prefixes;
        this.items = items;
        this.pageToken = pageToken;
    }

    static ListResult fromJSON(FirebaseStorage storage, JSONObject resultBody) throws JSONException {
        int i;
        ArrayList<StorageReference> prefixes = new ArrayList<StorageReference>();
        ArrayList<StorageReference> items = new ArrayList<StorageReference>();
        if (resultBody.has(PREFIXES_KEY)) {
            JSONArray prefixEntries = resultBody.getJSONArray(PREFIXES_KEY);
            for (i = 0; i < prefixEntries.length(); ++i) {
                String pathWithoutTrailingSlash = prefixEntries.getString(i);
                if (pathWithoutTrailingSlash.endsWith("/")) {
                    pathWithoutTrailingSlash = pathWithoutTrailingSlash.substring(0, pathWithoutTrailingSlash.length() - 1);
                }
                prefixes.add(storage.getReference(pathWithoutTrailingSlash));
            }
        }
        if (resultBody.has(ITEMS_KEY)) {
            JSONArray itemEntries = resultBody.getJSONArray(ITEMS_KEY);
            for (i = 0; i < itemEntries.length(); ++i) {
                JSONObject metadata = itemEntries.getJSONObject(i);
                items.add(storage.getReference(metadata.getString(NAME_KEY)));
            }
        }
        String pageToken = resultBody.optString(PAGE_TOKEN_KEY, null);
        return new ListResult(prefixes, items, pageToken);
    }

    @NonNull
    public List<StorageReference> getPrefixes() {
        return this.prefixes;
    }

    @NonNull
    public List<StorageReference> getItems() {
        return this.items;
    }

    @Nullable
    public String getPageToken() {
        return this.pageToken;
    }
}

