/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.examples.java;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import de.tr7zw.changeme.nbtapi.NBTContainer;
import dev.jorel.commandapi.AbstractArgumentTree;
import dev.jorel.commandapi.AbstractCommandAPICommand;
import dev.jorel.commandapi.Brigadier;
import dev.jorel.commandapi.BukkitTooltip;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIBukkitConfig;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.CommandAPIConfig;
import dev.jorel.commandapi.CommandPermission;
import dev.jorel.commandapi.CommandTree;
import dev.jorel.commandapi.Converter;
import dev.jorel.commandapi.IStringTooltip;
import dev.jorel.commandapi.SuggestionInfo;
import dev.jorel.commandapi.Tooltip;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.AdvancementArgument;
import dev.jorel.commandapi.arguments.AdventureChatArgument;
import dev.jorel.commandapi.arguments.AdventureChatComponentArgument;
import dev.jorel.commandapi.arguments.AngleArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ArgumentSuggestions;
import dev.jorel.commandapi.arguments.BiomeArgument;
import dev.jorel.commandapi.arguments.BlockPredicateArgument;
import dev.jorel.commandapi.arguments.BlockStateArgument;
import dev.jorel.commandapi.arguments.BooleanArgument;
import dev.jorel.commandapi.arguments.ChatArgument;
import dev.jorel.commandapi.arguments.ChatColorArgument;
import dev.jorel.commandapi.arguments.ChatComponentArgument;
import dev.jorel.commandapi.arguments.CommandArgument;
import dev.jorel.commandapi.arguments.CustomArgument;
import dev.jorel.commandapi.arguments.DoubleArgument;
import dev.jorel.commandapi.arguments.EnchantmentArgument;
import dev.jorel.commandapi.arguments.EntitySelectorArgument;
import dev.jorel.commandapi.arguments.EntityTypeArgument;
import dev.jorel.commandapi.arguments.FunctionArgument;
import dev.jorel.commandapi.arguments.GreedyStringArgument;
import dev.jorel.commandapi.arguments.IntegerArgument;
import dev.jorel.commandapi.arguments.IntegerRangeArgument;
import dev.jorel.commandapi.arguments.ItemStackArgument;
import dev.jorel.commandapi.arguments.ItemStackPredicateArgument;
import dev.jorel.commandapi.arguments.ListArgumentBuilder;
import dev.jorel.commandapi.arguments.Literal;
import dev.jorel.commandapi.arguments.LiteralArgument;
import dev.jorel.commandapi.arguments.LocationArgument;
import dev.jorel.commandapi.arguments.LocationType;
import dev.jorel.commandapi.arguments.LootTableArgument;
import dev.jorel.commandapi.arguments.MapArgumentBuilder;
import dev.jorel.commandapi.arguments.MathOperationArgument;
import dev.jorel.commandapi.arguments.MultiLiteralArgument;
import dev.jorel.commandapi.arguments.NBTCompoundArgument;
import dev.jorel.commandapi.arguments.ObjectiveArgument;
import dev.jorel.commandapi.arguments.ObjectiveCriteriaArgument;
import dev.jorel.commandapi.arguments.ParticleArgument;
import dev.jorel.commandapi.arguments.PlayerArgument;
import dev.jorel.commandapi.arguments.PotionEffectArgument;
import dev.jorel.commandapi.arguments.RecipeArgument;
import dev.jorel.commandapi.arguments.RotationArgument;
import dev.jorel.commandapi.arguments.SafeSuggestions;
import dev.jorel.commandapi.arguments.ScoreHolderArgument;
import dev.jorel.commandapi.arguments.ScoreboardSlotArgument;
import dev.jorel.commandapi.arguments.SoundArgument;
import dev.jorel.commandapi.arguments.StringArgument;
import dev.jorel.commandapi.arguments.SuggestionsBranch;
import dev.jorel.commandapi.arguments.TeamArgument;
import dev.jorel.commandapi.arguments.TextArgument;
import dev.jorel.commandapi.arguments.TimeArgument;
import dev.jorel.commandapi.arguments.WorldArgument;
import dev.jorel.commandapi.examples.java.Economy;
import dev.jorel.commandapi.exceptions.WrapperCommandSyntaxException;
import dev.jorel.commandapi.executors.CommandArguments;
import dev.jorel.commandapi.executors.ExecutorType;
import dev.jorel.commandapi.wrappers.CommandResult;
import dev.jorel.commandapi.wrappers.FunctionWrapper;
import dev.jorel.commandapi.wrappers.IntegerRange;
import dev.jorel.commandapi.wrappers.MathOperation;
import dev.jorel.commandapi.wrappers.ParticleData;
import dev.jorel.commandapi.wrappers.Rotation;
import dev.jorel.commandapi.wrappers.ScoreboardSlot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.Container;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ProxiedCommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.ComplexRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.loot.LootTable;
import org.bukkit.loot.Lootable;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.EulerAngle;

public class Examples
extends JavaPlugin {
    void advancementArgument() {
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("award").withArguments((AbstractArgument[])new Argument[]{new PlayerArgument("player")})).withArguments((AbstractArgument[])new Argument[]{new AdvancementArgument("advancement")})).executes((sender, args) -> {
            Player target = (Player)args.get(0);
            Advancement advancement = (Advancement)args.get(1);
            AdvancementProgress progress = target.getAdvancementProgress(advancement);
            for (String criteria : advancement.getCriteria()) {
                progress.awardCriteria(criteria);
            }
        }, new ExecutorType[0])).register();
    }

    void aliases() {
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("getpos").withAliases(new String[]{"getposition", "getloc", "getlocation", "whereami"})).executesEntity((entity, args) -> entity.sendMessage(String.format("You are at %d, %d, %d", entity.getLocation().getBlockX(), entity.getLocation().getBlockY(), entity.getLocation().getBlockZ())))).executesCommandBlock((block, args) -> block.sendMessage(String.format("You are at %d, %d, %d", block.getBlock().getLocation().getBlockX(), block.getBlock().getLocation().getBlockY(), block.getBlock().getLocation().getBlockZ())))).register();
    }

    void argument_angle() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("yaw").withArguments((AbstractArgument[])new Argument[]{new AngleArgument("amount")})).executesPlayer((player, args) -> {
            Location newLocation = player.getLocation();
            newLocation.setYaw(((Float)args.get(0)).floatValue());
            player.teleport(newLocation);
        })).register();
    }

    void argument_biome() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("setbiome").withArguments((AbstractArgument[])new Argument[]{new BiomeArgument("biome")})).executesPlayer((player, args) -> {
            Biome biome = (Biome)args.get(0);
            Chunk chunk = player.getLocation().getChunk();
            player.getWorld().setBiome(chunk.getX(), player.getLocation().getBlockY(), chunk.getZ(), biome);
        })).register();
    }

    void argument_blockPredicate() {
        Argument[] arguments = new Argument[]{new IntegerArgument("radius"), new BlockPredicateArgument("fromBlock"), new BlockStateArgument("toBlock")};
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("replace").withArguments((AbstractArgument[])arguments)).executesPlayer((player, args) -> {
            int radius = (Integer)args.get(0);
            Predicate predicate = (Predicate)args.get(1);
            BlockData blockData = (BlockData)args.get(2);
            Location center = player.getLocation();
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= radius; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        Block block;
                        if (!(Math.sqrt(x * x + y * y + z * z) <= (double)radius) || !predicate.test(block = center.getWorld().getBlockAt(x + center.getBlockX(), y + center.getBlockY(), z + center.getBlockZ()))) continue;
                        block.setType(blockData.getMaterial());
                        block.setBlockData(blockData);
                    }
                }
            }
        })).register();
    }

    void argument_blockState() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("set").withArguments((AbstractArgument[])new Argument[]{new BlockStateArgument("block")})).executesPlayer((player, args) -> {
            BlockData blockdata = (BlockData)args.get(0);
            Block targetBlock = player.getTargetBlockExact(256);
            targetBlock.setType(blockdata.getMaterial());
            targetBlock.getState().setBlockData(blockdata);
        })).register();
    }

    void argument_chatAdventure() {
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("showbook").withArguments((AbstractArgument[])new Argument[]{new PlayerArgument("target")})).withArguments((AbstractArgument[])new Argument[]{new TextArgument("title")})).withArguments((AbstractArgument[])new Argument[]{new StringArgument("author")})).withArguments((AbstractArgument[])new Argument[]{new AdventureChatComponentArgument("contents")})).executes((sender, args) -> {
            Player target = (Player)args.get(0);
            String title = (String)args.get(1);
            String author = (String)args.get(2);
            Component content = (Component)args.get(3);
            Book mybook = Book.book((Component)Component.text((String)title), (Component)Component.text((String)author), (Component[])new Component[]{content});
            target.openBook(mybook);
        }, new ExecutorType[0])).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("pbroadcast").withArguments((AbstractArgument[])new Argument[]{new AdventureChatArgument("message")})).executes((sender, args) -> {
            Component message = (Component)args.get(0);
            Bukkit.getServer().broadcast(message, "bukkit.broadcast.user");
            Bukkit.getServer().broadcast(message);
        }, new ExecutorType[0])).register();
    }

    void argument_chats() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("namecolor").withArguments((AbstractArgument[])new Argument[]{new ChatColorArgument("chatcolor")})).executesPlayer((player, args) -> {
            ChatColor color = (ChatColor)args.get(0);
            player.setDisplayName(color + player.getName());
        })).register();
    }

    void argument_chatSpigot() {
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("makebook").withArguments((AbstractArgument[])new Argument[]{new PlayerArgument("player")})).withArguments((AbstractArgument[])new Argument[]{new ChatComponentArgument("contents")})).executes((sender, args) -> {
            Player player = (Player)args.get(0);
            BaseComponent[] arr = (BaseComponent[])args.get(1);
            ItemStack is = new ItemStack(Material.WRITTEN_BOOK);
            BookMeta meta = (BookMeta)is.getItemMeta();
            meta.setTitle("Custom Book");
            meta.setAuthor(player.getName());
            meta.spigot().setPages((BaseComponent[][])new BaseComponent[][]{arr});
            is.setItemMeta((ItemMeta)meta);
            player.getInventory().addItem(new ItemStack[]{is});
        }, new ExecutorType[0])).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("pbroadcast").withArguments((AbstractArgument[])new Argument[]{new ChatArgument("message")})).executes((sender, args) -> {
            BaseComponent[] message = (BaseComponent[])args.get(0);
            Bukkit.getServer().spigot().broadcast(message);
        }, new ExecutorType[0])).register();
    }

    void argument_command() {
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("sudo").withArguments((AbstractArgument[])new Argument[]{new PlayerArgument("target")})).withArguments((AbstractArgument[])new Argument[]{new CommandArgument("command")})).executes((sender, args) -> {
            Player target = (Player)args.get(0);
            CommandResult command = (CommandResult)args.get(1);
            command.execute((CommandSender)target);
        }, new ExecutorType[0])).register();
        SuggestionsBranch.suggest((ArgumentSuggestions[])new ArgumentSuggestions[]{ArgumentSuggestions.strings((String[])new String[]{"tp"}), ArgumentSuggestions.strings(info -> (String[])Bukkit.getOnlinePlayers().stream().map(Player::getName).toArray(String[]::new)), ArgumentSuggestions.strings(info -> (String[])Bukkit.getOnlinePlayers().stream().map(Player::getName).toArray(String[]::new))});
        SuggestionsBranch.suggest((ArgumentSuggestions[])new ArgumentSuggestions[]{ArgumentSuggestions.strings((String[])new String[]{"give"}), ArgumentSuggestions.strings(info -> (String[])Bukkit.getOnlinePlayers().stream().map(Player::getName).toArray(String[]::new))}).branch(new SuggestionsBranch[]{SuggestionsBranch.suggest((ArgumentSuggestions[])new ArgumentSuggestions[]{ArgumentSuggestions.strings((String[])new String[]{"diamond", "minecraft:diamond"}), ArgumentSuggestions.empty()}), SuggestionsBranch.suggest((ArgumentSuggestions[])new ArgumentSuggestions[]{ArgumentSuggestions.strings((String[])new String[]{"dirt", "minecraft:dirt"}), null, ArgumentSuggestions.empty()})});
        new CommandArgument("command").branchSuggestions(new SuggestionsBranch[]{SuggestionsBranch.suggest((ArgumentSuggestions[])new ArgumentSuggestions[]{ArgumentSuggestions.strings((String[])new String[]{"give"}), ArgumentSuggestions.strings(info -> (String[])Bukkit.getOnlinePlayers().stream().map(Player::getName).toArray(String[]::new))}).branch(new SuggestionsBranch[]{SuggestionsBranch.suggest((ArgumentSuggestions[])new ArgumentSuggestions[]{ArgumentSuggestions.strings((String[])new String[]{"diamond", "minecraft:diamond"}), ArgumentSuggestions.empty()}), SuggestionsBranch.suggest((ArgumentSuggestions[])new ArgumentSuggestions[]{ArgumentSuggestions.strings((String[])new String[]{"dirt", "minecraft:dirt"}), null, ArgumentSuggestions.empty()})}), SuggestionsBranch.suggest((ArgumentSuggestions[])new ArgumentSuggestions[]{ArgumentSuggestions.strings((String[])new String[]{"tp"}), ArgumentSuggestions.strings(info -> (String[])Bukkit.getOnlinePlayers().stream().map(Player::getName).toArray(String[]::new)), ArgumentSuggestions.strings(info -> (String[])Bukkit.getOnlinePlayers().stream().map(Player::getName).toArray(String[]::new))})});
    }

    void argument_enchantment() {
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("enchantitem").withArguments((AbstractArgument[])new Argument[]{new EnchantmentArgument("enchantment")})).withArguments((AbstractArgument[])new Argument[]{new IntegerArgument("level", 1, 5)})).executesPlayer((player, args) -> {
            Enchantment enchantment = (Enchantment)args.get(0);
            int level = (Integer)args.get(1);
            player.getInventory().getItemInMainHand().addEnchantment(enchantment, level);
        })).register();
    }

    void argument_entities() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("remove").withArguments((AbstractArgument[])new Argument[]{new EntitySelectorArgument.ManyEntities("entities")})).executes((sender, args) -> {
            Collection entities = (Collection)args.get(0);
            sender.sendMessage("Removed " + entities.size() + " entities");
            for (Entity e : entities) {
                e.remove();
            }
        }, new ExecutorType[0])).register();
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("spawnmob").withArguments((AbstractArgument[])new Argument[]{new EntityTypeArgument("entity")})).withArguments((AbstractArgument[])new Argument[]{new IntegerArgument("amount", 1, 100)})).executesPlayer((player, args) -> {
            for (int i = 0; i < (Integer)args.get(1); ++i) {
                player.getWorld().spawnEntity(player.getLocation(), (EntityType)args.get(0));
            }
        })).register();
    }

    void argument_function() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("runfunction").withArguments((AbstractArgument[])new Argument[]{new FunctionArgument("function")})).executes((sender, args) -> {
            FunctionWrapper[] functions2;
            for (FunctionWrapper function : functions2 = (FunctionWrapper[])args.get(0)) {
                function.run();
            }
        }, new ExecutorType[0])).register();
    }

    void argument_itemStack() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("item").withArguments((AbstractArgument[])new Argument[]{new ItemStackArgument("itemstack")})).executesPlayer((player, args) -> player.getInventory().addItem(new ItemStack[]{(ItemStack)args.get(0)}))).register();
    }

    void argument_itemStackPredicate() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("rem").withArguments((AbstractArgument[])new Argument[]{new ItemStackPredicateArgument("items")})).executesPlayer((player, args) -> {
            Predicate predicate = (Predicate)args.get(0);
            for (ItemStack item : player.getInventory()) {
                if (!predicate.test(item)) continue;
                player.getInventory().remove(item);
            }
        })).register();
    }

    void argument_list() {
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("multigive").withArguments((AbstractArgument[])new Argument[]{new IntegerArgument("amount", 1, 64)})).withArguments((AbstractArgument[])new Argument[]{new ListArgumentBuilder("materials").withList(List.of(Material.values())).withMapper(material -> material.name().toLowerCase()).buildGreedy()})).executesPlayer((player, args) -> {
            int amount = (Integer)args.get(0);
            List theList = (List)args.get(1);
            for (Material item : theList) {
                player.getInventory().addItem(new ItemStack[]{new ItemStack(item, amount)});
            }
        })).register();
    }

    void argument_literal() {
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("mycommand").withArguments((AbstractArgument[])new Argument[]{new LiteralArgument("hello")})).withArguments((AbstractArgument[])new Argument[]{new TextArgument("text")})).executes((sender, args) -> {
            String text = (String)args.get(0);
        }, new ExecutorType[0])).register();
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("mycommand").withArguments((AbstractArgument[])new Argument[]{LiteralArgument.of((String)"hello")})).withArguments((AbstractArgument[])new Argument[]{new TextArgument("text")})).executes((sender, args) -> {
            String text = (String)args.get(0);
        }, new ExecutorType[0])).register();
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("mycommand").withArguments((AbstractArgument[])new Argument[]{LiteralArgument.literal((String)"hello")})).withArguments((AbstractArgument[])new Argument[]{new TextArgument("text")})).executes((sender, args) -> {
            String text = (String)args.get(0);
        }, new ExecutorType[0])).register();
        HashMap<String, GameMode> gamemodes = new HashMap<String, GameMode>();
        gamemodes.put("adventure", GameMode.ADVENTURE);
        gamemodes.put("creative", GameMode.CREATIVE);
        gamemodes.put("spectator", GameMode.SPECTATOR);
        gamemodes.put("survival", GameMode.SURVIVAL);
        for (Map.Entry entry : gamemodes.entrySet()) {
            ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("changegamemode").withArguments((AbstractArgument[])new Argument[]{new LiteralArgument((String)entry.getKey())})).executesPlayer((player, args) -> player.setGameMode((GameMode)entry.getValue()))).register();
        }
    }

    void argument_locations() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("break").withArguments((AbstractArgument[])new Argument[]{new LocationArgument("block", LocationType.BLOCK_POSITION)})).executesPlayer((player, args) -> {
            Location location = (Location)args.get(0);
            location.getBlock().setType(Material.AIR);
        })).register();
    }

    void argument_lootTable() {
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("giveloottable").withArguments((AbstractArgument[])new Argument[]{new LootTableArgument("loottable")})).withArguments((AbstractArgument[])new Argument[]{new LocationArgument("location", LocationType.BLOCK_POSITION)})).executes((sender, args) -> {
            LootTable lootTable = (LootTable)args.get(0);
            Location location = (Location)args.get(1);
            BlockState state = location.getBlock().getState();
            if (state instanceof Container) {
                Container container = (Container)state;
                if (state instanceof Lootable) {
                    Lootable lootable = (Lootable)state;
                    lootable.setLootTable(lootTable);
                    container.update();
                }
            }
        }, new ExecutorType[0])).register();
    }

    void argument_map() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("sendmessage").withArguments((AbstractArgument[])new Argument[]{new MapArgumentBuilder("message").withKeyMapper(Bukkit::getPlayer).withValueMapper(s -> s).withKeyList(Bukkit.getOnlinePlayers().stream().map(Player::getName).toList()).withoutValueList().build()})).executesPlayer((player, args) -> {
            LinkedHashMap map = (LinkedHashMap)args.get("message");
            for (Player messageRecipient : map.keySet()) {
                messageRecipient.sendMessage((String)map.get(messageRecipient));
            }
        })).register();
    }

    void argument_mathOperation() {
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("changelevel").withArguments((AbstractArgument[])new Argument[]{new PlayerArgument("player")})).withArguments((AbstractArgument[])new Argument[]{new MathOperationArgument("operation")})).withArguments((AbstractArgument[])new Argument[]{new IntegerArgument("value")})).executes((sender, args) -> {
            Player target = (Player)args.get(0);
            MathOperation op = (MathOperation)args.get(1);
            int value = (Integer)args.get(2);
            target.setLevel(op.apply(target.getLevel(), value));
        }, new ExecutorType[0])).register();
    }

    void argument_multiLiteral() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("gamemode").withArguments((AbstractArgument[])new Argument[]{new MultiLiteralArgument(new String[]{"adventure", "creative", "spectator", "survival"})})).executesPlayer((player, args) -> {
            switch ((String)args.get(0)) {
                case "adventure": {
                    player.setGameMode(GameMode.ADVENTURE);
                    break;
                }
                case "creative": {
                    player.setGameMode(GameMode.CREATIVE);
                    break;
                }
                case "spectator": {
                    player.setGameMode(GameMode.SPECTATOR);
                    break;
                }
                case "survival": {
                    player.setGameMode(GameMode.SURVIVAL);
                    break;
                }
                default: {
                    player.sendMessage("Invalid gamemode: " + args.get(0));
                }
            }
        })).register();
    }

    void argument_objectives() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("sidebar").withArguments((AbstractArgument[])new Argument[]{new ObjectiveArgument("objective")})).executes((sender, args) -> {
            Objective objective = (Objective)args.get(0);
            objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        }, new ExecutorType[0])).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("unregisterall").withArguments((AbstractArgument[])new Argument[]{new ObjectiveCriteriaArgument("objective criteria")})).executes((sender, args) -> {
            String objectiveCriteria = (String)args.get(0);
            Set objectives = Bukkit.getScoreboardManager().getMainScoreboard().getObjectivesByCriteria(objectiveCriteria);
            for (Objective objective : objectives) {
                objective.unregister();
            }
        }, new ExecutorType[0])).register();
    }

    void argument_particle() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("showparticle").withArguments((AbstractArgument[])new Argument[]{new ParticleArgument("particle")})).executesPlayer((player, args) -> {
            ParticleData particleData = (ParticleData)args.get(0);
            player.getWorld().spawnParticle(particleData.particle(), player.getLocation(), 1);
        })).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("showparticle").withArguments((AbstractArgument[])new Argument[]{new ParticleArgument("particle")})).executesPlayer((player, args) -> {
            ParticleData particleData = (ParticleData)args.get(0);
            player.getWorld().spawnParticle(particleData.particle(), player.getLocation(), 1, particleData.data());
        })).register();
    }

    void argument_potion() {
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("potion").withArguments((AbstractArgument[])new Argument[]{new PlayerArgument("target")})).withArguments((AbstractArgument[])new Argument[]{new PotionEffectArgument("potion")})).withArguments((AbstractArgument[])new Argument[]{new TimeArgument("duration")})).withArguments((AbstractArgument[])new Argument[]{new IntegerArgument("strength")})).executes((sender, args) -> {
            Player target = (Player)args.get(0);
            PotionEffectType potion = (PotionEffectType)args.get(1);
            int duration = (Integer)args.get(2);
            int strength = (Integer)args.get(3);
            target.addPotionEffect(new PotionEffect(potion, duration, strength));
        }, new ExecutorType[0])).register();
    }

    void argument_primitives() {
        String[] configKeys = this.getConfig().getKeys(true).toArray(new String[0]);
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("editconfig").withArguments((AbstractArgument[])new Argument[]{(Argument)new TextArgument("config-key").replaceSuggestions(ArgumentSuggestions.strings(info -> configKeys))})).withArguments((AbstractArgument[])new Argument[]{new BooleanArgument("value")})).executes((sender, args) -> this.getConfig().set((String)args.get(0), (Object)((Boolean)args.get(1))), new ExecutorType[0])).register();
    }

    void argument_range() {
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("searchrange").withArguments((AbstractArgument[])new Argument[]{new IntegerRangeArgument("range")})).withArguments((AbstractArgument[])new Argument[]{new ItemStackArgument("item")})).executesPlayer((player, args) -> {
            IntegerRange range = (IntegerRange)args.get(0);
            ItemStack itemStack = (ItemStack)args.get(1);
            ArrayList<Location> locations = new ArrayList<Location>();
            for (Chunk chunk : player.getWorld().getLoadedChunks()) {
                for (BlockState blockState : chunk.getTileEntities()) {
                    Chest chest;
                    int distance = (int)blockState.getLocation().distance(player.getLocation());
                    if (!range.isInRange(distance) || !(blockState instanceof Chest) || !(chest = (Chest)blockState).getInventory().contains(itemStack.getType())) continue;
                    locations.add(chest.getLocation());
                }
            }
            if (locations.isEmpty()) {
                player.sendMessage("No chests were found");
            } else {
                player.sendMessage("Found " + locations.size() + " chests:");
                locations.forEach(location -> player.sendMessage("  Found at: " + location.getX() + ", " + location.getY() + ", " + location.getZ()));
            }
        })).register();
    }

    void argument_recipe() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("giverecipe").withArguments((AbstractArgument[])new Argument[]{new RecipeArgument("recipe")})).executesPlayer((player, args) -> {
            ComplexRecipe recipe = (ComplexRecipe)args.get(0);
            player.getInventory().addItem(new ItemStack[]{recipe.getResult()});
        })).register();
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("unlockrecipe").withArguments((AbstractArgument[])new Argument[]{new PlayerArgument("player")})).withArguments((AbstractArgument[])new Argument[]{new RecipeArgument("recipe")})).executes((sender, args) -> {
            Player target = (Player)args.get(0);
            ComplexRecipe recipe = (ComplexRecipe)args.get(1);
            target.discoverRecipe(recipe.getKey());
        }, new ExecutorType[0])).register();
    }

    void argument_rotation() {
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("rotate").withArguments((AbstractArgument[])new Argument[]{new RotationArgument("rotation")})).withArguments((AbstractArgument[])new Argument[]{new EntitySelectorArgument.OneEntity("target")})).executes((sender, args) -> {
            Rotation rotation = (Rotation)args.get(0);
            Entity target = (Entity)args.get(1);
            if (target instanceof ArmorStand) {
                ArmorStand armorStand = (ArmorStand)target;
                armorStand.setHeadPose(new EulerAngle(Math.toRadians(rotation.getPitch()), Math.toRadians(rotation.getYaw() - 90.0f), 0.0));
            }
        }, new ExecutorType[0])).register();
    }

    void argument_scoreboards() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("reward").withArguments((AbstractArgument[])new Argument[]{new ScoreHolderArgument.Multiple("players")})).executes((sender, args) -> {
            Collection players = (Collection)args.get(0);
            for (String playerName : players) {
                Bukkit.getPlayer((String)playerName).getInventory().addItem(new ItemStack[]{new ItemStack(Material.DIAMOND, 3)});
            }
        }, new ExecutorType[0])).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("clearobjectives").withArguments((AbstractArgument[])new Argument[]{new ScoreboardSlotArgument("slot")})).executes((sender, args) -> {
            Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
            DisplaySlot slot = ((ScoreboardSlot)args.get(0)).getDisplaySlot();
            scoreboard.clearSlot(slot);
        }, new ExecutorType[0])).register();
    }

    void argument_sound() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("sound").withArguments((AbstractArgument[])new Argument[]{new SoundArgument("sound")})).executesPlayer((player, args) -> player.getWorld().playSound(player.getLocation(), (Sound)args.get(0), 100.0f, 1.0f))).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("sound").withArguments((AbstractArgument[])new Argument[]{new SoundArgument.NamespacedKey("sound")})).executesPlayer((player, args) -> player.getWorld().playSound(player.getLocation(), ((NamespacedKey)args.get(0)).asString(), 100.0f, 1.0f))).register();
    }

    void argument_strings() {
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("message").withArguments((AbstractArgument[])new Argument[]{new PlayerArgument("target")})).withArguments((AbstractArgument[])new Argument[]{new GreedyStringArgument("message")})).executes((sender, args) -> ((Player)args.get(0)).sendMessage((String)args.get(1)), new ExecutorType[0])).register();
    }

    void argument_team() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("togglepvp").withArguments((AbstractArgument[])new Argument[]{new TeamArgument("team")})).executes((sender, args) -> {
            Team team = (Team)args.get(0);
            team.setAllowFriendlyFire(team.allowFriendlyFire());
        }, new ExecutorType[0])).register();
    }

    void argument_time() {
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("bigmsg").withArguments((AbstractArgument[])new Argument[]{new TimeArgument("duration")})).withArguments((AbstractArgument[])new Argument[]{new GreedyStringArgument("message")})).executes((sender, args) -> {
            int duration = (Integer)args.get(0);
            String message = (String)args.get(1);
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.sendTitle(message, "", 10, duration, 20);
            }
        }, new ExecutorType[0])).register();
    }

    void argument_world() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("unloadworld").withArguments((AbstractArgument[])new Argument[]{new WorldArgument("world")})).executes((sender, args) -> {
            World world = (World)args.get(0);
            Bukkit.getServer().unloadWorld(world, true);
        }, new ExecutorType[0])).register();
    }

    void arguments() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("mycommand").withArguments((AbstractArgument[])new Argument[]{new StringArgument("arg0")})).withArguments((AbstractArgument[])new Argument[]{new StringArgument("arg1")})).withArguments((AbstractArgument[])new Argument[]{new StringArgument("arg2")});
        new CommandAPICommand("mycommand").withArguments((AbstractArgument[])new Argument[]{new StringArgument("arg0"), new StringArgument("arg1"), new StringArgument("arg2")});
        ArrayList<StringArgument> arguments = new ArrayList<StringArgument>();
        arguments.add(new StringArgument("arg0"));
        arguments.add(new StringArgument("arg1"));
        arguments.add(new StringArgument("arg2"));
        new CommandAPICommand("mycommand").withArguments(arguments);
        ArrayList<Object> commandArguments = new ArrayList<Object>();
        commandArguments.add(new StringArgument("arg0"));
        commandArguments.add(new PotionEffectArgument("arg1"));
        commandArguments.add(new LocationArgument("arg2"));
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("cmd").withArguments(commandArguments)).executes((sender, args) -> {
            String stringArg = (String)args.get(0);
            PotionEffectType potionArg = (PotionEffectType)args.get(1);
            Location locationArg = (Location)args.get(2);
        }, new ExecutorType[0])).register();
    }

    void asyncSuggestions() {
        JavaPlugin plugin = new JavaPlugin(){};
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("setconfig").withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("key").replaceSuggestions(ArgumentSuggestions.stringsAsync(info -> CompletableFuture.supplyAsync(() -> plugin.getConfig().getKeys(false).toArray(new String[0]))))})).withArguments((AbstractArgument[])new Argument[]{new TextArgument("value")})).executes((sender, args) -> {
            String key = (String)args.get(0);
            String value = (String)args.get(1);
            plugin.getConfig().set(key, (Object)value);
        }, new ExecutorType[0])).register();
    }

    void brigadier() {
        LiteralCommandNode randomChance = Brigadier.fromLiteralArgument((Literal)new LiteralArgument("randomchance")).build();
        IntegerArgument numeratorArgument = new IntegerArgument("numerator", 0);
        IntegerArgument denominatorArgument = new IntegerArgument("denominator", 1);
        ArrayList<IntegerArgument> arguments = new ArrayList<IntegerArgument>();
        arguments.add(numeratorArgument);
        arguments.add(denominatorArgument);
        RequiredArgumentBuilder numerator = Brigadier.fromArgument((AbstractArgument)numeratorArgument);
        ArgumentBuilder denominator = Brigadier.fromArgument((AbstractArgument)denominatorArgument).fork(Brigadier.getRootNode().getChild("execute"), Brigadier.fromPredicate((sender, args) -> {
            int num = (Integer)args[0];
            int denom = (Integer)args[1];
            return Math.ceil(Math.random() * (double)denom) <= (double)num;
        }, arguments));
        randomChance.addChild(numerator.then(denominator).build());
        Brigadier.getRootNode().getChild("execute").getChild("if").addChild((CommandNode)randomChance);
    }

    void brigadierSuggestions() {
        HashMap<String, String> emojis = new HashMap<String, String>();
        emojis.put("\u263b", "smile");
        emojis.put("\u2764", "heart");
        emojis.put("\ud83d\udd25", "fire");
        emojis.put("\u2605", "star");
        emojis.put("\u2620", "death");
        emojis.put("\u26a0", "warning");
        emojis.put("\u2600", "sun");
        emojis.put("\u263a", "smile");
        emojis.put("\u2639", "frown");
        emojis.put("\u2709", "mail");
        emojis.put("\u2602", "umbrella");
        emojis.put("\u2718", "cross");
        emojis.put("\u266a", "music note (eighth)");
        emojis.put("\u266c", "music note (beamed sixteenth)");
        emojis.put("\u2669", "music note (quarter)");
        emojis.put("\u266b", "music note (beamed eighth)");
        emojis.put("\u2604", "comet");
        emojis.put("\u2726", "star");
        emojis.put("\ud83d\udde1", "sword");
        emojis.put("\ud83e\ude93", "axe");
        emojis.put("\ud83d\udd31", "trident");
        emojis.put("\ud83c\udfa3", "fishing rod");
        emojis.put("\ud83c\udff9", "bow");
        emojis.put("\u26cf", "pickaxe");
        emojis.put("\ud83c\udf56", "food");
        Argument messageArgument = (Argument)new GreedyStringArgument("message").replaceSuggestions((info, builder) -> {
            builder = builder.createOffset(builder.getStart() + info.currentArg().length());
            for (Map.Entry str : emojis.entrySet()) {
                builder.suggest((String)str.getKey(), (Message)new LiteralMessage((String)str.getValue()));
            }
            return builder.buildFuture();
        });
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("emoji").withArguments((AbstractArgument[])new Argument[]{messageArgument})).executes((sender, args) -> Bukkit.broadcastMessage((String)((String)args.get(0))), new ExecutorType[0])).register();
        ArgumentSuggestions commandSuggestions = (info, builder) -> {
            String arg = info.currentArg();
            int start = arg.contains(" ") ? builder.getStart() + arg.lastIndexOf(32) + 1 : builder.getStart();
            ParseResults parseResults = Brigadier.getCommandDispatcher().parse(info.currentArg(), Brigadier.getBrigadierSourceFromCommandSender((Object)((CommandSender)info.sender())));
            if (!parseResults.getExceptions().isEmpty()) {
                CommandSyntaxException exception = (CommandSyntaxException)parseResults.getExceptions().values().iterator().next();
                throw new CommandSyntaxException(exception.getType(), exception.getRawMessage(), exception.getInput(), exception.getCursor() + start);
            }
            return Brigadier.getCommandDispatcher().getCompletionSuggestions(parseResults).thenApply(suggestionsObject -> {
                Suggestions suggestions = (Suggestions)suggestionsObject;
                return new Suggestions(new StringRange(start, start + suggestions.getRange().getLength()), suggestions.getList());
            });
        };
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("commandargument").withArguments((AbstractArgument[])new Argument[]{(Argument)new GreedyStringArgument("command").replaceSuggestions(commandSuggestions)})).executes((sender, args) -> Bukkit.dispatchCommand((CommandSender)sender, (String)((String)args.get(0))), new ExecutorType[0])).register();
    }

    void chatPreview() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("broadcast").withArguments((AbstractArgument[])new Argument[]{new ChatArgument("message").withPreview(info -> {
            String plainText = BaseComponent.toPlainText((BaseComponent[])((BaseComponent[])info.parsedInput()));
            return TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)plainText));
        })})).executesPlayer((player, args) -> {
            String plainText = BaseComponent.toPlainText((BaseComponent[])((BaseComponent[])args.get(0)));
            Bukkit.spigot().broadcast(TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)plainText)));
        })).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("broadcast").withArguments((AbstractArgument[])new Argument[]{new AdventureChatArgument("message").withPreview(info -> {
            String plainText = PlainTextComponentSerializer.plainText().serialize((Component)info.parsedInput());
            return LegacyComponentSerializer.legacyAmpersand().deserialize(plainText);
        })})).executesPlayer((player, args) -> {
            String plainText = PlainTextComponentSerializer.plainText().serialize((Component)args.get(0));
            Bukkit.broadcast((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(plainText));
        })).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("broadcast").withArguments((AbstractArgument[])new Argument[]{new ChatArgument("message").usePreview(true).withPreview(info -> {
            String plainText = BaseComponent.toPlainText((BaseComponent[])((BaseComponent[])info.parsedInput()));
            return TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)plainText));
        })})).executesPlayer((player, args) -> Bukkit.spigot().broadcast((BaseComponent[])args.get(0)))).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("broadcast").withArguments((AbstractArgument[])new Argument[]{new AdventureChatArgument("message").usePreview(true).withPreview(info -> {
            String plainText = PlainTextComponentSerializer.plainText().serialize((Component)info.parsedInput());
            return LegacyComponentSerializer.legacyAmpersand().deserialize(plainText);
        })})).executesPlayer((player, args) -> Bukkit.broadcast((Component)((Component)args.get(0))))).register();
    }

    void commandFailures() {
        String[] fruit = new String[]{"banana", "apple", "orange"};
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("getfruit").withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("item").replaceSuggestions(ArgumentSuggestions.strings((String[])fruit))})).executes((sender, args) -> {
            String inputFruit = (String)args.get(0);
            if (!Arrays.stream(fruit).anyMatch(inputFruit::equals)) {
                throw CommandAPI.failWithString((String)"That fruit doesn't exist!");
            }
        }, new ExecutorType[0])).register();
    }

    void commandRegistration() {
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("broadcastmsg").withArguments((AbstractArgument[])new Argument[]{new GreedyStringArgument("message")})).withAliases(new String[]{"broadcast", "broadcastmessage"})).withPermission(CommandPermission.OP)).executes((sender, args) -> {
            String message = (String)args.get(0);
            Bukkit.getServer().broadcastMessage(message);
        }, new ExecutorType[0])).register();
        CommandAPI.unregister((String)"gamemode", (boolean)true);
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("gamemode").withArguments((AbstractArgument[])new Argument[]{new MultiLiteralArgument(new String[]{"survival", "creative", "adventure", "spectator"})})).executes((sender, args) -> {}, new ExecutorType[0])).register();
    }

    void functionWrapper() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("runfunc").withArguments((AbstractArgument[])new Argument[]{new FunctionArgument("function")})).executes((sender, args) -> {
            FunctionWrapper[] functions2;
            for (FunctionWrapper function : functions2 = (FunctionWrapper[])args.get(0)) {
                function.run();
            }
        }, new ExecutorType[0])).register();
    }

    void help() {
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("mycmd").withShortDescription("Says hi")).withFullDescription("Broadcasts hi to everyone on the server")).executes((sender, args) -> Bukkit.broadcastMessage((String)"Hi!"), new ExecutorType[0])).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("mycmd").withHelp("Says hi", "Broadcasts hi to everyone on the server")).executes((sender, args) -> Bukkit.broadcastMessage((String)"Hi!"), new ExecutorType[0])).register();
    }

    void listed() {
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("mycommand").withArguments((AbstractArgument[])new Argument[]{new PlayerArgument("player")})).withArguments((AbstractArgument[])new Argument[]{(Argument)new IntegerArgument("value").setListed(false)})).withArguments((AbstractArgument[])new Argument[]{new GreedyStringArgument("message")})).executes((sender, args) -> {
            Player player = (Player)args.get(0);
            String message = (String)args.get(1);
            player.sendMessage(message);
        }, new ExecutorType[0])).register();
    }

    void nativeSender() {
        ((CommandAPICommand)new CommandAPICommand("break").executesNative((sender, args) -> {
            Location location = sender.getLocation();
            if (location != null) {
                location.getBlock().breakNaturally();
            }
        })).register();
    }

    void normalExecutors() {
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("broadcastmsg").withArguments((AbstractArgument[])new Argument[]{new GreedyStringArgument("message")})).withAliases(new String[]{"broadcast", "broadcastmessage"})).withPermission(CommandPermission.OP)).executes((sender, args) -> {
            String message = (String)args.get(0);
            Bukkit.getServer().broadcastMessage(message);
        }, new ExecutorType[0])).register();
        ((CommandAPICommand)new CommandAPICommand("suicide").executesPlayer((player, args) -> player.setHealth(0.0))).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("suicide").executesPlayer((player, args) -> player.setHealth(0.0))).executesEntity((entity, args) -> {
            entity.getWorld().createExplosion(entity.getLocation(), 4.0f);
            entity.remove();
        })).register();
        ((CommandAPICommand)new CommandAPICommand("suicide").executes((sender, args) -> {
            LivingEntity entity;
            if (sender instanceof ProxiedCommandSender) {
                ProxiedCommandSender proxy = (ProxiedCommandSender)sender;
                entity = (LivingEntity)proxy.getCallee();
            } else {
                entity = (LivingEntity)sender;
            }
            entity.setHealth(0.0);
        }, new ExecutorType[]{ExecutorType.PLAYER, ExecutorType.PROXY})).register();
    }

    void optionalArguments() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("sayhi").withOptionalArguments((AbstractArgument[])new Argument[]{new PlayerArgument("target")})).executesPlayer((player, args) -> {
            Player target = (Player)args.get("target");
            if (target != null) {
                target.sendMessage("Hi!");
            } else {
                player.sendMessage("Hi!");
            }
        })).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("sayhi").withOptionalArguments((AbstractArgument[])new Argument[]{new PlayerArgument("target")})).executesPlayer((player, args) -> {
            Player target = (Player)args.getOrDefault("target", (Object)player);
            target.sendMessage("Hi!");
        })).register();
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("rate").withOptionalArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("topic").combineWith((AbstractArgument[])new Argument[]{new IntegerArgument("rating", 0, 10)})})).withOptionalArguments((AbstractArgument[])new Argument[]{new PlayerArgument("target")})).executes((sender, args) -> {
            String topic = (String)args.get("topic");
            if (topic == null) {
                sender.sendMessage(new String[]{"Usage: /rate <topic> <rating> <player>(optional)", "Select a topic to rate, then give a rating between 0 and 10", "You can optionally add a player at the end to give the rating to"});
                return;
            }
            int rating = (Integer)args.get("rating");
            CommandSender target = (CommandSender)args.getOrDefault("target", (Object)sender);
            target.sendMessage("Your " + topic + " was rated: " + rating + "/10");
        }, new ExecutorType[0])).register();
    }

    void permissions() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("god").withPermission(CommandPermission.fromString((String)"command.god"))).executesPlayer((player, args) -> {
            player.setInvulnerable(true);
            player.sendMessage("God mode enabled");
        })).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("god").withPermission("command.god")).executesPlayer((player, args) -> {
            player.setInvulnerable(true);
            player.sendMessage("God mode enabled");
        })).register();
        ((CommandAPICommand)new CommandAPICommand("kill").executesPlayer((player, args) -> player.setHealth(0.0))).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("kill").withArguments((AbstractArgument[])new Argument[]{(Argument)new PlayerArgument("target").withPermission(CommandPermission.OP)})).executesPlayer((player, args) -> ((Player)args.get(0)).setHealth(0.0))).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("economy").withPermission("economy.self")).executesPlayer((player, args) -> {})).register();
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("economy").withPermission("economy.other")).withArguments((AbstractArgument[])new Argument[]{new PlayerArgument("target")})).executesPlayer((player, args) -> {
            Player target = (Player)args.get(0);
            player.sendMessage(target.getName() + "'s balance: " + Economy.getBalance(target));
        })).register();
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("economy").withPermission("economy.admin.give")).withArguments((AbstractArgument[])new Argument[]{new PlayerArgument("target")})).withArguments((AbstractArgument[])new Argument[]{new DoubleArgument("amount")})).executesPlayer((player, args) -> {
            Player target = (Player)args.get(0);
            double amount = (Double)args.get(1);
            Economy.updateBalance(target, amount);
        })).register();
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("economy").withPermission("economy.admin.reset")).withArguments((AbstractArgument[])new Argument[]{new PlayerArgument("target")})).executesPlayer((player, args) -> {
            Player target = (Player)args.get(0);
            Economy.resetBalance(target);
        })).register();
    }

    void predicateTips() {
        HashMap partyMembers = new HashMap();
        ArrayList<Object> arguments = new ArrayList<Object>();
        arguments.add((Argument)new LiteralArgument("create").withRequirement(sender -> !partyMembers.containsKey(((Player)sender).getUniqueId())));
        arguments.add(new StringArgument("partyName"));
        arguments = new ArrayList();
        arguments.add((Argument)new LiteralArgument("tp").withRequirement(sender -> partyMembers.containsKey(((Player)sender).getUniqueId())));
        Predicate<CommandSender> testIfPlayerHasParty = sender -> partyMembers.containsKey(((Player)sender).getUniqueId());
        ArrayList<Object> args = new ArrayList<Object>();
        args.add((Argument)new LiteralArgument("create").withRequirement(testIfPlayerHasParty.negate()));
        args.add(new StringArgument("partyName"));
        args = new ArrayList();
        args.add((Argument)new LiteralArgument("tp").withRequirement(testIfPlayerHasParty));
    }

    void proxySender() {
        ((CommandAPICommand)new CommandAPICommand("killme").executesPlayer((player, args) -> player.setHealth(0.0))).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("killme").executesPlayer((player, args) -> player.setHealth(0.0))).executesProxy((proxy, args) -> {
            CommandSender patt64651$temp = proxy.getCallee();
            if (patt64651$temp instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)patt64651$temp;
                target.setHealth(0.0);
            }
        })).register();
    }

    void requirements() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("repair").withRequirement(sender -> ((Player)sender).getLevel() >= 30)).executesPlayer((player, args) -> {
            ItemStack is = player.getInventory().getItemInMainHand();
            ItemMeta itemMeta = is.getItemMeta();
            if (itemMeta instanceof Damageable) {
                Damageable damageable = (Damageable)itemMeta;
                damageable.setDamage(0);
                is.setItemMeta(itemMeta);
            }
            player.setLevel(player.getLevel() - 30);
        })).register();
        HashMap partyMembers = new HashMap();
        ArrayList<Object> arguments = new ArrayList<Object>();
        arguments.add((Argument)new LiteralArgument("create").withRequirement(sender -> !partyMembers.containsKey(((Player)sender).getUniqueId())));
        arguments.add(new StringArgument("partyName"));
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("party").withArguments(arguments)).executesPlayer((player, args) -> {
            String partyName = (String)args.get(0);
            partyMembers.put(player.getUniqueId(), partyName);
        })).register();
        arguments = new ArrayList();
        arguments.add((Argument)new LiteralArgument("tp").withRequirement(sender -> partyMembers.containsKey(((Player)sender).getUniqueId())));
        arguments.add((Argument)new PlayerArgument("player").replaceSafeSuggestions(SafeSuggestions.suggest(info -> {
            ArrayList<Player> playersToTeleportTo = new ArrayList<Player>();
            String partyName = (String)partyMembers.get(((Player)info.sender()).getUniqueId());
            for (Map.Entry entry : partyMembers.entrySet()) {
                Player target;
                if (((UUID)entry.getKey()).equals(((Player)info.sender()).getUniqueId()) || !((String)entry.getValue()).equals(partyName) || !(target = Bukkit.getPlayer((UUID)((UUID)entry.getKey()))).isOnline()) continue;
                playersToTeleportTo.add(target);
            }
            return playersToTeleportTo.toArray(new Player[0]);
        })));
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("party").withArguments(arguments)).executesPlayer((player, args) -> {
            Player target = (Player)args.get(0);
            player.teleport((Entity)target);
        })).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("party").withArguments(arguments)).executesPlayer((player, args) -> {
            String partyName = (String)args.get(0);
            partyMembers.put(player.getUniqueId(), partyName);
            CommandAPI.updateRequirements((Object)player);
        })).register();
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("someCommand").withRequirement(sender -> ((Player)sender).getLevel() >= 30)).withRequirement(sender -> ((Player)sender).getInventory().contains(Material.DIAMOND_PICKAXE))).withRequirement(sender -> ((Player)sender).isInvulnerable())).executesPlayer((player, args) -> {})).register();
    }

    void resultingCommandExecutors() {
        ((CommandAPICommand)new CommandAPICommand("randnum").executes((sender, args) -> ThreadLocalRandom.current().nextInt(), new ExecutorType[0])).register();
        ((CommandAPICommand)new CommandAPICommand("randomnumber").executes((sender, args) -> ThreadLocalRandom.current().nextInt(1, 100), new ExecutorType[0])).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("givereward").withArguments((AbstractArgument[])new Argument[]{new EntitySelectorArgument.OnePlayer("target")})).executes((sender, args) -> {
            Player player = (Player)args.get(0);
            player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.DIAMOND, 64)});
            Bukkit.broadcastMessage((String)(player.getName() + " won a rare 64 diamonds from a loot box!"));
        }, new ExecutorType[0])).register();
    }

    void safeArgumentSuggestions() {
        ItemStack emeraldSword = new ItemStack(Material.DIAMOND_SWORD);
        ItemMeta meta = emeraldSword.getItemMeta();
        meta.setDisplayName("Emerald Sword");
        meta.setUnbreakable(true);
        emeraldSword.setItemMeta(meta);
        ShapedRecipe emeraldSwordRecipe = new ShapedRecipe(new NamespacedKey((Plugin)this, "emerald_sword"), emeraldSword);
        emeraldSwordRecipe.shape(new String[]{"AEA", "AEA", "ABA"});
        emeraldSwordRecipe.setIngredient('A', Material.AIR);
        emeraldSwordRecipe.setIngredient('E', Material.EMERALD);
        emeraldSwordRecipe.setIngredient('B', Material.BLAZE_ROD);
        this.getServer().addRecipe((Recipe)emeraldSwordRecipe);
        ArrayList<Argument> arguments = new ArrayList<Argument>();
        arguments.add((Argument)new RecipeArgument("recipe").replaceSafeSuggestions(SafeSuggestions.suggest(info -> new Recipe[]{emeraldSwordRecipe})));
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("giverecipe").withArguments(arguments)).executesPlayer((player, args) -> {
            Recipe recipe = (Recipe)args.get(0);
            player.getInventory().addItem(new ItemStack[]{recipe.getResult()});
        })).register();
        EntityType[] forbiddenMobs = new EntityType[]{EntityType.ENDER_DRAGON, EntityType.WITHER};
        ArrayList<EntityType> allowedMobs = new ArrayList<EntityType>(Arrays.asList(EntityType.values()));
        allowedMobs.removeAll(Arrays.asList(forbiddenMobs));
        ArrayList<Argument> safeArguments = new ArrayList<Argument>();
        safeArguments.add((Argument)new EntityTypeArgument("mob").replaceSafeSuggestions(SafeSuggestions.suggest(info -> {
            if (((CommandSender)info.sender()).isOp()) {
                return EntityType.values();
            }
            return allowedMobs.toArray(new EntityType[0]);
        })));
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("spawnmob").withArguments(safeArguments)).executesPlayer((player, args) -> {
            EntityType entityType = (EntityType)args.get(0);
            player.getWorld().spawnEntity(player.getLocation(), entityType);
        })).register();
        ArrayList<Object> safeArgs = new ArrayList<Object>();
        safeArgs.add(new EntitySelectorArgument.OnePlayer("target"));
        safeArgs.add((Argument)new PotionEffectArgument("potioneffect").replaceSafeSuggestions(SafeSuggestions.suggest(info -> {
            Player target = (Player)info.previousArgs().get(0);
            return (PotionEffectType[])target.getActivePotionEffects().stream().map(PotionEffect::getType).toArray(PotionEffectType[]::new);
        })));
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("removeeffect").withArguments(safeArgs)).executesPlayer((player, args) -> {
            Player target = (Player)args.get(0);
            PotionEffectType potionEffect = (PotionEffectType)args.get(1);
            target.removePotionEffect(potionEffect);
        })).register();
    }

    void subcommands() {
        CommandAPICommand groupAdd = (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("add").withArguments((AbstractArgument[])new Argument[]{new StringArgument("permission")})).withArguments((AbstractArgument[])new Argument[]{new StringArgument("groupName")})).executes((sender, args) -> {}, new ExecutorType[0]);
        CommandAPICommand groupRemove = (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("remove").withArguments((AbstractArgument[])new Argument[]{new StringArgument("permission")})).withArguments((AbstractArgument[])new Argument[]{new StringArgument("groupName")})).executes((sender, args) -> {}, new ExecutorType[0]);
        CommandAPICommand group = (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("group").withSubcommand((AbstractCommandAPICommand)groupAdd)).withSubcommand((AbstractCommandAPICommand)groupRemove);
        ((CommandAPICommand)new CommandAPICommand("perm").withSubcommand((AbstractCommandAPICommand)group)).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("perm").withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("group").withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("add").withArguments((AbstractArgument[])new Argument[]{new StringArgument("permission")})).withArguments((AbstractArgument[])new Argument[]{new StringArgument("groupName")})).executes((sender, args) -> {}, new ExecutorType[0])))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("remove").withArguments((AbstractArgument[])new Argument[]{new StringArgument("permission")})).withArguments((AbstractArgument[])new Argument[]{new StringArgument("groupName")})).executes((sender, args) -> {}, new ExecutorType[0])))))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("user").withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("add").withArguments((AbstractArgument[])new Argument[]{new StringArgument("permission")})).withArguments((AbstractArgument[])new Argument[]{new StringArgument("userName")})).executes((sender, args) -> {}, new ExecutorType[0])))).withSubcommand((AbstractCommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("remove").withArguments((AbstractArgument[])new Argument[]{new StringArgument("permission")})).withArguments((AbstractArgument[])new Argument[]{new StringArgument("userName")})).executes((sender, args) -> {}, new ExecutorType[0])))))).register();
    }

    void commandtree() {
        ((CommandTree)((CommandTree)((CommandTree)((CommandTree)((CommandTree)new CommandTree("treeexample").withAliases(new String[]{"treealias"})).executes((sender, args) -> sender.sendMessage("Root with no arguments"), new ExecutorType[0])).then(((Argument)new LiteralArgument("integer").executes((sender, args) -> sender.sendMessage("Integer Branch with no arguments"), new ExecutorType[0])).then((AbstractArgumentTree)new IntegerArgument("integer").executes((sender, args) -> sender.sendMessage("Integer Branch with integer argument: " + args.get(0)), new ExecutorType[0])))).then(((Argument)new LiteralArgument("biome").executes((sender, args) -> sender.sendMessage("Biome Branch with no arguments"), new ExecutorType[0])).then((AbstractArgumentTree)new BiomeArgument("biome").executes((sender, args) -> sender.sendMessage("Biome Branch with biome argument: " + args.get(0)), new ExecutorType[0])))).then(((Argument)new LiteralArgument("string").executes((sender, args) -> sender.sendMessage("String Branch with no arguments"), new ExecutorType[0])).then((AbstractArgumentTree)new StringArgument("string").executes((sender, args) -> sender.sendMessage("String Branch with string argument: " + args.get(0)), new ExecutorType[0])))).register();
    }

    class tooltips {
        final /* synthetic */ Examples this$0;

        /*
         * Exception decompiling
         */
        tooltips(Examples this$0) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static /* synthetic */ void lambda$new$4(Player player, CommandArguments args) throws WrapperCommandSyntaxException {
            player.teleport((Location)args.get(0));
        }

        private static /* synthetic */ Tooltip[] lambda$new$3(SuggestionInfo info) {
            Player player = (Player)info.sender();
            return BukkitTooltip.arrayOf((Tooltip[])new Tooltip[]{BukkitTooltip.ofString((Object)player.getWorld().getSpawnLocation(), (String)"World spawn"), BukkitTooltip.ofString((Object)player.getBedSpawnLocation(), (String)"Your bed"), BukkitTooltip.ofString((Object)player.getTargetBlockExact(256).getLocation(), (String)"Target block")});
        }

        private static /* synthetic */ void lambda$new$2(CustomItem[] customItems, Player player, CommandArguments args) throws WrapperCommandSyntaxException {
            String itemName = (String)args.get(0);
            for (CustomItem item : customItems) {
                if (!item.getName().equals(itemName)) continue;
                player.getInventory().addItem(new ItemStack[]{item.getItem()});
                break;
            }
        }

        private static /* synthetic */ void lambda$new$1(Player player, CommandArguments args) throws WrapperCommandSyntaxException {
            String emote = (String)args.get(0);
            Player target = (Player)args.get(1);
            switch (emote) {
                case "wave": {
                    target.sendMessage(player.getName() + " waves at you!");
                    break;
                }
                case "hug": {
                    target.sendMessage(player.getName() + " hugs you!");
                    break;
                }
                case "glare": {
                    target.sendMessage(player.getName() + " gives you the death glare...");
                    break;
                }
                default: {
                    player.sendMessage("Invalid emote '" + emote + "'!");
                }
            }
        }

        class CustomItem
        implements IStringTooltip {
            private ItemStack itemstack;
            private String name;

            public CustomItem(ItemStack itemstack, String name, String lore) {
                ItemMeta meta = itemstack.getItemMeta();
                meta.setDisplayName(name);
                meta.setLore(Arrays.asList(lore));
                itemstack.setItemMeta(meta);
                this.itemstack = itemstack;
                this.name = name;
            }

            public String getName() {
                return this.name;
            }

            public ItemStack getItem() {
                return this.itemstack;
            }

            public String getSuggestion() {
                return this.itemstack.getItemMeta().getDisplayName();
            }

            public Message getTooltip() {
                return BukkitTooltip.messageFromString((String)((String)this.itemstack.getItemMeta().getLore().get(0)));
            }
        }
    }

    class stringArgumentSuggestions {
        stringArgumentSuggestions() {
            HashMap warps = new HashMap();
            ArrayList<Argument> arguments = new ArrayList<Argument>();
            arguments.add((Argument)new StringArgument("world").replaceSuggestions(ArgumentSuggestions.strings((String[])new String[]{"northland", "eastland", "southland", "westland"})));
            ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("warp").withArguments(arguments)).executesPlayer((player, args) -> {
                String warp = (String)args.get(0);
                player.teleport((Location)warps.get(warp));
            })).register();
            ArrayList<Argument> arguments2 = new ArrayList<Argument>();
            arguments2.add((Argument)new PlayerArgument("friend").replaceSuggestions(ArgumentSuggestions.strings(info -> Friends.getFriends((CommandSender)info.sender()))));
            ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("friendtp").withArguments(arguments2)).executesPlayer((player, args) -> {
                Player target = (Player)args.get(0);
                player.teleport((Entity)target);
            })).register();
            ArrayList<Object> commandArgs = new ArrayList<Object>();
            commandArgs.add(new IntegerArgument("radius"));
            commandArgs.add((Argument)new PlayerArgument("target").replaceSuggestions(ArgumentSuggestions.strings(info -> {
                int radius = (Integer)info.previousArgs().get(0);
                Player player = (Player)info.sender();
                Collection entities = player.getWorld().getNearbyEntities(player.getLocation(), (double)radius, (double)radius, (double)radius);
                return (String[])entities.stream().filter(e -> e.getType() == EntityType.PLAYER).map(CommandSender::getName).toArray(String[]::new);
            })));
            commandArgs.add(new GreedyStringArgument("message"));
            ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("localmsg").withArguments(commandArgs)).executesPlayer((player, args) -> {
                Player target = (Player)args.get(1);
                String message = (String)args.get(2);
                target.sendMessage(message);
            })).register();
        }

        class Friends {
            static Map<UUID, String[]> friendsMap = new HashMap<UUID, String[]>();

            Friends() {
            }

            public static String[] getFriends(CommandSender sender) {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    return friendsMap.get(player.getUniqueId());
                }
                return new String[0];
            }
        }
    }

    class setupShading {
        JavaPlugin plugin = new JavaPlugin(){};

        setupShading() {
            CommandAPI.onLoad((CommandAPIConfig)new CommandAPIBukkitConfig(this.plugin).silentLogs(true));
        }

        class MyPlugin
        extends JavaPlugin {
            MyPlugin() {
            }

            public void onLoad() {
                CommandAPI.onLoad((CommandAPIConfig)new CommandAPIBukkitConfig((JavaPlugin)this).verboseOutput(true));
                ((CommandAPICommand)new CommandAPICommand("ping").executes((sender, args) -> sender.sendMessage("pong!"), new ExecutorType[0])).register();
            }

            public void onEnable() {
                CommandAPI.onEnable();
            }

            public void onDisable() {
                CommandAPI.onDisable();
            }
        }
    }

    class functions {
        functions() {
        }

        class Main
        extends JavaPlugin {
            Main() {
            }

            public void onLoad() {
                ((CommandAPICommand)new CommandAPICommand("killall").executes((sender, args) -> Bukkit.getWorlds().forEach(w -> w.getLivingEntities().forEach(e -> e.setHealth(0.0))), new ExecutorType[0])).register();
            }

            public void onEnable() {
            }
        }
    }

    class conversion {
        conversion() {
            JavaPlugin essentials = (JavaPlugin)Bukkit.getPluginManager().getPlugin("Essentials");
            Converter.convert((JavaPlugin)essentials, (String)"speed", (Argument[])new Argument[]{new IntegerArgument("speed", 0, 10)});
            Converter.convert((JavaPlugin)essentials, (String)"speed", (Argument[])new Argument[]{new PlayerArgument("target")});
            Converter.convert((JavaPlugin)essentials, (String)"speed", (Argument[])new Argument[]{new MultiLiteralArgument(new String[]{"walk", "fly"}), new IntegerArgument("speed", 0, 10)});
            Converter.convert((JavaPlugin)essentials, (String)"speed", (Argument[])new Argument[]{new MultiLiteralArgument(new String[]{"walk", "fly"}), new IntegerArgument("speed", 0, 10), new PlayerArgument("target")});
        }

        class YourPlugin
        extends JavaPlugin {
            YourPlugin() {
            }

            public void onEnable() {
                Converter.convert((JavaPlugin)((JavaPlugin)Bukkit.getPluginManager().getPlugin("TargetPlugin")));
            }
        }
    }

    class commandTrees
    extends JavaPlugin {
        commandTrees() {
            ((CommandTree)((CommandTree)new CommandTree("sayhi").executes((sender, args) -> sender.sendMessage("Hi!"), new ExecutorType[0])).then((AbstractArgumentTree)new PlayerArgument("target").executes((sender, args) -> {
                Player target = (Player)args.get(0);
                target.sendMessage("Hi");
            }, new ExecutorType[0]))).register();
            ((CommandTree)((CommandTree)((CommandTree)((CommandTree)new CommandTree("signedit").then(new LiteralArgument("set").then(new IntegerArgument("line_number", 1, 4).then((AbstractArgumentTree)new GreedyStringArgument("text").executesPlayer((player, args) -> {
                Sign sign = this.getTargetSign(player);
                int lineNumber = (Integer)args.get(0);
                String text = (String)args.get(1);
                sign.setLine(lineNumber - 1, text);
                sign.update(true);
            }))))).then(new LiteralArgument("clear").then((AbstractArgumentTree)new IntegerArgument("line_number", 1, 4).executesPlayer((player, args) -> {
                Sign sign = this.getTargetSign(player);
                int lineNumber = (Integer)args.get(0);
                sign.setLine(lineNumber - 1, "");
                sign.update(true);
            })))).then(new LiteralArgument("copy").then((AbstractArgumentTree)new IntegerArgument("line_number", 1, 4).executesPlayer((player, args) -> {
                Sign sign = this.getTargetSign(player);
                int lineNumber = (Integer)args.get(0);
                player.setMetadata("copied_sign_text", (MetadataValue)new FixedMetadataValue((Plugin)this, (Object)sign.getLine(lineNumber - 1)));
            })))).then(new LiteralArgument("paste").then((AbstractArgumentTree)new IntegerArgument("line_number", 1, 4).executesPlayer((player, args) -> {
                Sign sign = this.getTargetSign(player);
                int lineNumber = (Integer)args.get(0);
                sign.setLine(lineNumber - 1, ((MetadataValue)player.getMetadata("copied_sign_text").get(0)).asString());
                sign.update(true);
            })))).register();
        }

        public Sign getTargetSign(Player player) throws WrapperCommandSyntaxException {
            Block block = player.getTargetBlock(null, 256);
            BlockState blockState = block.getState();
            if (blockState instanceof Sign) {
                Sign sign = (Sign)blockState;
                return sign;
            }
            throw CommandAPI.failWithString((String)"You're not looking at a sign!");
        }
    }

    class argument_nbt
    extends JavaPlugin {
        argument_nbt() {
        }

        public void onLoad() {
            CommandAPI.onLoad((CommandAPIConfig)new CommandAPIBukkitConfig((JavaPlugin)this).initializeNBTAPI(NBTContainer.class, NBTContainer::new));
        }

        void argument_nbt2() {
            ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("award").withArguments((AbstractArgument[])new Argument[]{new NBTCompoundArgument("nbt")})).executes((sender, args) -> {
                NBTContainer nbt = (NBTContainer)args.get(0);
            }, new ExecutorType[0])).register();
        }
    }

    class argument_custom {
        argument_custom() {
            ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("tpworld").withArguments((AbstractArgument[])new Argument[]{this.customWorldArgument("world")})).executesPlayer((player, args) -> player.teleport(((World)args.get(0)).getSpawnLocation()))).register();
        }

        public Argument<World> customWorldArgument(String nodeName) {
            return (Argument)new CustomArgument((Argument)new StringArgument(nodeName), info -> {
                World world = Bukkit.getWorld((String)info.input());
                if (world == null) {
                    throw new CustomArgument.CustomArgumentException(new CustomArgument.MessageBuilder("Unknown world: ").appendArgInput());
                }
                return world;
            }).replaceSuggestions(ArgumentSuggestions.strings(info -> (String[])Bukkit.getWorlds().stream().map(WorldInfo::getName).toArray(String[]::new)));
        }
    }
}

