/*
 * Decompiled with CFR 0.152.
 */
package dev.katsute.simplehttpserver.handler.file;

import dev.katsute.simplehttpserver.handler.file.ContextUtility;
import dev.katsute.simplehttpserver.handler.file.FileAdapter;
import dev.katsute.simplehttpserver.handler.file.FileEntry;
import dev.katsute.simplehttpserver.handler.file.FileOptions;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

final class DirectoryEntry {
    private final File file;
    private final Path path;
    private final String abs;
    private final String absl;
    private final FileAdapter adapter;
    private final FileOptions options;
    private final Map<String, FileEntry> files;

    DirectoryEntry(File directory, FileAdapter adapter, FileOptions options) {
        block3: {
            block4: {
                this.files = new ConcurrentHashMap<String, FileEntry>();
                this.file = directory;
                this.path = directory.toPath();
                this.abs = directory.getAbsolutePath();
                this.absl = this.abs.toLowerCase();
                this.adapter = adapter;
                this.options = options;
                if (this.options.loading == FileOptions.FileLoadingOption.LIVE) break block3;
                if (options.walk) break block4;
                File[] files = directory.listFiles(File::isFile);
                if (files == null) break block3;
                for (File f : files) {
                    this.addFile(f);
                }
                break block3;
            }
            try {
                Files.walkFileTree(this.path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public final FileVisitResult visitFile(Path p, BasicFileAttributes attrs) {
                        DirectoryEntry.this.addDirectoryFile(p.toFile());
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private void addFile(File file) {
        this.files.put(ContextUtility.getContext(this.adapter.getName(file), true, false), new FileEntry(file, this.adapter, this.options));
    }

    private void addDirectoryFile(File file) {
        this.files.put(ContextUtility.joinContexts(true, false, this.path.relativize(file.toPath().getParent()).toString(), this.adapter.getName(file)), new FileEntry(file, this.adapter, this.options));
    }

    final Map<String, FileEntry> getFiles() {
        return new HashMap<String, FileEntry>(this.files);
    }

    final File getFile(String path) {
        String relative = ContextUtility.getContext(path, true, false);
        File parentFile = new File(this.abs + relative).getParentFile();
        String pabs = parentFile.getAbsolutePath();
        if (!(pabs.equalsIgnoreCase(this.abs) || this.options.walk && pabs.toLowerCase().startsWith(this.absl))) {
            return null;
        }
        File targetFile = Paths.get(this.abs, relative).toFile();
        String fileName = targetFile.getParentFile() == null ? targetFile.getPath() : targetFile.getName();
        File[] parentFiles = parentFile.listFiles();
        if (parentFiles != null) {
            for (File file : parentFiles) {
                if (!fileName.equalsIgnoreCase(this.adapter.getName(file))) continue;
                return file;
            }
        }
        return null;
    }

    final FileEntry getFileEntry(String path) {
        String context = ContextUtility.getContext(path, true, false);
        FileEntry entry = this.files.get(context);
        if (entry == null) {
            File file = this.getFile(path);
            return file != null && file.exists() ? (this.options.loading != FileOptions.FileLoadingOption.LIVE ? this.files.put(context, new FileEntry(file, this.adapter, this.options)) : new FileEntry(file, this.adapter, this.options)) : null;
        }
        if (!entry.getFile().exists()) {
            this.files.remove(context);
            return null;
        }
        return entry;
    }

    final byte[] getBytes(String path) {
        if (this.options.loading != FileOptions.FileLoadingOption.LIVE) {
            FileEntry entry = this.getFileEntry(path);
            return entry != null ? entry.getBytes() : null;
        }
        try {
            File file = Objects.requireNonNull(this.getFile(path));
            return file.isFile() ? this.adapter.getBytes(file, Files.readAllBytes(file.toPath())) : null;
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    public String toString() {
        return "DirectoryEntry{file=" + this.file + ", path=" + this.path + ", abs='" + this.abs + '\'' + ", absl='" + this.absl + '\'' + ", adapter=" + this.adapter + ", options=" + this.options + ", files=" + this.files + '}';
    }
}

