/*
 * Decompiled with CFR 0.152.
 */
package dev.mayuna.simpleapi;

import dev.mayuna.simpleapi.APIRequest;
import dev.mayuna.simpleapi.APIResponse;
import dev.mayuna.simpleapi.Header;
import dev.mayuna.simpleapi.HttpError;
import dev.mayuna.simpleapi.PathParameter;
import dev.mayuna.simpleapi.SimpleAPI;
import dev.mayuna.simpleapi.deserializers.GsonDeserializer;
import dev.mayuna.simpleapi.exceptions.HttpException;
import dev.mayuna.simpleapi.exceptions.MissingPathParametersException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.NonNull;

public class Action<T> {
    private final SimpleAPI api;
    private final Class<T> responseClass;
    private final APIRequest apiRequest;
    private Consumer<HttpError> httpErrorCallback = httpError -> {
        throw new HttpException((HttpError)httpError);
    };
    private BiConsumer<HttpResponse<?>, T> successCallback = (responseBody, object) -> {};
    private Function<HttpResponse<?>, T> deserializationCallback = null;

    public Action(SimpleAPI api, @NonNull Class<T> responseClass, @NonNull APIRequest apiRequest) {
        if (responseClass == null) {
            throw new NullPointerException("responseClass is marked non-null but is null");
        }
        if (apiRequest == null) {
            throw new NullPointerException("apiRequest is marked non-null but is null");
        }
        this.api = api;
        this.responseClass = responseClass;
        this.apiRequest = apiRequest;
    }

    public Action<T> onHttpError(@NonNull Consumer<HttpError> httpErrorCallback) {
        if (httpErrorCallback == null) {
            throw new NullPointerException("httpErrorCallback is marked non-null but is null");
        }
        this.httpErrorCallback = httpErrorCallback;
        return this;
    }

    public Action<T> onSuccess(BiConsumer<HttpResponse<?>, T> successCallback) {
        this.successCallback = successCallback;
        return this;
    }

    public Action<T> onDeserialization(Function<HttpResponse<?>, T> deserializationCallback) {
        this.deserializationCallback = deserializationCallback;
        return this;
    }

    public CompletableFuture<T> execute() {
        CompletableFuture<Object> completableFuture = new CompletableFuture<Object>();
        String urlStart = this.api.getURL();
        Object urlEndpoint = this.apiRequest.getFinalEndpoint();
        if (urlStart.endsWith("/")) {
            urlStart = urlStart.substring(0, urlStart.length() - 2);
            if (!((String)urlEndpoint).startsWith("/")) {
                urlEndpoint = "/" + (String)urlEndpoint;
            }
        }
        Object stringUrl = urlStart + (String)urlEndpoint;
        if (this.apiRequest.getPathParameters() != null && this.apiRequest.getPathParameters().length != 0) {
            for (PathParameter pathParameter : this.apiRequest.getPathParameters()) {
                stringUrl = ((String)stringUrl).replace(pathParameter.toString(), pathParameter.getReplacement());
            }
        }
        if (((String)stringUrl).contains("{") || ((String)stringUrl).contains("}")) {
            throw new MissingPathParametersException((String)stringUrl, this.apiRequest);
        }
        int responseCode = -1;
        try {
            HttpClient httpClient = HttpClient.newHttpClient();
            HttpRequest.Builder httpRequestBuilder = HttpRequest.newBuilder().uri(new URI((String)stringUrl));
            if (this.api.getDefaultHeads() != null && this.api.getDefaultHeads().length != 0) {
                for (Header header : this.api.getDefaultHeads()) {
                    httpRequestBuilder.header(header.getName(), header.getValue());
                }
            }
            this.apiRequest.getBodyPublisher();
            httpRequestBuilder.method(this.apiRequest.getMethod(), this.apiRequest.getBodyPublisher());
            if (this.apiRequest.getContentType() != null) {
                httpRequestBuilder.header("Content-Type", this.apiRequest.getContentType());
            }
            this.apiRequest.processHttpRequestBuilder(httpRequestBuilder);
            HttpResponse<?> httpResponse = httpClient.send(httpRequestBuilder.build(), this.apiRequest.getBodyHandler());
            responseCode = httpResponse.statusCode();
            Object t = null;
            if (!this.responseClass.isArray()) {
                t = this.responseClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (t instanceof GsonDeserializer) {
                    t = ((GsonDeserializer)t).getGson().fromJson((String)httpResponse.body(), this.responseClass);
                } else if (this.deserializationCallback != null) {
                    t = this.deserializationCallback.apply(httpResponse);
                }
            } else {
                Object object = this.responseClass.getComponentType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (object instanceof GsonDeserializer) {
                    t = ((GsonDeserializer)object).getGson().fromJson((String)httpResponse.body(), this.responseClass);
                } else if (this.deserializationCallback != null) {
                    t = this.deserializationCallback.apply(httpResponse);
                }
            }
            if (t instanceof APIResponse) {
                ((APIResponse)t).responseCode = responseCode;
                ((APIResponse)t).api = this.api;
            }
            this.successCallback.accept(httpResponse, (HttpResponse<?>)t);
            completableFuture.complete(t);
        }
        catch (IOException | IllegalAccessException | InstantiationException | InterruptedException | NoSuchMethodException | InvocationTargetException | URISyntaxException exception) {
            this.httpErrorCallback.accept(new HttpError(responseCode, exception));
            completableFuture.completeExceptionally(exception);
        }
        return completableFuture;
    }

    public SimpleAPI getApi() {
        return this.api;
    }

    public Class<T> getResponseClass() {
        return this.responseClass;
    }

    public APIRequest getApiRequest() {
        return this.apiRequest;
    }
}

