/*
 * Decompiled with CFR 0.152.
 */
package dev.postproxy.sdk.resource;

import com.fasterxml.jackson.core.type.TypeReference;
import dev.postproxy.sdk.PostProxyClient;
import dev.postproxy.sdk.model.ConnectionResponse;
import dev.postproxy.sdk.model.DeleteResponse;
import dev.postproxy.sdk.model.ListResponse;
import dev.postproxy.sdk.model.Platform;
import dev.postproxy.sdk.model.ProfileGroup;
import java.util.LinkedHashMap;
import java.util.Map;

public class ProfileGroupsResource {
    private final PostProxyClient client;

    public ProfileGroupsResource(PostProxyClient client) {
        this.client = client;
    }

    public ListResponse<ProfileGroup> list() {
        return this.client.get("/api/profile_groups", null, new TypeReference<ListResponse<ProfileGroup>>(){});
    }

    public ProfileGroup get(String id) {
        return this.client.get("/api/profile_groups/" + id, null, new TypeReference<ProfileGroup>(){});
    }

    public ProfileGroup create(String name) {
        Map<String, Map<String, String>> body = Map.of("profile_group", Map.of("name", name));
        return this.client.post("/api/profile_groups", null, body, new TypeReference<ProfileGroup>(){});
    }

    public DeleteResponse delete(String id) {
        return this.client.delete("/api/profile_groups/" + id, null, new TypeReference<DeleteResponse>(){});
    }

    public ConnectionResponse initializeConnection(String id, Platform platform, String redirectUrl) {
        LinkedHashMap<String, String> body = new LinkedHashMap<String, String>();
        body.put("platform", platform.getValue());
        body.put("redirect_url", redirectUrl);
        return this.client.post("/api/profile_groups/" + id + "/initialize_connection", null, body, new TypeReference<ConnectionResponse>(){});
    }
}

