/*
 * Decompiled with CFR 0.152.
 */
package dev.shortloop.agent.config;

import dev.shortloop.agent.SDKLogger;
import dev.shortloop.agent.ShortloopHTTPConnection;
import dev.shortloop.agent.config.AgentConfigUtils;
import dev.shortloop.agent.config.ConfigManager;
import dev.shortloop.agent.config.ConfigUpdateListener;
import dev.shortloop.common.models.data.AgentConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public final class SimpleConfigManager
implements ConfigManager {
    private final String ctUrl;
    private final ShortloopHTTPConnection shortloopHTTPConnection;
    private final String userApplicationName;
    private ScheduledExecutorService executorService;
    private SDKLogger logger;
    private final List<ConfigUpdateListener> configUpdateListeners = Collections.synchronizedList(new LinkedList());
    private final Map<String, String> configHeader;
    private final String agentId;

    public SimpleConfigManager(String ctUrl, String userApplicationName, String agentId, ShortloopHTTPConnection shortloopHTTPConnection, SDKLogger logger) {
        this.ctUrl = ctUrl;
        this.userApplicationName = userApplicationName;
        this.agentId = agentId;
        this.shortloopHTTPConnection = shortloopHTTPConnection;
        this.logger = logger;
        this.configHeader = new HashMap<String, String>();
        this.configHeader.put("sdk_major", "1");
        this.configHeader.put("sdk_minor", "3");
    }

    @Override
    public boolean subscribeToUpdates(ConfigUpdateListener configUpdateListener) {
        this.configUpdateListeners.add(configUpdateListener);
        return true;
    }

    @Override
    public synchronized boolean shutdown() {
        this.logger.info("Shutting down SimpleConfigManager");
        if (null == this.executorService) {
            this.logger.info("Shutting down executorService");
            return true;
        }
        if (this.executorService.isShutdown()) {
            return true;
        }
        try {
            this.executorService.shutdown();
            if (!this.executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
                if (!this.executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                    this.logger.error("Still not able to shutdown SimpleConfigManager's executorService");
                }
            }
        }
        catch (InterruptedException e) {
            this.logger.error("Error while shutting down SimpleConfigManager's executorService", e);
        }
        return this.executorService.isShutdown();
    }

    @Override
    public synchronized boolean init() {
        try {
            this.executorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new CustomizableThreadFactory("config-"));
            this.scheduleConfigRefresh(60);
        }
        catch (Exception e) {
            this.logger.error("Error in SimpleConfigManager's init()", e);
            return false;
        }
        return true;
    }

    private void scheduleConfigRefresh(int timeInSecs) {
        Runnable runnable = () -> {
            try {
                ConfigOrError configOrError = this.fetchConfig();
                if (null != configOrError.errorCode) {
                    this.scheduleConfigRefresh(60);
                    this.onUnSuccessfulConfigFetch(configOrError.errorCode);
                } else {
                    this.scheduleConfigRefresh(configOrError.getAgentConfig().getConfigFetchFreqInSec());
                    this.onSuccessfulConfigFetch(configOrError.agentConfig);
                }
            }
            catch (Exception e) {
                this.logger.error("Error in SimpleConfigManager's scheduleConfigRefresh()", e);
            }
        };
        this.executorService.schedule(runnable, (long)timeInSecs, TimeUnit.SECONDS);
    }

    private ConfigOrError fetchConfig() {
        try {
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("appName", this.userApplicationName);
            queryParams.put("agentId", this.agentId);
            AgentConfig agentConfig = this.shortloopHTTPConnection.getSDKConfig();
            if (null == agentConfig) {
                this.logger.error("Received null config :");
                return new ConfigOrError(null, ConfigOrError.ErrorCode.INVALID_CONFIG);
            }
            if (AgentConfigUtils.isConfigValid(agentConfig)) {
                return new ConfigOrError(agentConfig, null);
            }
            this.logger.error("Received invalid config :" + agentConfig);
            return new ConfigOrError(null, ConfigOrError.ErrorCode.INVALID_CONFIG);
        }
        catch (Exception exception) {
            this.logger.error("Error while fetching config", exception);
            return new ConfigOrError(null, ConfigOrError.ErrorCode.PARSE_ERROR);
        }
    }

    private void onSuccessfulConfigFetch(AgentConfig agentConfig) {
        for (ConfigUpdateListener configUpdateListener : this.configUpdateListeners) {
            configUpdateListener.onSuccessfulConfigUpdate(agentConfig);
        }
    }

    private void onUnSuccessfulConfigFetch(ConfigOrError.ErrorCode errorCode) {
        for (ConfigUpdateListener configUpdateListener : this.configUpdateListeners) {
            configUpdateListener.onErroneousConfigUpdate();
        }
    }

    private static class ConfigOrError {
        private final AgentConfig agentConfig;
        private final ErrorCode errorCode;

        public ConfigOrError(AgentConfig agentConfig, ErrorCode errorCode) {
            this.agentConfig = agentConfig;
            this.errorCode = errorCode;
        }

        public AgentConfig getAgentConfig() {
            return this.agentConfig;
        }

        public ErrorCode getErrorCode() {
            return this.errorCode;
        }

        private static enum ErrorCode {
            TIMEOUT,
            PARSE_ERROR,
            INVALID_CONFIG;

        }
    }
}

