/*
 * Decompiled with CFR 0.152.
 */
package dev.shortloop.agent;

import dev.shortloop.agent.SDKLogger;
import dev.shortloop.agent.ShortloopApiProcessor;
import dev.shortloop.agent.buffer.ApiBufferKey;
import dev.shortloop.agent.commons.ObservedApi;
import dev.shortloop.agent.config.ConfigManager;
import dev.shortloop.agent.config.ConfigUpdateListener;
import dev.shortloop.common.models.constant.HttpRequestMethod;
import dev.shortloop.common.models.data.AgentConfig;
import dev.shortloop.common.models.data.BlackListRule;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.annotation.Order;
import org.springframework.util.CollectionUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.ContentCachingResponseWrapper;

@Order
public class ShortloopSpringFilter
extends OncePerRequestFilter
implements ConfigUpdateListener {
    private AgentConfig agentConfig;
    private ConfigManager configManager;
    private ShortloopApiProcessor apiProcessor;
    private String userApplicationName;
    private SDKLogger logger;

    public ShortloopSpringFilter(ConfigManager configManager, ShortloopApiProcessor apiProcessor, String userApplicationName, SDKLogger logger) {
        this.configManager = configManager;
        this.apiProcessor = apiProcessor;
        this.userApplicationName = userApplicationName;
        this.logger = logger;
    }

    public boolean init() {
        this.configManager.subscribeToUpdates(this);
        return true;
    }

    protected void doFilterInternal(HttpServletRequest servletRequest, HttpServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {
        AgentConfig agentConfigLocal = this.agentConfig;
        if (null == agentConfigLocal) {
            filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
            return;
        }
        if (null == agentConfigLocal.getCaptureApiSample() || !agentConfigLocal.getCaptureApiSample().booleanValue()) {
            filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
            return;
        }
        ObservedApi observedApi = this.getObservedApiFromRequest(servletRequest);
        if (this.isBlackListedApi(observedApi, agentConfigLocal)) {
            filterChain.doFilter((ServletRequest)servletRequest, (ServletResponse)servletResponse);
            return;
        }
        RequestResponseContext context = new RequestResponseContext(servletRequest, servletResponse, this.userApplicationName);
        context.setObservedApi(observedApi);
        AgentConfig.ApiConfig apiConfig = this.getApiConfig(observedApi, agentConfigLocal);
        context.setAgentConfig(agentConfigLocal);
        if (null != apiConfig) {
            context.setApiConfig(apiConfig);
            context.setApiBufferKey(ApiBufferKey.getApiBufferKeyFrom(context.getApiConfig()));
            this.apiProcessor.processRegisteredApi(context, filterChain);
        } else {
            context.setApiBufferKey(ApiBufferKey.getApiBufferKeyFrom(context.getObservedApi()));
            this.apiProcessor.processDiscoveredApi(context, filterChain);
        }
    }

    private boolean isBlackListedApi(ObservedApi observedApi, AgentConfig agentConfig) {
        try {
            if (null == agentConfig || null == agentConfig.getBlackListRules()) {
                return false;
            }
            for (BlackListRule blackListRule : agentConfig.getBlackListRules()) {
                if (!blackListRule.matchesUri(observedApi.getUri(), observedApi.getMethod())) continue;
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error("Error ShortloopSpringFilter::isBlackListedApi", e);
        }
        return false;
    }

    private AgentConfig.ApiConfig getApiConfig(ObservedApi observedApi, AgentConfig agentConfig) {
        if (CollectionUtils.isEmpty((Collection)agentConfig.getRegisteredApiConfigs())) {
            return null;
        }
        List registeredApis = agentConfig.getRegisteredApiConfigs();
        for (AgentConfig.ApiConfig apiConfig : registeredApis) {
            if (!observedApi.matches(apiConfig)) continue;
            return apiConfig;
        }
        return null;
    }

    private ObservedApi getObservedApiFromRequest(HttpServletRequest servletRequest) {
        return new ObservedApi(servletRequest.getRequestURI(), HttpRequestMethod.valueOf((String)servletRequest.getMethod()));
    }

    @Override
    public void onSuccessfulConfigUpdate(AgentConfig agentConfig) {
        this.agentConfig = agentConfig;
    }

    @Override
    public void onErroneousConfigUpdate() {
        this.agentConfig = AgentConfig.noOpAgentConfig;
    }

    public static class RequestResponseContext {
        private final HttpServletRequest servletRequest;
        private final HttpServletResponse servletResponse;
        private final String applicationName;
        private ContentCachingRequestWrapper cachedRequest;
        private ContentCachingResponseWrapper cachedResponse;
        private ObservedApi observedApi;
        private AgentConfig.ApiConfig apiConfig;
        private AgentConfig agentConfig;
        private ApiBufferKey apiBufferKey;
        private Boolean payloadCaptureAttempted;
        private Boolean requestPayloadCaptureAttempted;
        private Boolean responsePayloadCaptureAttempted;
        private Long latency;

        public HttpServletRequest getServletRequest() {
            return this.servletRequest;
        }

        public HttpServletResponse getServletResponse() {
            return this.servletResponse;
        }

        public String getApplicationName() {
            return this.applicationName;
        }

        public ContentCachingRequestWrapper getCachedRequest() {
            return this.cachedRequest;
        }

        public ContentCachingResponseWrapper getCachedResponse() {
            return this.cachedResponse;
        }

        public ObservedApi getObservedApi() {
            return this.observedApi;
        }

        public AgentConfig.ApiConfig getApiConfig() {
            return this.apiConfig;
        }

        public AgentConfig getAgentConfig() {
            return this.agentConfig;
        }

        public ApiBufferKey getApiBufferKey() {
            return this.apiBufferKey;
        }

        public Boolean getPayloadCaptureAttempted() {
            return this.payloadCaptureAttempted;
        }

        public Boolean getRequestPayloadCaptureAttempted() {
            return this.requestPayloadCaptureAttempted;
        }

        public Boolean getResponsePayloadCaptureAttempted() {
            return this.responsePayloadCaptureAttempted;
        }

        public Long getLatency() {
            return this.latency;
        }

        public void setCachedRequest(ContentCachingRequestWrapper cachedRequest) {
            this.cachedRequest = cachedRequest;
        }

        public void setCachedResponse(ContentCachingResponseWrapper cachedResponse) {
            this.cachedResponse = cachedResponse;
        }

        public void setObservedApi(ObservedApi observedApi) {
            this.observedApi = observedApi;
        }

        public void setApiConfig(AgentConfig.ApiConfig apiConfig) {
            this.apiConfig = apiConfig;
        }

        public void setAgentConfig(AgentConfig agentConfig) {
            this.agentConfig = agentConfig;
        }

        public void setApiBufferKey(ApiBufferKey apiBufferKey) {
            this.apiBufferKey = apiBufferKey;
        }

        public void setPayloadCaptureAttempted(Boolean payloadCaptureAttempted) {
            this.payloadCaptureAttempted = payloadCaptureAttempted;
        }

        public void setRequestPayloadCaptureAttempted(Boolean requestPayloadCaptureAttempted) {
            this.requestPayloadCaptureAttempted = requestPayloadCaptureAttempted;
        }

        public void setResponsePayloadCaptureAttempted(Boolean responsePayloadCaptureAttempted) {
            this.responsePayloadCaptureAttempted = responsePayloadCaptureAttempted;
        }

        public void setLatency(Long latency) {
            this.latency = latency;
        }

        public RequestResponseContext(HttpServletRequest servletRequest, HttpServletResponse servletResponse, String applicationName) {
            this.servletRequest = servletRequest;
            this.servletResponse = servletResponse;
            this.applicationName = applicationName;
        }
    }
}

