/*
 * Decompiled with CFR 0.152.
 */
package dev.shortloop.agent.buffer;

import dev.shortloop.agent.SDKLogger;
import dev.shortloop.agent.ShortloopHTTPConnection;
import dev.shortloop.agent.buffer.AbstractBufferManager;
import dev.shortloop.agent.buffer.ApiBufferKey;
import dev.shortloop.agent.buffer.Buffer;
import dev.shortloop.agent.buffer.BufferManagerWorker;
import dev.shortloop.agent.buffer.SimpleBuffer;
import dev.shortloop.agent.config.ConfigManager;
import dev.shortloop.common.models.data.APISample;
import dev.shortloop.common.models.data.AgentConfig;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;

public class DiscoveredApiBufferManager
extends AbstractBufferManager {
    private final ShortloopHTTPConnection shortloopHTTPConnection;
    private final String ctUrl;
    private final SDKLogger logger;

    public DiscoveredApiBufferManager(ConfigManager configManager, ShortloopHTTPConnection shortloopHTTPConnection, String ctUrl, SDKLogger logger) {
        super(configManager, logger);
        this.shortloopHTTPConnection = shortloopHTTPConnection;
        this.ctUrl = ctUrl;
        this.logger = logger;
    }

    @Override
    BufferManagerWorker<ApiBufferKey> createWorker(AgentConfig newConfig) {
        return new DiscoveredApiBufferManagerWorker(newConfig, this.shortloopHTTPConnection, this.logger);
    }

    public class DiscoveredApiBufferManagerWorker
    extends BufferManagerWorker<ApiBufferKey> {
        private final ShortloopHTTPConnection shortloopHTTPConnection;
        private final Semaphore semaphore;

        public DiscoveredApiBufferManagerWorker(AgentConfig config, ShortloopHTTPConnection shortloopHTTPConnection, SDKLogger logger) {
            super(config, DiscoveredApiBufferManager.this.ctUrl, logger);
            if (config == null) {
                throw new NullPointerException("config is marked non-null but is null");
            }
            this.semaphore = new Semaphore(config.getDiscoveryBufferSize());
            this.shortloopHTTPConnection = shortloopHTTPConnection;
        }

        @Override
        public boolean init() {
            return true;
        }

        @Override
        public boolean offer(ApiBufferKey apiBufferKey, APISample apiSample) {
            this.bufferMap.computeIfAbsent(apiBufferKey, key -> new SimpleBuffer(this.getOperatingConfig().getDiscoveryBufferSizePerApi()));
            Buffer buffer = (Buffer)this.bufferMap.get(apiBufferKey);
            if (buffer != null) {
                return buffer.offer(apiSample);
            }
            this.logger.error("Buffer found null for " + apiBufferKey.getUri());
            return false;
        }

        @Override
        public boolean canOffer(ApiBufferKey apiBufferKey) {
            if (this.semaphore.tryAcquire()) {
                boolean canOffer = false;
                if (this.getOperatingConfig().getCaptureApiSample().booleanValue()) {
                    Buffer buffer = (Buffer)this.bufferMap.get(apiBufferKey);
                    canOffer = null != buffer ? buffer.canOffer() : this.bufferMap.size() < this.getOperatingConfig().getDiscoveryBufferSize();
                }
                this.semaphore.release();
                return canOffer;
            }
            return false;
        }

        @Override
        void syncForKey(ApiBufferKey key) {
            try {
                Buffer buffer = (Buffer)this.bufferMap.get(key);
                if (null == buffer) {
                    this.logger.error("Buffer is null for " + key.getUri());
                    return;
                }
                int iterations = buffer.getContentCount();
                if (iterations == 0) {
                    this.bufferMap.remove(key);
                    return;
                }
                ArrayList<APISample> contents = new ArrayList<APISample>();
                while (iterations-- > 0) {
                    APISample apiSample = buffer.poll();
                    if (null == apiSample) {
                        this.bufferMap.remove(key);
                        break;
                    }
                    contents.add(apiSample);
                }
                if (contents.size() == 0) {
                    return;
                }
                this.shortloopHTTPConnection.sendSamples(contents);
            }
            catch (Exception exception) {
                this.logger.error("Error inside syncForKey for key " + key.getUri(), exception);
            }
        }
    }
}

