/*
 * Decompiled with CFR 0.152.
 */
package dev.shortloop.agent.buffer;

import dev.shortloop.agent.SDKLogger;
import dev.shortloop.agent.ShortloopHTTPConnection;
import dev.shortloop.agent.buffer.AbstractBufferManager;
import dev.shortloop.agent.buffer.ApiBufferKey;
import dev.shortloop.agent.buffer.Buffer;
import dev.shortloop.agent.buffer.BufferManagerWorker;
import dev.shortloop.agent.buffer.SimpleBuffer;
import dev.shortloop.agent.config.ConfigManager;
import dev.shortloop.common.models.data.APISample;
import dev.shortloop.common.models.data.AgentConfig;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;

public class RegisteredApiBufferManager
extends AbstractBufferManager {
    private final ShortloopHTTPConnection shortloopHTTPConnection;
    private final String ctUrl;
    private final SDKLogger logger;

    public RegisteredApiBufferManager(ConfigManager configManager, ShortloopHTTPConnection shortloopHTTPConnection, String ctUrl, SDKLogger logger) {
        super(configManager, logger);
        this.shortloopHTTPConnection = shortloopHTTPConnection;
        this.ctUrl = ctUrl;
        this.logger = logger;
    }

    @Override
    BufferManagerWorker<ApiBufferKey> createWorker(AgentConfig newConfig) {
        return new RegisteredApiBufferManagerWorker(newConfig, this.shortloopHTTPConnection, this.logger);
    }

    public class RegisteredApiBufferManagerWorker
    extends BufferManagerWorker<ApiBufferKey> {
        private final ShortloopHTTPConnection shortloopHTTPConnection;
        private final Semaphore semaphore;

        public RegisteredApiBufferManagerWorker(AgentConfig config, ShortloopHTTPConnection shortloopHTTPConnection, SDKLogger logger) {
            super(config, RegisteredApiBufferManager.this.ctUrl, logger);
            if (config == null) {
                throw new NullPointerException("config is marked non-null but is null");
            }
            this.shortloopHTTPConnection = shortloopHTTPConnection;
            this.semaphore = new Semaphore(this.getRegisteredApiCountToCapture());
        }

        @Override
        public boolean init() {
            return true;
        }

        @Override
        public boolean offer(ApiBufferKey apiBufferKey, APISample apiSample) {
            this.bufferMap.computeIfAbsent(apiBufferKey, key -> new SimpleBuffer(this.getRegisteredApiBufferSize(apiBufferKey)));
            Buffer buffer = (Buffer)this.bufferMap.get(apiBufferKey);
            if (buffer != null) {
                return buffer.offer(apiSample);
            }
            this.logger.error("Buffer found null for " + apiBufferKey.getUri());
            return false;
        }

        @Override
        public boolean canOffer(ApiBufferKey apiBufferKey) {
            if (!this.getOperatingConfig().getCaptureApiSample().booleanValue()) {
                return false;
            }
            int bufferSize = this.getRegisteredApiBufferSize(apiBufferKey);
            if (bufferSize == 0) {
                return false;
            }
            Buffer buffer = (Buffer)this.bufferMap.get(apiBufferKey);
            if (this.semaphore.tryAcquire()) {
                boolean canOffer = false;
                canOffer = null == buffer ? true : buffer.canOffer();
                this.semaphore.release();
                return canOffer;
            }
            return false;
        }

        public int getRegisteredApiBufferSize(ApiBufferKey apiBufferKey) {
            AgentConfig agentConfig = this.getOperatingConfig();
            if (null == agentConfig.getRegisteredApiConfigs() || agentConfig.getRegisteredApiConfigs().size() == 0) {
                return 0;
            }
            for (AgentConfig.ApiConfig apiConfig : agentConfig.getRegisteredApiConfigs()) {
                if (apiConfig.getMethod() != apiBufferKey.getMethod() || !apiConfig.getUri().equals((Object)apiBufferKey.getUri())) continue;
                return apiConfig.getBufferSize();
            }
            return 0;
        }

        public int getRegisteredApiCountToCapture() {
            AgentConfig agentConfig = this.getOperatingConfig();
            if (null == agentConfig.getRegisteredApiConfigs() || agentConfig.getRegisteredApiConfigs().size() == 0) {
                return 0;
            }
            int totalApis = 0;
            for (AgentConfig.ApiConfig apiConfig : agentConfig.getRegisteredApiConfigs()) {
                if (null == apiConfig.getBufferSize()) continue;
                totalApis += apiConfig.getBufferSize().intValue();
            }
            return totalApis;
        }

        @Override
        void syncForKey(ApiBufferKey key) {
            try {
                APISample apiSample;
                Buffer buffer = (Buffer)this.bufferMap.get(key);
                if (null == buffer) {
                    this.logger.error("Buffer is null for " + key.getUri());
                    return;
                }
                int iterations = buffer.getContentCount();
                while (iterations-- > 0 && null != (apiSample = buffer.poll())) {
                    ArrayList<APISample> dataList = new ArrayList<APISample>();
                    dataList.add(apiSample);
                    this.shortloopHTTPConnection.sendSamples(dataList);
                }
            }
            catch (Exception exception) {
                this.logger.error("Error inside syncForKey for key " + key.getUri(), exception);
            }
        }
    }
}

