/*
 * Decompiled with CFR 0.152.
 */
package dev.shortloop.agent;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SDKLogger {
    boolean loggingEnabled;
    LogLevel logLevel;
    Log logger;

    public SDKLogger(boolean loggingEnabled, LogLevel logLevel) {
        this.loggingEnabled = loggingEnabled;
        this.logLevel = logLevel;
        this.logger = LogFactory.getLog(SDKLogger.class);
    }

    public void info(Object object) {
        if (this.loggingEnabled && this.logLevel == LogLevel.INFO && null != this.logger) {
            this.logger.info(object);
        }
    }

    public void forceLog(Object object) {
        if (null != this.logger) {
            this.logger.info(object);
        }
    }

    public void info(Object object, Throwable throwable) {
        if (this.loggingEnabled && this.logLevel == LogLevel.INFO && null != this.logger) {
            this.logger.info(object, throwable);
        }
    }

    public boolean canLogError() {
        return this.loggingEnabled && (this.logLevel == LogLevel.INFO || this.logLevel == LogLevel.ERROR) && null != this.logger;
    }

    public void error(Object object) {
        if (this.canLogError()) {
            this.logger.error(object);
        }
    }

    public void error(Object object, Throwable throwable) {
        if (this.canLogError()) {
            this.logger.error(object, throwable);
        }
    }

    public static enum LogLevel {
        INFO,
        ERROR;

    }
}

