/*
 * Decompiled with CFR 0.152.
 */
package dev.shortloop.agent.buffer;

import dev.shortloop.agent.buffer.Buffer;
import dev.shortloop.common.models.data.APISample;
import java.util.concurrent.ArrayBlockingQueue;

public class SimpleBuffer
implements Buffer {
    private final ArrayBlockingQueue<APISample> arrayBlockingQueue;
    int size;

    public SimpleBuffer(int size) {
        this.size = size;
        this.arrayBlockingQueue = new ArrayBlockingQueue(size);
    }

    @Override
    public boolean offer(APISample apiSample) {
        return this.arrayBlockingQueue.offer(apiSample);
    }

    @Override
    public boolean canOffer() {
        return this.size > 0 && this.arrayBlockingQueue.remainingCapacity() > 0;
    }

    @Override
    public APISample poll() {
        return this.arrayBlockingQueue.poll();
    }

    @Override
    public boolean clear() {
        this.arrayBlockingQueue.clear();
        return true;
    }

    @Override
    public int getContentCount() {
        return this.arrayBlockingQueue.size();
    }
}

