/*
 * Decompiled with CFR 0.152.
 */
package dev.tinyflow.core.parser;

import com.agentsflex.core.chain.Chain;
import com.agentsflex.core.chain.ChainEdge;
import com.agentsflex.core.chain.ChainNode;
import com.agentsflex.core.util.CollectionUtil;
import com.agentsflex.core.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import dev.tinyflow.core.Tinyflow;
import dev.tinyflow.core.parser.NodeParser;
import dev.tinyflow.core.parser.impl.CodeNodeParser;
import dev.tinyflow.core.parser.impl.EndNodeParser;
import dev.tinyflow.core.parser.impl.LlmNodeParser;
import dev.tinyflow.core.parser.impl.StartNodeParser;
import dev.tinyflow.core.parser.impl.TemplateNodeParser;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ChainParser {
    private static final Map<String, NodeParser> nodeParserMap = new HashMap<String, NodeParser>();

    public static Chain parse(Tinyflow tinyflow) {
        String jsonString = tinyflow.getData();
        if (StringUtil.noText((String)jsonString)) {
            return null;
        }
        JSONObject root = JSON.parseObject((String)jsonString);
        JSONArray nodes = root.getJSONArray("nodes");
        JSONArray edges = root.getJSONArray("edges");
        return ChainParser.parse(tinyflow, nodes, edges, null);
    }

    public static Chain parse(Tinyflow tinyflow, JSONArray nodes, JSONArray edges, JSONObject parentNode) {
        int i;
        if (CollectionUtil.noItems((Collection)nodes) || CollectionUtil.noItems((Collection)edges)) {
            return null;
        }
        Chain chain = new Chain();
        for (i = 0; i < nodes.size(); ++i) {
            ChainNode node;
            JSONObject nodeObject = nodes.getJSONObject(i);
            if ((parentNode != null || !StringUtil.noText((String)nodeObject.getString("parentId"))) && (parentNode == null || !parentNode.getString("id").equals(nodeObject.getString("parentId"))) || (node = ChainParser.parseNode(tinyflow, nodeObject)) == null) continue;
            node.setId(nodeObject.getString("id"));
            chain.addNode(node);
        }
        for (i = 0; i < edges.size(); ++i) {
            ChainEdge edge;
            JSONObject edgeObject = edges.getJSONObject(i);
            JSONObject edgeData = edgeObject.getJSONObject("data");
            if ((parentNode != null || edgeData != null && !StringUtil.noText((String)edgeData.getString("parentNodeId"))) && (parentNode == null || edgeData == null || !edgeData.getString("parentNodeId").equals(parentNode.getString("id")) || parentNode.getString("id").equals(edgeObject.getString("source"))) || (edge = ChainParser.parseEdge(edgeObject)) == null) continue;
            chain.addEdge(edge);
        }
        return chain;
    }

    private static ChainNode parseNode(Tinyflow tinyflow, JSONObject nodeObject) {
        String type = nodeObject.getString("type");
        if (StringUtil.noText((String)type)) {
            return null;
        }
        NodeParser nodeParser = nodeParserMap.get(type);
        return nodeParser == null ? null : nodeParser.parse(nodeObject, tinyflow);
    }

    private static ChainEdge parseEdge(JSONObject edgeObject) {
        if (edgeObject == null) {
            return null;
        }
        ChainEdge edge = new ChainEdge();
        edge.setId(edgeObject.getString("id"));
        edge.setSource(edgeObject.getString("source"));
        edge.setTarget(edgeObject.getString("target"));
        return edge;
    }

    static {
        nodeParserMap.put("startNode", new StartNodeParser());
        nodeParserMap.put("codeNode", new CodeNodeParser());
        nodeParserMap.put("templateNode", new TemplateNodeParser());
        nodeParserMap.put("endNode", new EndNodeParser());
        nodeParserMap.put("llmNode", new LlmNodeParser());
    }
}

