/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim;

import java.awt.geom.Point2D;
import org.apache.batik.anim.InterpolatingAnimation;
import org.apache.batik.anim.timing.TimedElement;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.anim.AnimatableElement;
import org.apache.batik.ext.awt.geom.Cubic;

public class SimpleAnimation
extends InterpolatingAnimation {
    protected AnimatableValue[] values;
    protected AnimatableValue from;
    protected AnimatableValue to;
    protected AnimatableValue by;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SimpleAnimation(TimedElement timedElement, AnimatableElement animatableElement, int calcMode, float[] keyTimes, float[] keySplines, boolean additive, boolean cumulative, AnimatableValue[] values, AnimatableValue from2, AnimatableValue to2, AnimatableValue by2) {
        super(timedElement, animatableElement, calcMode, keyTimes, keySplines, additive, cumulative);
        this.from = from2;
        this.to = to2;
        this.by = by2;
        if (values == null) {
            if (from2 != null) {
                values = new AnimatableValue[2];
                values[0] = from2;
                if (to2 != null) {
                    values[1] = to2;
                } else {
                    if (by2 == null) throw timedElement.createException("values.to.by.missing", new Object[]{null});
                    values[1] = from2.interpolate(null, null, 0.0f, by2, 1);
                }
            } else if (to2 != null) {
                values = new AnimatableValue[]{animatableElement.getUnderlyingValue(), to2};
                this.cumulative = false;
                this.toAnimation = true;
            } else {
                if (by2 == null) throw timedElement.createException("values.to.by.missing", new Object[]{null});
                this.additive = true;
                values = new AnimatableValue[]{by2.getZeroValue(), by2};
            }
        }
        this.values = values;
        if (this.keyTimes != null && calcMode != 2) {
            if (this.keyTimes.length != values.length) {
                throw timedElement.createException("attribute.malformed", new Object[]{null, "keyTimes"});
            }
        } else if (calcMode == 1 || calcMode == 3 || calcMode == 2 && !values[0].canPace()) {
            int count2 = values.length == 1 ? 2 : values.length;
            this.keyTimes = new float[count2];
            for (int i = 0; i < count2; ++i) {
                this.keyTimes[i] = (float)i / (float)(count2 - 1);
            }
        } else if (calcMode == 0) {
            int count3 = values.length;
            this.keyTimes = new float[count3];
            for (int i = 0; i < count3; ++i) {
                this.keyTimes[i] = (float)i / (float)count3;
            }
        } else {
            int count4 = values.length;
            float[] cumulativeDistances = new float[count4];
            cumulativeDistances[0] = 0.0f;
            for (int i = 1; i < count4; ++i) {
                cumulativeDistances[i] = cumulativeDistances[i - 1] + values[i - 1].distanceTo(values[i]);
            }
            float totalLength = cumulativeDistances[count4 - 1];
            this.keyTimes = new float[count4];
            this.keyTimes[0] = 0.0f;
            for (int i = 1; i < count4 - 1; ++i) {
                this.keyTimes[i] = cumulativeDistances[i] / totalLength;
            }
            this.keyTimes[count4 - 1] = 1.0f;
        }
        if (calcMode != 3 || keySplines.length == (this.keyTimes.length - 1) * 4) return;
        throw timedElement.createException("attribute.malformed", new Object[]{null, "keySplines"});
    }

    protected void sampledAtUnitTime(float unitTime, int repeatIteration) {
        AnimatableValue nextValue;
        AnimatableValue value2;
        float interpolation = 0.0f;
        if (unitTime != 1.0f) {
            int keyTimeIndex;
            for (keyTimeIndex = 0; keyTimeIndex < this.keyTimes.length - 1 && unitTime >= this.keyTimes[keyTimeIndex + 1]; ++keyTimeIndex) {
            }
            value2 = this.values[keyTimeIndex];
            if (this.calcMode == 1 || this.calcMode == 2 || this.calcMode == 3) {
                nextValue = this.values[keyTimeIndex + 1];
                interpolation = (unitTime - this.keyTimes[keyTimeIndex]) / (this.keyTimes[keyTimeIndex + 1] - this.keyTimes[keyTimeIndex]);
                if (this.calcMode == 3 && unitTime != 0.0f) {
                    float t;
                    Point2D.Double p;
                    double x;
                    Cubic c = this.keySplineCubics[keyTimeIndex];
                    float tolerance = 0.001f;
                    float min2 = 0.0f;
                    float max2 = 1.0f;
                    while (!(Math.abs((x = (p = c.eval(t = (min2 + max2) / 2.0f)).getX()) - (double)interpolation) < (double)tolerance)) {
                        if (x < (double)interpolation) {
                            min2 = t;
                            continue;
                        }
                        max2 = t;
                    }
                    interpolation = (float)p.getY();
                }
            } else {
                nextValue = null;
            }
        } else {
            value2 = this.values[this.values.length - 1];
            nextValue = null;
        }
        AnimatableValue accumulation = this.cumulative ? this.values[this.values.length - 1] : null;
        this.value = value2.interpolate(this.value, nextValue, interpolation, accumulation, repeatIteration);
        if (this.value.hasChanged()) {
            this.markDirty();
        }
    }
}

