/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine;

public class StringIntMap {
    protected Entry[] table;
    protected int count;

    public StringIntMap(int c) {
        this.table = new Entry[c - (c >> 2) + 1];
    }

    public int get(String key) {
        int hash2 = key.hashCode() & Integer.MAX_VALUE;
        int index2 = hash2 % this.table.length;
        Entry e = this.table[index2];
        while (e != null) {
            if (e.hash == hash2 && e.key.equals(key)) {
                return e.value;
            }
            e = e.next;
        }
        return -1;
    }

    public void put(String key, int value2) {
        Entry e;
        int hash2 = key.hashCode() & Integer.MAX_VALUE;
        int index2 = hash2 % this.table.length;
        Entry e2 = this.table[index2];
        while (e2 != null) {
            if (e2.hash == hash2 && e2.key.equals(key)) {
                e2.value = value2;
                return;
            }
            e2 = e2.next;
        }
        int len = this.table.length;
        if (this.count++ >= len - (len >> 2)) {
            this.rehash();
            index2 = hash2 % this.table.length;
        }
        this.table[index2] = e = new Entry(hash2, key, value2, this.table[index2]);
    }

    protected void rehash() {
        Entry[] oldTable = this.table;
        this.table = new Entry[oldTable.length * 2 + 1];
        for (int i = oldTable.length - 1; i >= 0; --i) {
            Entry old = oldTable[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index2 = e.hash % this.table.length;
                e.next = this.table[index2];
                this.table[index2] = e;
            }
        }
    }

    protected static class Entry {
        public final int hash;
        public String key;
        public int value;
        public Entry next;

        public Entry(int hash2, String key, int value2, Entry next2) {
            this.hash = hash2;
            this.key = key;
            this.value = value2;
            this.next = next2;
        }
    }
}

