/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.fonts;

import org.apache.fop.complexscripts.fonts.GlyphPositioningSubtable;
import org.apache.fop.complexscripts.fonts.GlyphPositioningTable;
import org.apache.fop.complexscripts.fonts.GlyphProcessingState;
import org.apache.fop.complexscripts.fonts.GlyphTable;
import org.apache.fop.complexscripts.util.GlyphSequence;
import org.apache.fop.complexscripts.util.ScriptContextTester;

public class GlyphPositioningState
extends GlyphProcessingState {
    private int fontSize;
    private int[] widths;
    private int[][] adjustments;
    private boolean adjusted;

    public GlyphPositioningState(GlyphSequence gs, String script, String language2, String feature, int fontSize, int[] widths, int[][] adjustments, ScriptContextTester sct) {
        super(gs, script, language2, feature, sct);
        this.fontSize = fontSize;
        this.widths = widths;
        this.adjustments = adjustments;
    }

    public GlyphPositioningState(GlyphPositioningState ps) {
        super(ps);
        this.fontSize = ps.fontSize;
        this.widths = ps.widths;
        this.adjustments = ps.adjustments;
    }

    public int getWidth(int gi) {
        if (this.widths != null && gi < this.widths.length) {
            return this.widths[gi];
        }
        return 0;
    }

    public boolean adjust(GlyphPositioningTable.Value v) {
        return this.adjust(v, 0);
    }

    public boolean adjust(GlyphPositioningTable.Value v, int offset) {
        assert (v != null);
        if (this.index + offset < this.indexLast) {
            return v.adjust(this.adjustments[this.index + offset], this.fontSize);
        }
        throw new IndexOutOfBoundsException();
    }

    public int[] getAdjustment() {
        return this.getAdjustment(0);
    }

    public int[] getAdjustment(int offset) throws IndexOutOfBoundsException {
        if (this.index + offset < this.indexLast) {
            return this.adjustments[this.index + offset];
        }
        throw new IndexOutOfBoundsException();
    }

    public boolean apply(GlyphPositioningSubtable st) {
        assert (st != null);
        this.updateSubtableState(st);
        boolean applied = st.position(this);
        this.resetSubtableState();
        return applied;
    }

    public boolean apply(GlyphTable.RuleLookup[] lookups, int nig) {
        if (lookups != null && lookups.length > 0) {
            for (GlyphTable.RuleLookup l : lookups) {
                GlyphPositioningState ps;
                GlyphTable.LookupTable lt;
                if (l == null || (lt = l.getLookup()) == null || !lt.position(ps = new GlyphPositioningState(this), l.getSequenceIndex())) continue;
                this.setAdjusted(true);
            }
            this.consume(nig);
            return true;
        }
        return false;
    }

    public void applyDefault() {
        super.applyDefault();
    }

    public void setAdjusted(boolean adjusted) {
        this.adjusted = adjusted;
    }

    public boolean getAdjusted() {
        return this.adjusted;
    }
}

