/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.complexscripts.fonts.Positionable;
import org.apache.fop.complexscripts.fonts.Substitutable;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.EmbeddingMode;
import org.apache.fop.fonts.EncodingMode;
import org.apache.fop.fonts.FontDescriptor;
import org.apache.fop.fonts.FontLoader;
import org.apache.fop.fonts.FontReader;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.Typeface;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyFont
extends Typeface
implements FontDescriptor,
Substitutable,
Positionable {
    private static Log log = LogFactory.getLog(LazyFont.class);
    private String metricsFileName;
    private String fontEmbedPath;
    private boolean useKerning;
    private boolean useAdvanced;
    private EncodingMode encodingMode = EncodingMode.AUTO;
    private EmbeddingMode embeddingMode = EmbeddingMode.AUTO;
    private boolean embedded = true;
    private String subFontName;
    private boolean isMetricsLoaded;
    private Typeface realFont;
    private FontDescriptor realFontDescriptor;
    private FontResolver resolver;

    public LazyFont(EmbedFontInfo fontInfo, FontResolver resolver) {
        this.metricsFileName = fontInfo.getMetricsFile();
        this.fontEmbedPath = fontInfo.getEmbedFile();
        this.useKerning = fontInfo.getKerning();
        this.useAdvanced = resolver != null ? resolver.isComplexScriptFeaturesEnabled() : fontInfo.getAdvanced();
        this.encodingMode = fontInfo.getEncodingMode();
        this.embeddingMode = fontInfo.getEmbeddingMode();
        this.subFontName = fontInfo.getSubFontName();
        this.embedded = fontInfo.isEmbedded();
        this.resolver = resolver;
    }

    @Override
    public String toString() {
        StringBuffer sbuf = new StringBuffer(super.toString());
        sbuf.append('{');
        sbuf.append("metrics-url=" + this.metricsFileName);
        sbuf.append(",embed-url=" + this.fontEmbedPath);
        sbuf.append(",kerning=" + this.useKerning);
        sbuf.append(",advanced=" + this.useAdvanced);
        sbuf.append('}');
        return sbuf.toString();
    }

    private void load(boolean fail) {
        if (!this.isMetricsLoaded) {
            block18: {
                try {
                    if (this.metricsFileName != null) {
                        FontReader reader = null;
                        if (this.resolver != null) {
                            Source source = this.resolver.resolve(this.metricsFileName);
                            if (source == null) {
                                String err2 = "Cannot load font: failed to create Source from metrics file " + this.metricsFileName;
                                if (fail) {
                                    throw new RuntimeException(err2);
                                }
                                log.error(err2);
                                return;
                            }
                            InputStream in = null;
                            if (source instanceof StreamSource) {
                                in = ((StreamSource)source).getInputStream();
                            }
                            if (in == null && source.getSystemId() != null) {
                                in = new URL(source.getSystemId()).openStream();
                            }
                            if (in == null) {
                                String err3 = "Cannot load font: After URI resolution, the returned Source object does not contain an InputStream or a valid URL (system identifier) for metrics file: " + this.metricsFileName;
                                if (fail) {
                                    throw new RuntimeException(err3);
                                }
                                log.error(err3);
                                return;
                            }
                            InputSource src = new InputSource(in);
                            src.setSystemId(source.getSystemId());
                            reader = new FontReader(src);
                        } else {
                            reader = new FontReader(new InputSource(new URL(this.metricsFileName).openStream()));
                        }
                        reader.setKerningEnabled(this.useKerning);
                        reader.setAdvancedEnabled(this.useAdvanced);
                        if (this.embedded) {
                            reader.setFontEmbedPath(this.fontEmbedPath);
                        }
                        reader.setResolver(this.resolver);
                        this.realFont = reader.getFont();
                    } else {
                        if (this.fontEmbedPath == null) {
                            throw new RuntimeException("Cannot load font. No font URIs available.");
                        }
                        this.realFont = FontLoader.loadFont(this.fontEmbedPath, this.subFontName, this.embedded, this.embeddingMode, this.encodingMode, this.useKerning, this.useAdvanced, this.resolver);
                    }
                    if (this.realFont instanceof FontDescriptor) {
                        this.realFontDescriptor = (FontDescriptor)((Object)this.realFont);
                    }
                }
                catch (FOPException fopex) {
                    log.error("Failed to read font metrics file " + this.metricsFileName, fopex);
                    if (fail) {
                        throw new RuntimeException(fopex.getMessage());
                    }
                }
                catch (IOException ioex) {
                    log.error("Failed to read font metrics file " + this.metricsFileName, ioex);
                    if (!fail) break block18;
                    throw new RuntimeException(ioex.getMessage());
                }
            }
            this.realFont.setEventListener(this.eventListener);
            this.isMetricsLoaded = true;
        }
    }

    public Typeface getRealFont() {
        this.load(false);
        return this.realFont;
    }

    @Override
    public String getEncodingName() {
        this.load(true);
        return this.realFont.getEncodingName();
    }

    @Override
    public char mapChar(char c) {
        this.load(true);
        return this.realFont.mapChar(c);
    }

    @Override
    public boolean hadMappingOperations() {
        this.load(true);
        return this.realFont.hadMappingOperations();
    }

    @Override
    public boolean hasChar(char c) {
        this.load(true);
        return this.realFont.hasChar(c);
    }

    @Override
    public boolean isMultiByte() {
        this.load(true);
        return this.realFont.isMultiByte();
    }

    @Override
    public String getFontName() {
        this.load(true);
        return this.realFont.getFontName();
    }

    @Override
    public String getEmbedFontName() {
        this.load(true);
        return this.realFont.getEmbedFontName();
    }

    @Override
    public String getFullName() {
        this.load(true);
        return this.realFont.getFullName();
    }

    @Override
    public Set<String> getFamilyNames() {
        this.load(true);
        return this.realFont.getFamilyNames();
    }

    @Override
    public int getMaxAscent(int size2) {
        this.load(true);
        return this.realFont.getMaxAscent(size2);
    }

    @Override
    public int getAscender(int size2) {
        this.load(true);
        return this.realFont.getAscender(size2);
    }

    @Override
    public int getCapHeight(int size2) {
        this.load(true);
        return this.realFont.getCapHeight(size2);
    }

    @Override
    public int getDescender(int size2) {
        this.load(true);
        return this.realFont.getDescender(size2);
    }

    @Override
    public int getXHeight(int size2) {
        this.load(true);
        return this.realFont.getXHeight(size2);
    }

    @Override
    public int getWidth(int i, int size2) {
        this.load(true);
        return this.realFont.getWidth(i, size2);
    }

    @Override
    public int[] getWidths() {
        this.load(true);
        return this.realFont.getWidths();
    }

    @Override
    public boolean hasKerningInfo() {
        this.load(true);
        return this.realFont.hasKerningInfo();
    }

    @Override
    public Map<Integer, Map<Integer, Integer>> getKerningInfo() {
        this.load(true);
        return this.realFont.getKerningInfo();
    }

    @Override
    public int getCapHeight() {
        this.load(true);
        return this.realFontDescriptor.getCapHeight();
    }

    @Override
    public int getDescender() {
        this.load(true);
        return this.realFontDescriptor.getDescender();
    }

    @Override
    public int getAscender() {
        this.load(true);
        return this.realFontDescriptor.getAscender();
    }

    @Override
    public int getFlags() {
        this.load(true);
        return this.realFontDescriptor.getFlags();
    }

    @Override
    public boolean isSymbolicFont() {
        this.load(true);
        return this.realFontDescriptor.isSymbolicFont();
    }

    @Override
    public int[] getFontBBox() {
        this.load(true);
        return this.realFontDescriptor.getFontBBox();
    }

    @Override
    public int getItalicAngle() {
        this.load(true);
        return this.realFontDescriptor.getItalicAngle();
    }

    @Override
    public int getStemV() {
        this.load(true);
        return this.realFontDescriptor.getStemV();
    }

    @Override
    public FontType getFontType() {
        this.load(true);
        return this.realFontDescriptor.getFontType();
    }

    @Override
    public boolean isEmbeddable() {
        this.load(true);
        return this.realFontDescriptor.isEmbeddable();
    }

    @Override
    public boolean performsSubstitution() {
        this.load(true);
        if (this.realFontDescriptor instanceof Substitutable) {
            return ((Substitutable)((Object)this.realFontDescriptor)).performsSubstitution();
        }
        return false;
    }

    @Override
    public CharSequence performSubstitution(CharSequence cs, String script, String language2) {
        this.load(true);
        if (this.realFontDescriptor instanceof Substitutable) {
            return ((Substitutable)((Object)this.realFontDescriptor)).performSubstitution(cs, script, language2);
        }
        return cs;
    }

    @Override
    public CharSequence reorderCombiningMarks(CharSequence cs, int[][] gpa, String script, String language2) {
        this.load(true);
        if (this.realFontDescriptor instanceof Substitutable) {
            return ((Substitutable)((Object)this.realFontDescriptor)).reorderCombiningMarks(cs, gpa, script, language2);
        }
        return cs;
    }

    @Override
    public boolean performsPositioning() {
        this.load(true);
        if (this.realFontDescriptor instanceof Positionable) {
            return ((Positionable)((Object)this.realFontDescriptor)).performsPositioning();
        }
        return false;
    }

    @Override
    public int[][] performPositioning(CharSequence cs, String script, String language2, int fontSize) {
        this.load(true);
        if (this.realFontDescriptor instanceof Positionable) {
            return ((Positionable)((Object)this.realFontDescriptor)).performPositioning(cs, script, language2, fontSize);
        }
        return null;
    }

    @Override
    public int[][] performPositioning(CharSequence cs, String script, String language2) {
        this.load(true);
        if (this.realFontDescriptor instanceof Positionable) {
            return ((Positionable)((Object)this.realFontDescriptor)).performPositioning(cs, script, language2);
        }
        return null;
    }

    @Override
    public boolean isSubsetEmbedded() {
        this.load(true);
        return this.realFont.isMultiByte();
    }
}

