/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.complexscripts.util.CharScript;
import org.apache.fop.fo.FOText;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontSelector;
import org.apache.fop.layoutmgr.InlineKnuthSequence;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.KnuthSequence;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.AlignmentContext;
import org.apache.fop.layoutmgr.inline.HyphContext;
import org.apache.fop.layoutmgr.inline.KnuthInlineBox;
import org.apache.fop.layoutmgr.inline.LeafNodeLayoutManager;
import org.apache.fop.text.linebreak.LineBreakStatus;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;
import org.apache.fop.util.CharUtilities;
import org.apache.fop.util.ListUtil;

public class TextLayoutManager
extends LeafNodeLayoutManager {
    private static final int SOFT_HYPHEN_PENALTY = 1;
    private static final Log LOG = LogFactory.getLog(TextLayoutManager.class);
    private final List areaInfos;
    private static final String BREAK_CHARS = "-/";
    private final FOText foText;
    private final MinOptMax[] letterSpaceAdjustArray;
    private Font spaceFont = null;
    private int nextStart = 0;
    private int spaceCharIPD;
    private MinOptMax wordSpaceIPD;
    private MinOptMax letterSpaceIPD;
    private int hyphIPD;
    private boolean hasChanged = false;
    private int[] returnedIndices = new int[]{0, 0};
    private int changeOffset = 0;
    private int thisStart = 0;
    private int tempStart = 0;
    private List changeList = new LinkedList();
    private AlignmentContext alignmentContext = null;
    private int lineStartBAP = 0;
    private int lineEndBAP = 0;
    private boolean keepTogether;
    private final Position auxiliaryPosition = new LeafPosition(this, -1);

    public TextLayoutManager(FOText node) {
        this.foText = node;
        this.letterSpaceAdjustArray = new MinOptMax[node.length() + 1];
        this.areaInfos = new ArrayList();
    }

    private KnuthPenalty makeZeroWidthPenalty(int penaltyValue) {
        return new KnuthPenalty(0, penaltyValue, false, this.auxiliaryPosition, true);
    }

    private KnuthBox makeAuxiliaryZeroWidthBox() {
        return new KnuthInlineBox(0, null, this.notifyPos(new LeafPosition(this, -1)), true);
    }

    public void initialize() {
        this.foText.resetBuffer();
        this.spaceFont = FontSelector.selectFontForCharacterInText(' ', this.foText, this);
        this.spaceCharIPD = this.spaceFont.getCharWidth(' ');
        this.hyphIPD = this.foText.getCommonHyphenation().getHyphIPD(this.spaceFont);
        SpaceVal letterSpacing = SpaceVal.makeLetterSpacing(this.foText.getLetterSpacing());
        SpaceVal wordSpacing = SpaceVal.makeWordSpacing(this.foText.getWordSpacing(), letterSpacing, this.spaceFont);
        this.letterSpaceIPD = letterSpacing.getSpace();
        this.wordSpaceIPD = MinOptMax.getInstance(this.spaceCharIPD).plus(wordSpacing.getSpace());
        this.keepTogether = this.foText.getKeepTogether().getWithinLine().getEnum() == 7;
    }

    public void addAreas(PositionIterator posIter, LayoutContext context) {
        int wordSpaceCount = 0;
        int letterSpaceCount = 0;
        int firstAreaInfoIndex = -1;
        int lastAreaInfoIndex = 0;
        MinOptMax realWidth = MinOptMax.ZERO;
        AreaInfo lastAreaInfo = null;
        while (posIter.hasNext()) {
            LeafPosition tbpNext = (LeafPosition)posIter.next();
            if (tbpNext == null || tbpNext.getLeafPos() == -1) continue;
            AreaInfo areaInfo = (AreaInfo)this.areaInfos.get(tbpNext.getLeafPos());
            if (lastAreaInfo == null || areaInfo.font != lastAreaInfo.font || areaInfo.level != lastAreaInfo.level) {
                if (lastAreaInfo != null) {
                    this.addAreaInfoAreas(lastAreaInfo, wordSpaceCount, letterSpaceCount, firstAreaInfoIndex, lastAreaInfoIndex, realWidth, context);
                }
                firstAreaInfoIndex = tbpNext.getLeafPos();
                wordSpaceCount = 0;
                letterSpaceCount = 0;
                realWidth = MinOptMax.ZERO;
            }
            wordSpaceCount += areaInfo.wordSpaceCount;
            letterSpaceCount += areaInfo.letterSpaceCount;
            realWidth = realWidth.plus(areaInfo.areaIPD);
            lastAreaInfoIndex = tbpNext.getLeafPos();
            lastAreaInfo = areaInfo;
        }
        if (lastAreaInfo != null) {
            this.addAreaInfoAreas(lastAreaInfo, wordSpaceCount, letterSpaceCount, firstAreaInfoIndex, lastAreaInfoIndex, realWidth, context);
        }
    }

    private void addAreaInfoAreas(AreaInfo areaInfo, int wordSpaceCount, int letterSpaceCount, int firstAreaInfoIndex, int lastAreaInfoIndex, MinOptMax realWidth, LayoutContext context) {
        double ipdAdjust;
        int textLength = areaInfo.getWordLength();
        if (areaInfo.letterSpaceCount == textLength && !areaInfo.isHyphenated && context.isLastArea()) {
            realWidth = realWidth.minus(this.letterSpaceIPD);
            --letterSpaceCount;
        }
        for (int i = areaInfo.startIndex; i < areaInfo.breakIndex; ++i) {
            MinOptMax letterSpaceAdjustment = this.letterSpaceAdjustArray[i + 1];
            if (letterSpaceAdjustment == null || !letterSpaceAdjustment.isElastic()) continue;
            ++letterSpaceCount;
        }
        if (context.isLastArea() && areaInfo.isHyphenated) {
            realWidth = realWidth.plus(this.hyphIPD);
        }
        int difference = (ipdAdjust = context.getIPDAdjust()) > 0.0 ? (int)((double)realWidth.getStretch() * ipdAdjust) : (int)((double)realWidth.getShrink() * ipdAdjust);
        int letterSpaceDim = this.letterSpaceIPD.getOpt();
        letterSpaceDim = ipdAdjust > 0.0 ? (letterSpaceDim += (int)((double)this.letterSpaceIPD.getStretch() * ipdAdjust)) : (letterSpaceDim += (int)((double)this.letterSpaceIPD.getShrink() * ipdAdjust));
        int totalAdjust = (letterSpaceDim - this.letterSpaceIPD.getOpt()) * letterSpaceCount;
        int wordSpaceDim = this.wordSpaceIPD.getOpt();
        if (wordSpaceCount > 0) {
            wordSpaceDim += (difference - totalAdjust) / wordSpaceCount;
        }
        if ((totalAdjust += (wordSpaceDim - this.wordSpaceIPD.getOpt()) * wordSpaceCount) != difference) {
            LOG.trace("TextLM.addAreas: error in word / letter space adjustment = " + (totalAdjust - difference));
            totalAdjust = difference;
        }
        TextArea textArea = new TextAreaBuilder(realWidth, totalAdjust, context, firstAreaInfoIndex, lastAreaInfoIndex, context.isLastArea(), areaInfo.font).build();
        textArea.setTextLetterSpaceAdjust(letterSpaceDim);
        textArea.setTextWordSpaceAdjust(wordSpaceDim - this.spaceCharIPD - 2 * textArea.getTextLetterSpaceAdjust());
        if (context.getIPDAdjust() != 0.0) {
            textArea.setSpaceDifference(this.wordSpaceIPD.getOpt() - this.spaceCharIPD - 2 * textArea.getTextLetterSpaceAdjust());
        }
        this.parentLayoutManager.addChildArea(textArea);
    }

    private void addAreaInfo(AreaInfo ai) {
        this.addAreaInfo(this.areaInfos.size(), ai);
    }

    private void addAreaInfo(int index2, AreaInfo ai) {
        this.areaInfos.add(index2, ai);
    }

    private void removeAreaInfo(int index2) {
        this.areaInfos.remove(index2);
    }

    private AreaInfo getAreaInfo(int index2) {
        return (AreaInfo)this.areaInfos.get(index2);
    }

    private void addToLetterAdjust(int index2, int width) {
        this.letterSpaceAdjustArray[index2] = this.letterSpaceAdjustArray[index2] == null ? MinOptMax.getInstance(width) : this.letterSpaceAdjustArray[index2].plus(width);
    }

    private static boolean isSpace(char ch) {
        return ch == ' ' || CharUtilities.isNonBreakableSpace(ch) || CharUtilities.isFixedWidthSpace(ch);
    }

    public List getNextKnuthElements(LayoutContext context, int alignment) {
        this.lineStartBAP = context.getLineStartBorderAndPaddingWidth();
        this.lineEndBAP = context.getLineEndBorderAndPaddingWidth();
        this.alignmentContext = context.getAlignmentContext();
        LinkedList<InlineKnuthSequence> returnList = new LinkedList<InlineKnuthSequence>();
        KnuthSequence sequence2 = new InlineKnuthSequence();
        AreaInfo areaInfo = null;
        AreaInfo prevAreaInfo = null;
        returnList.add((InlineKnuthSequence)sequence2);
        if (LOG.isDebugEnabled()) {
            LOG.debug("GK: [" + this.nextStart + "," + this.foText.length() + "]");
        }
        LineBreakStatus lineBreakStatus = new LineBreakStatus();
        this.thisStart = this.nextStart;
        boolean inWord = false;
        boolean inWhitespace = false;
        char ch = '\u0000';
        int level = -1;
        int prevLevel = -1;
        while (this.nextStart < this.foText.length()) {
            ch = this.foText.charAt(this.nextStart);
            level = this.foText.bidiLevelAt(this.nextStart);
            boolean breakOpportunity = false;
            int breakAction = this.keepTogether ? 4 : (int)lineBreakStatus.nextChar(ch);
            switch (breakAction) {
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
                case 0: 
                case 1: 
                case 2: {
                    breakOpportunity = true;
                    break;
                }
                default: {
                    LOG.error("Unexpected breakAction: " + breakAction);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("GK: { index = " + this.nextStart + ", char = " + CharUtilities.charToNCRef(ch) + ", level = " + level + ", levelPrev = " + prevLevel + ", inWord = " + inWord + ", inSpace = " + inWhitespace + "}");
            }
            if (inWord) {
                if (breakOpportunity || TextLayoutManager.isSpace(ch) || CharUtilities.isExplicitBreak(ch) || prevLevel != -1 && level != prevLevel) {
                    prevAreaInfo = this.processWord(alignment, sequence2, prevAreaInfo, ch, breakOpportunity, true, prevLevel);
                }
            } else if (inWhitespace) {
                if (ch != ' ' || breakOpportunity) {
                    prevAreaInfo = this.processWhitespace(alignment, sequence2, breakOpportunity, prevLevel);
                }
            } else {
                if (areaInfo != null) {
                    prevAreaInfo = areaInfo;
                    this.processLeftoverAreaInfo(alignment, sequence2, areaInfo, ch == ' ' || breakOpportunity);
                    areaInfo = null;
                }
                if (breakAction == 5) {
                    sequence2 = this.processLinebreak(returnList, sequence2);
                }
            }
            if (ch == ' ' && this.foText.getWhitespaceTreatment() == 108 || ch == '\u00a0') {
                areaInfo = new AreaInfo(this.nextStart, this.nextStart + 1, 1, 0, this.wordSpaceIPD, false, true, breakOpportunity, this.spaceFont, level, null);
                this.thisStart = this.nextStart + 1;
            } else if (CharUtilities.isFixedWidthSpace(ch) || CharUtilities.isZeroWidthSpace(ch)) {
                Font font = FontSelector.selectFontForCharacterInText(ch, this.foText, this);
                MinOptMax ipd = MinOptMax.getInstance(font.getCharWidth(ch));
                areaInfo = new AreaInfo(this.nextStart, this.nextStart + 1, 0, 0, ipd, false, true, breakOpportunity, font, level, null);
                this.thisStart = this.nextStart + 1;
            } else if (CharUtilities.isExplicitBreak(ch)) {
                this.thisStart = this.nextStart + 1;
            }
            inWord = !TextLayoutManager.isSpace(ch) && !CharUtilities.isExplicitBreak(ch);
            inWhitespace = ch == ' ' && this.foText.getWhitespaceTreatment() != 108;
            prevLevel = level;
            ++this.nextStart;
        }
        if (inWord) {
            this.processWord(alignment, sequence2, prevAreaInfo, ch, false, false, prevLevel);
        } else if (inWhitespace) {
            this.processWhitespace(alignment, sequence2, !this.keepTogether, prevLevel);
        } else if (areaInfo != null) {
            this.processLeftoverAreaInfo(alignment, sequence2, areaInfo, ch == '\u200b');
        } else if (CharUtilities.isExplicitBreak(ch)) {
            this.processLinebreak(returnList, sequence2);
        }
        if (((List)ListUtil.getLast(returnList)).isEmpty()) {
            ListUtil.removeLast(returnList);
        }
        this.setFinished(true);
        if (returnList.isEmpty()) {
            return null;
        }
        return returnList;
    }

    private KnuthSequence processLinebreak(List returnList, KnuthSequence sequence2) {
        if (this.lineEndBAP != 0) {
            sequence2.add(new KnuthGlue(this.lineEndBAP, 0, 0, this.auxiliaryPosition, true));
        }
        sequence2.endSequence();
        sequence2 = new InlineKnuthSequence();
        returnList.add(sequence2);
        return sequence2;
    }

    private void processLeftoverAreaInfo(int alignment, KnuthSequence sequence2, AreaInfo areaInfo, boolean breakOpportunityAfter) {
        this.addAreaInfo(areaInfo);
        areaInfo.breakOppAfter = breakOpportunityAfter;
        this.addElementsForASpace(sequence2, alignment, areaInfo, this.areaInfos.size() - 1);
    }

    private AreaInfo processWhitespace(int alignment, KnuthSequence sequence2, boolean breakOpportunity, int level) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("PS: [" + this.thisStart + "," + this.nextStart + "]");
        }
        assert (this.nextStart >= this.thisStart);
        AreaInfo areaInfo = new AreaInfo(this.thisStart, this.nextStart, this.nextStart - this.thisStart, 0, this.wordSpaceIPD.mult(this.nextStart - this.thisStart), false, true, breakOpportunity, this.spaceFont, level, null);
        this.addAreaInfo(areaInfo);
        this.addElementsForASpace(sequence2, alignment, areaInfo, this.areaInfos.size() - 1);
        this.thisStart = this.nextStart;
        return areaInfo;
    }

    private AreaInfo processWordMapping(int lastIndex, Font font, AreaInfo prevAreaInfo, char breakOpportunityChar, boolean endsWithHyphen, int level) {
        int s2 = this.thisStart;
        int e = lastIndex;
        int nLS = 0;
        String script = this.foText.getScript();
        String language2 = this.foText.getLanguage();
        if (LOG.isDebugEnabled()) {
            LOG.debug("PW: [" + this.thisStart + "," + lastIndex + "]: {" + " +M" + ", level = " + level + " }");
        }
        CharSequence ics = this.foText.subSequence(s2, e);
        if (script == null || "auto".equals(script)) {
            script = CharScript.scriptTagFromCode(CharScript.dominantScript(ics));
        }
        if (language2 == null || "none".equals(language2)) {
            language2 = "dflt";
        }
        CharSequence mcs = font.performSubstitution(ics, script, language2);
        int[][] gpa = font.performsPositioning() ? font.performPositioning(mcs, script, language2) : (font.hasKerning() ? this.getKerningAdjustments(mcs, font) : (int[][])null);
        if (!CharUtilities.isSameSequence(mcs = font.reorderCombiningMarks(mcs, gpa, script, language2), ics)) {
            this.foText.addMapping(s2, e, mcs);
        }
        MinOptMax ipd = MinOptMax.ZERO;
        int n = mcs.length();
        for (int i = 0; i < n; ++i) {
            char c = mcs.charAt(i);
            int w = font.getCharWidth((int)c);
            if (w < 0) {
                w = 0;
            }
            if (gpa != null) {
                w += gpa[i][2];
            }
            ipd = ipd.plus(w);
        }
        return new AreaInfo(s2, e, 0, nLS, ipd, endsWithHyphen, false, breakOpportunityChar != '\u0000', font, level, gpa);
    }

    private int[][] getKerningAdjustments(CharSequence mcs, Font font) {
        int nc = mcs.length();
        int[] ka = new int[nc];
        int n = nc;
        int cPrev = -1;
        for (int i = 0; i < n; ++i) {
            char c = mcs.charAt(i);
            if (cPrev >= 0) {
                ka[i] = font.getKernValue(cPrev, (int)c);
            }
            cPrev = c;
        }
        boolean hasKerning = false;
        int n2 = nc;
        for (int i = 0; i < n2; ++i) {
            if (ka[i] == 0) continue;
            hasKerning = true;
            break;
        }
        if (hasKerning) {
            int[][] gpa = new int[nc][4];
            int n3 = nc;
            for (int i = 0; i < n3; ++i) {
                if (i <= 0) continue;
                gpa[i - 1][2] = ka[i];
            }
            return gpa;
        }
        return null;
    }

    private AreaInfo processWordNoMapping(int lastIndex, Font font, AreaInfo prevAreaInfo, char breakOpportunityChar, boolean endsWithHyphen, int level) {
        int kern;
        boolean kerning = font.hasKerning();
        MinOptMax wordIPD = MinOptMax.ZERO;
        if (LOG.isDebugEnabled()) {
            LOG.debug("PW: [" + this.thisStart + "," + lastIndex + "]: {" + " -M" + ", level = " + level + " }");
        }
        for (int i = this.thisStart; i < lastIndex; ++i) {
            char previousChar;
            char currentChar = this.foText.charAt(i);
            int charWidth = font.getCharWidth(currentChar);
            wordIPD = wordIPD.plus(charWidth);
            if (!kerning) continue;
            int kern2 = 0;
            if (i > this.thisStart) {
                previousChar = this.foText.charAt(i - 1);
                kern2 = font.getKernValue(previousChar, currentChar);
            } else if (prevAreaInfo != null && !prevAreaInfo.isSpace && prevAreaInfo.breakIndex > 0) {
                previousChar = this.foText.charAt(prevAreaInfo.breakIndex - 1);
                kern2 = font.getKernValue(previousChar, currentChar);
            }
            if (kern2 == 0) continue;
            this.addToLetterAdjust(i, kern2);
            wordIPD = wordIPD.plus(kern2);
        }
        if (kerning && breakOpportunityChar != '\u0000' && !TextLayoutManager.isSpace(breakOpportunityChar) && lastIndex > 0 && endsWithHyphen && (kern = font.getKernValue(this.foText.charAt(lastIndex - 1), breakOpportunityChar)) != 0) {
            this.addToLetterAdjust(lastIndex, kern);
        }
        int wordLength = lastIndex - this.thisStart;
        int letterSpaces = 0;
        if (wordLength != 0) {
            letterSpaces = wordLength - 1;
            if (breakOpportunityChar != '\u0000' && !TextLayoutManager.isSpace(breakOpportunityChar)) {
                ++letterSpaces;
            }
        }
        assert (letterSpaces >= 0);
        wordIPD = wordIPD.plus(this.letterSpaceIPD.mult(letterSpaces));
        return new AreaInfo(this.thisStart, lastIndex, 0, letterSpaces, wordIPD, endsWithHyphen, false, breakOpportunityChar != '\u0000', font, level, null);
    }

    private AreaInfo processWord(int alignment, KnuthSequence sequence2, AreaInfo prevAreaInfo, char ch, boolean breakOpportunity, boolean checkEndsWithHyphen, int level) {
        int lastIndex;
        for (lastIndex = this.nextStart; lastIndex > 0 && this.foText.charAt(lastIndex - 1) == '\u00ad'; --lastIndex) {
        }
        boolean endsWithHyphen = checkEndsWithHyphen && this.foText.charAt(lastIndex) == '\u00ad';
        Font font = FontSelector.selectFontForCharactersInText(this.foText, this.thisStart, lastIndex, this.foText, this);
        AreaInfo areaInfo = font.performsSubstitution() || font.performsPositioning() ? this.processWordMapping(lastIndex, font, prevAreaInfo, breakOpportunity ? ch : (char)'\u0000', endsWithHyphen, level) : this.processWordNoMapping(lastIndex, font, prevAreaInfo, breakOpportunity ? ch : (char)'\u0000', endsWithHyphen, level);
        prevAreaInfo = areaInfo;
        this.addAreaInfo(areaInfo);
        this.tempStart = this.nextStart;
        this.addElementsForAWordFragment(sequence2, alignment, areaInfo, this.areaInfos.size() - 1);
        this.thisStart = this.nextStart;
        return prevAreaInfo;
    }

    public List addALetterSpaceTo(List oldList) {
        return this.addALetterSpaceTo(oldList, 0);
    }

    public List addALetterSpaceTo(List oldList, int depth) {
        ListIterator<KnuthElement> oldListIterator = oldList.listIterator();
        KnuthElement knuthElement = (KnuthElement)oldListIterator.next();
        Position pos = knuthElement.getPosition();
        LeafPosition leafPos = (LeafPosition)pos.getPosition(depth);
        int index2 = leafPos.getLeafPos();
        if (index2 > -1) {
            AreaInfo areaInfo = this.getAreaInfo(index2);
            areaInfo.letterSpaceCount++;
            areaInfo.addToAreaIPD(this.letterSpaceIPD);
            if (BREAK_CHARS.indexOf(this.foText.charAt(this.tempStart - 1)) >= 0) {
                oldListIterator = oldList.listIterator(oldList.size());
                oldListIterator.add(new KnuthPenalty(0, 50, true, this.auxiliaryPosition, false));
                oldListIterator.add(new KnuthGlue(this.letterSpaceIPD, this.auxiliaryPosition, false));
            } else if (this.letterSpaceIPD.isStiff()) {
                oldListIterator.set(new KnuthInlineBox(areaInfo.areaIPD.getOpt(), this.alignmentContext, pos, false));
            } else {
                oldListIterator.next();
                oldListIterator.next();
                oldListIterator.set(new KnuthGlue(this.letterSpaceIPD.mult(areaInfo.letterSpaceCount), this.auxiliaryPosition, true));
            }
        }
        return oldList;
    }

    public void hyphenate(Position pos, HyphContext hyphContext) {
        AreaInfo areaInfo = this.getAreaInfo(((LeafPosition)pos).getLeafPos() + this.changeOffset);
        int startIndex = areaInfo.startIndex;
        boolean nothingChanged = true;
        Font font = areaInfo.font;
        while (startIndex < areaInfo.breakIndex) {
            int letterSpaceCount;
            boolean hyphenFollows;
            MinOptMax newIPD = MinOptMax.ZERO;
            int stopIndex = startIndex + hyphContext.getNextHyphPoint();
            if (hyphContext.hasMoreHyphPoints() && stopIndex <= areaInfo.breakIndex) {
                hyphenFollows = true;
            } else {
                hyphenFollows = false;
                stopIndex = areaInfo.breakIndex;
            }
            hyphContext.updateOffset(stopIndex - startIndex);
            for (int i = startIndex; i < stopIndex; ++i) {
                char ch = this.foText.charAt(i);
                newIPD = newIPD.plus(font.getCharWidth(ch));
                if (i >= stopIndex) continue;
                MinOptMax letterSpaceAdjust = this.letterSpaceAdjustArray[i + 1];
                if (i == stopIndex - 1 && hyphenFollows) {
                    letterSpaceAdjust = null;
                }
                if (letterSpaceAdjust == null) continue;
                newIPD = newIPD.plus(letterSpaceAdjust);
            }
            boolean isWordEnd = stopIndex == areaInfo.breakIndex && areaInfo.letterSpaceCount < areaInfo.getWordLength();
            int n = letterSpaceCount = isWordEnd ? stopIndex - startIndex - 1 : stopIndex - startIndex;
            assert (letterSpaceCount >= 0);
            newIPD = newIPD.plus(this.letterSpaceIPD.mult(letterSpaceCount));
            if (!nothingChanged || stopIndex != areaInfo.breakIndex || hyphenFollows) {
                this.changeList.add(new PendingChange(new AreaInfo(startIndex, stopIndex, 0, letterSpaceCount, newIPD, hyphenFollows, false, false, font, -1, null), ((LeafPosition)pos).getLeafPos() + this.changeOffset));
                nothingChanged = false;
            }
            startIndex = stopIndex;
        }
        this.hasChanged |= !nothingChanged;
    }

    public boolean applyChanges(List oldList) {
        return this.applyChanges(oldList, 0);
    }

    public boolean applyChanges(List oldList, int depth) {
        Position pos;
        this.setFinished(false);
        if (oldList.isEmpty()) {
            return false;
        }
        LeafPosition startPos = null;
        LeafPosition endPos = null;
        ListIterator oldListIter = oldList.listIterator();
        while (oldListIter.hasNext() && ((startPos = (LeafPosition)(pos = ((KnuthElement)oldListIter.next()).getPosition()).getPosition(depth)) == null || startPos.getLeafPos() == -1)) {
        }
        oldListIter = oldList.listIterator(oldList.size());
        while (oldListIter.hasPrevious() && ((endPos = (LeafPosition)(pos = ((KnuthElement)oldListIter.previous()).getPosition()).getPosition(depth)) == null || endPos.getLeafPos() == -1)) {
        }
        this.returnedIndices[0] = (startPos != null ? startPos.getLeafPos() : -1) + this.changeOffset;
        this.returnedIndices[1] = (endPos != null ? endPos.getLeafPos() : -1) + this.changeOffset;
        int areaInfosAdded = 0;
        int areaInfosRemoved = 0;
        if (!this.changeList.isEmpty()) {
            int oldIndex = -1;
            ListIterator changeListIterator = this.changeList.listIterator();
            while (changeListIterator.hasNext()) {
                int changeIndex;
                PendingChange currChange = (PendingChange)changeListIterator.next();
                if (currChange.index == oldIndex) {
                    changeIndex = currChange.index + ++areaInfosAdded - areaInfosRemoved;
                } else {
                    oldIndex = currChange.index;
                    changeIndex = currChange.index + ++areaInfosAdded - ++areaInfosRemoved;
                    this.removeAreaInfo(changeIndex);
                }
                this.addAreaInfo(changeIndex, currChange.areaInfo);
            }
            this.changeList.clear();
        }
        this.returnedIndices[1] = this.returnedIndices[1] + (areaInfosAdded - areaInfosRemoved);
        this.changeOffset += areaInfosAdded - areaInfosRemoved;
        return this.hasChanged;
    }

    public List getChangedKnuthElements(List oldList, int alignment) {
        if (this.isFinished()) {
            return null;
        }
        LinkedList returnList = new LinkedList();
        while (this.returnedIndices[0] <= this.returnedIndices[1]) {
            AreaInfo areaInfo = this.getAreaInfo(this.returnedIndices[0]);
            if (areaInfo.wordSpaceCount == 0) {
                this.addElementsForAWordFragment(returnList, alignment, areaInfo, this.returnedIndices[0]);
            } else {
                this.addElementsForASpace(returnList, alignment, areaInfo, this.returnedIndices[0]);
            }
            this.returnedIndices[0] = this.returnedIndices[0] + 1;
        }
        this.setFinished(this.returnedIndices[0] == this.areaInfos.size() - 1);
        return returnList;
    }

    public String getWordChars(Position pos) {
        int leafValue = ((LeafPosition)pos).getLeafPos() + this.changeOffset;
        if (leafValue != -1) {
            AreaInfo areaInfo = this.getAreaInfo(leafValue);
            StringBuffer buffer = new StringBuffer(areaInfo.getWordLength());
            for (int i = areaInfo.startIndex; i < areaInfo.breakIndex; ++i) {
                buffer.append(this.foText.charAt(i));
            }
            return buffer.toString();
        }
        return "";
    }

    private void addElementsForASpace(List baseList, int alignment, AreaInfo areaInfo, int leafValue) {
        LeafPosition mainPosition = new LeafPosition(this, leafValue);
        if (!areaInfo.breakOppAfter) {
            if (alignment == 70) {
                baseList.add(this.makeAuxiliaryZeroWidthBox());
                baseList.add(this.makeZeroWidthPenalty(1000));
                baseList.add(new KnuthGlue(areaInfo.areaIPD, (Position)mainPosition, false));
            } else {
                baseList.add(new KnuthInlineBox(areaInfo.areaIPD.getOpt(), null, mainPosition, true));
            }
        } else if (this.foText.charAt(areaInfo.startIndex) != ' ' || this.foText.getWhitespaceTreatment() == 108) {
            baseList.addAll(this.getElementsForBreakingSpace(alignment, areaInfo, this.auxiliaryPosition, 0, mainPosition, areaInfo.areaIPD.getOpt(), true));
        } else {
            baseList.addAll(this.getElementsForBreakingSpace(alignment, areaInfo, mainPosition, areaInfo.areaIPD.getOpt(), this.auxiliaryPosition, 0, false));
        }
    }

    private List getElementsForBreakingSpace(int alignment, AreaInfo areaInfo, Position pos2, int p2WidthOffset, Position pos3, int p3WidthOffset, boolean skipZeroCheck) {
        ArrayList<KnuthElement> elements = new ArrayList<KnuthElement>();
        switch (alignment) {
            case 23: {
                elements.add(new KnuthGlue(this.lineEndBAP, 10008, 0, this.auxiliaryPosition, false));
                elements.add(this.makeZeroWidthPenalty(0));
                elements.add(new KnuthGlue(p2WidthOffset - (this.lineStartBAP + this.lineEndBAP), -20016, 0, pos2, false));
                elements.add(this.makeAuxiliaryZeroWidthBox());
                elements.add(this.makeZeroWidthPenalty(1000));
                elements.add(new KnuthGlue(this.lineStartBAP + p3WidthOffset, 10008, 0, pos3, false));
                break;
            }
            case 39: 
            case 135: {
                if (skipZeroCheck || this.lineStartBAP != 0 || this.lineEndBAP != 0) {
                    KnuthGlue g = new KnuthGlue(this.lineEndBAP, 10008, 0, this.auxiliaryPosition, false);
                    elements.add(g);
                    elements.add(this.makeZeroWidthPenalty(0));
                    g = new KnuthGlue(p2WidthOffset - (this.lineStartBAP + this.lineEndBAP), -10008, 0, pos2, false);
                    elements.add(g);
                    elements.add(this.makeAuxiliaryZeroWidthBox());
                    elements.add(this.makeZeroWidthPenalty(1000));
                    g = new KnuthGlue(this.lineStartBAP + p3WidthOffset, 0, 0, pos3, false);
                    elements.add(g);
                    break;
                }
                KnuthGlue g = new KnuthGlue(0, 10008, 0, this.auxiliaryPosition, false);
                elements.add(g);
                elements.add(this.makeZeroWidthPenalty(0));
                g = new KnuthGlue(areaInfo.areaIPD.getOpt(), -10008, 0, pos2, false);
                elements.add(g);
                break;
            }
            case 70: {
                elements.addAll(this.getElementsForJustifiedText(areaInfo, pos2, p2WidthOffset, pos3, p3WidthOffset, skipZeroCheck, areaInfo.areaIPD.getShrink()));
                break;
            }
            default: {
                elements.addAll(this.getElementsForJustifiedText(areaInfo, pos2, p2WidthOffset, pos3, p3WidthOffset, skipZeroCheck, 0));
            }
        }
        return elements;
    }

    private List getElementsForJustifiedText(AreaInfo areaInfo, Position pos2, int p2WidthOffset, Position pos3, int p3WidthOffset, boolean skipZeroCheck, int shrinkability) {
        int stretchability = areaInfo.areaIPD.getStretch();
        ArrayList<KnuthElement> elements = new ArrayList<KnuthElement>();
        if (skipZeroCheck || this.lineStartBAP != 0 || this.lineEndBAP != 0) {
            elements.add(new KnuthGlue(this.lineEndBAP, 0, 0, this.auxiliaryPosition, false));
            elements.add(this.makeZeroWidthPenalty(0));
            elements.add(new KnuthGlue(p2WidthOffset - (this.lineStartBAP + this.lineEndBAP), stretchability, shrinkability, pos2, false));
            elements.add(this.makeAuxiliaryZeroWidthBox());
            elements.add(this.makeZeroWidthPenalty(1000));
            elements.add(new KnuthGlue(this.lineStartBAP + p3WidthOffset, 0, 0, pos3, false));
        } else {
            elements.add(new KnuthGlue(areaInfo.areaIPD.getOpt(), stretchability, shrinkability, pos2, false));
        }
        return elements;
    }

    private void addElementsForAWordFragment(List baseList, int alignment, AreaInfo areaInfo, int leafValue) {
        boolean suppressibleLetterSpace;
        LeafPosition mainPosition = new LeafPosition(this, leafValue);
        boolean bl = suppressibleLetterSpace = areaInfo.breakOppAfter && !areaInfo.isHyphenated;
        if (this.letterSpaceIPD.isStiff()) {
            baseList.add(new KnuthInlineBox(suppressibleLetterSpace ? areaInfo.areaIPD.getOpt() - this.letterSpaceIPD.getOpt() : areaInfo.areaIPD.getOpt(), this.alignmentContext, this.notifyPos(mainPosition), false));
        } else {
            int unsuppressibleLetterSpaces = suppressibleLetterSpace ? areaInfo.letterSpaceCount - 1 : areaInfo.letterSpaceCount;
            baseList.add(new KnuthInlineBox(areaInfo.areaIPD.getOpt() - areaInfo.letterSpaceCount * this.letterSpaceIPD.getOpt(), this.alignmentContext, this.notifyPos(mainPosition), false));
            baseList.add(this.makeZeroWidthPenalty(1000));
            baseList.add(new KnuthGlue(this.letterSpaceIPD.mult(unsuppressibleLetterSpaces), this.auxiliaryPosition, true));
            baseList.add(this.makeAuxiliaryZeroWidthBox());
        }
        if (areaInfo.isHyphenated) {
            MinOptMax widthIfNoBreakOccurs = null;
            if (areaInfo.breakIndex < this.foText.length()) {
                widthIfNoBreakOccurs = this.letterSpaceAdjustArray[areaInfo.breakIndex];
            }
            this.addElementsForAHyphen(baseList, alignment, this.hyphIPD, widthIfNoBreakOccurs, areaInfo.breakOppAfter && areaInfo.isHyphenated);
        } else if (suppressibleLetterSpace) {
            this.addElementsForAHyphen(baseList, alignment, 0, this.letterSpaceIPD, true);
        }
    }

    private void addElementsForAHyphen(List baseList, int alignment, int widthIfBreakOccurs, MinOptMax widthIfNoBreakOccurs, boolean unflagged) {
        if (widthIfNoBreakOccurs == null) {
            widthIfNoBreakOccurs = MinOptMax.ZERO;
        }
        switch (alignment) {
            case 23: {
                baseList.add(this.makeZeroWidthPenalty(1000));
                baseList.add(new KnuthGlue(this.lineEndBAP, 10008, 0, this.auxiliaryPosition, true));
                baseList.add(new KnuthPenalty(this.hyphIPD, unflagged ? 1 : 50, !unflagged, this.auxiliaryPosition, false));
                baseList.add(new KnuthGlue(-(this.lineEndBAP + this.lineStartBAP), -20016, 0, this.auxiliaryPosition, false));
                baseList.add(this.makeAuxiliaryZeroWidthBox());
                baseList.add(this.makeZeroWidthPenalty(1000));
                baseList.add(new KnuthGlue(this.lineStartBAP, 10008, 0, this.auxiliaryPosition, true));
                break;
            }
            case 39: 
            case 135: {
                if (this.lineStartBAP != 0 || this.lineEndBAP != 0) {
                    baseList.add(this.makeZeroWidthPenalty(1000));
                    baseList.add(new KnuthGlue(this.lineEndBAP, 10008, 0, this.auxiliaryPosition, false));
                    baseList.add(new KnuthPenalty(widthIfBreakOccurs, unflagged ? 1 : 50, !unflagged, this.auxiliaryPosition, false));
                    baseList.add(new KnuthGlue(widthIfNoBreakOccurs.getOpt() - (this.lineStartBAP + this.lineEndBAP), -10008, 0, this.auxiliaryPosition, false));
                    baseList.add(this.makeAuxiliaryZeroWidthBox());
                    baseList.add(this.makeZeroWidthPenalty(1000));
                    baseList.add(new KnuthGlue(this.lineStartBAP, 0, 0, this.auxiliaryPosition, false));
                    break;
                }
                baseList.add(this.makeZeroWidthPenalty(1000));
                baseList.add(new KnuthGlue(0, 10008, 0, this.auxiliaryPosition, false));
                baseList.add(new KnuthPenalty(widthIfBreakOccurs, unflagged ? 1 : 50, !unflagged, this.auxiliaryPosition, false));
                baseList.add(new KnuthGlue(widthIfNoBreakOccurs.getOpt(), -10008, 0, this.auxiliaryPosition, false));
                break;
            }
            default: {
                if (this.lineStartBAP != 0 || this.lineEndBAP != 0) {
                    baseList.add(this.makeZeroWidthPenalty(1000));
                    baseList.add(new KnuthGlue(this.lineEndBAP, 0, 0, this.auxiliaryPosition, false));
                    baseList.add(new KnuthPenalty(widthIfBreakOccurs, unflagged ? 1 : 50, !unflagged, this.auxiliaryPosition, false));
                    if (widthIfNoBreakOccurs.isNonZero()) {
                        baseList.add(new KnuthGlue(widthIfNoBreakOccurs.getOpt() - (this.lineStartBAP + this.lineEndBAP), widthIfNoBreakOccurs.getStretch(), widthIfNoBreakOccurs.getShrink(), this.auxiliaryPosition, false));
                    } else {
                        baseList.add(new KnuthGlue(-(this.lineStartBAP + this.lineEndBAP), 0, 0, this.auxiliaryPosition, false));
                    }
                    baseList.add(this.makeAuxiliaryZeroWidthBox());
                    baseList.add(this.makeZeroWidthPenalty(1000));
                    baseList.add(new KnuthGlue(this.lineStartBAP, 0, 0, this.auxiliaryPosition, false));
                    break;
                }
                baseList.add(new KnuthPenalty(widthIfBreakOccurs, unflagged ? 1 : 50, !unflagged, this.auxiliaryPosition, false));
                if (!widthIfNoBreakOccurs.isNonZero()) break;
                baseList.add(new KnuthGlue(widthIfNoBreakOccurs, this.auxiliaryPosition, false));
            }
        }
    }

    public String toString() {
        return super.toString() + "{" + "chars = '" + CharUtilities.toNCRefs(((Object)this.foText.getCharSequence()).toString()) + "'" + ", len = " + this.foText.length() + "}";
    }

    private final class TextAreaBuilder {
        private final MinOptMax width;
        private final int adjust;
        private final LayoutContext context;
        private final int firstIndex;
        private final int lastIndex;
        private final boolean isLastArea;
        private final Font font;
        private TextArea textArea;
        private int blockProgressionDimension;
        private AreaInfo areaInfo;
        private StringBuffer wordChars;
        private int[] letterSpaceAdjust;
        private int letterSpaceAdjustIndex;
        private int[] wordLevels;
        private int wordLevelsIndex;
        private int wordIPD;
        private int[][] gposAdjustments;
        private int gposAdjustmentsIndex;

        private TextAreaBuilder(MinOptMax width, int adjust, LayoutContext context, int firstIndex, int lastIndex, boolean isLastArea, Font font) {
            this.width = width;
            this.adjust = adjust;
            this.context = context;
            this.firstIndex = firstIndex;
            this.lastIndex = lastIndex;
            this.isLastArea = isLastArea;
            this.font = font;
        }

        private TextArea build() {
            this.createTextArea();
            this.setInlineProgressionDimension();
            this.calcBlockProgressionDimension();
            this.setBlockProgressionDimension();
            this.setBaselineOffset();
            this.setBlockProgressionOffset();
            this.setText();
            TraitSetter.addFontTraits(this.textArea, this.font);
            this.textArea.addTrait(Trait.COLOR, TextLayoutManager.this.foText.getColor());
            TraitSetter.addTextDecoration(this.textArea, TextLayoutManager.this.foText.getTextDecoration());
            TraitSetter.addStructureTreeElement(this.textArea, TextLayoutManager.this.foText.getStructureTreeElement());
            return this.textArea;
        }

        private void createTextArea() {
            this.textArea = this.context.getIPDAdjust() == 0.0 ? new TextArea() : new TextArea(this.width.getStretch(), this.width.getShrink(), this.adjust);
        }

        private void setInlineProgressionDimension() {
            this.textArea.setIPD(this.width.getOpt() + this.adjust);
        }

        private void calcBlockProgressionDimension() {
            this.blockProgressionDimension = this.font.getAscender() - this.font.getDescender();
        }

        private void setBlockProgressionDimension() {
            this.textArea.setBPD(this.blockProgressionDimension);
        }

        private void setBaselineOffset() {
            this.textArea.setBaselineOffset(this.font.getAscender());
        }

        private void setBlockProgressionOffset() {
            if (this.blockProgressionDimension == TextLayoutManager.this.alignmentContext.getHeight()) {
                this.textArea.setBlockProgressionOffset(0);
            } else {
                this.textArea.setBlockProgressionOffset(TextLayoutManager.this.alignmentContext.getOffset());
            }
        }

        private void setText() {
            int areaInfoIndex = -1;
            int wordCharLength = 0;
            for (int wordIndex = this.firstIndex; wordIndex <= this.lastIndex; ++wordIndex) {
                this.areaInfo = TextLayoutManager.this.getAreaInfo(wordIndex);
                if (this.areaInfo.isSpace) {
                    this.addSpaces();
                    continue;
                }
                if (areaInfoIndex == -1) {
                    areaInfoIndex = wordIndex;
                    wordCharLength = 0;
                }
                wordCharLength += this.areaInfo.getWordLength();
                if (!this.isWordEnd(wordIndex)) continue;
                this.addWord(areaInfoIndex, wordIndex, wordCharLength);
                areaInfoIndex = -1;
            }
        }

        private boolean isWordEnd(int areaInfoIndex) {
            return areaInfoIndex == this.lastIndex || TextLayoutManager.this.getAreaInfo(areaInfoIndex + 1).isSpace;
        }

        private void addWord(int startIndex, int endIndex, int wordLength) {
            int blockProgressionOffset = 0;
            boolean gposAdjusted = false;
            if (this.isHyphenated(endIndex)) {
                ++wordLength;
            }
            this.initWord(wordLength);
            for (int i = startIndex; i <= endIndex; ++i) {
                AreaInfo wordAreaInfo = TextLayoutManager.this.getAreaInfo(i);
                this.addWordChars(wordAreaInfo);
                this.addLetterAdjust(wordAreaInfo);
                if (!this.addGlyphPositionAdjustments(wordAreaInfo)) continue;
                gposAdjusted = true;
            }
            if (this.isHyphenated(endIndex)) {
                this.addHyphenationChar();
            }
            if (!gposAdjusted) {
                this.gposAdjustments = null;
            }
            this.textArea.addWord(this.wordChars.toString(), this.wordIPD, this.letterSpaceAdjust, this.getNonEmptyLevels(), this.gposAdjustments, blockProgressionOffset);
        }

        private int[] getNonEmptyLevels() {
            if (this.wordLevels != null) {
                assert (this.wordLevelsIndex <= this.wordLevels.length);
                boolean empty = true;
                int n = this.wordLevelsIndex;
                for (int i = 0; i < n; ++i) {
                    if (this.wordLevels[i] < 0) continue;
                    empty = false;
                    break;
                }
                return empty ? null : this.wordLevels;
            }
            return null;
        }

        private void initWord(int wordLength) {
            this.wordChars = new StringBuffer(wordLength);
            this.letterSpaceAdjust = new int[wordLength];
            this.letterSpaceAdjustIndex = 0;
            this.wordLevels = new int[wordLength];
            this.wordLevelsIndex = 0;
            Arrays.fill(this.wordLevels, -1);
            this.gposAdjustments = new int[wordLength][4];
            this.gposAdjustmentsIndex = 0;
            this.wordIPD = 0;
        }

        private boolean isHyphenated(int endIndex) {
            return this.isLastArea && endIndex == this.lastIndex && this.areaInfo.isHyphenated;
        }

        private void addHyphenationChar() {
            this.wordChars.append(TextLayoutManager.this.foText.getCommonHyphenation().getHyphChar(this.font));
        }

        private void addWordChars(AreaInfo wordAreaInfo) {
            int s2 = wordAreaInfo.startIndex;
            int e = wordAreaInfo.breakIndex;
            if (TextLayoutManager.this.foText.hasMapping(s2, e)) {
                this.wordChars.append(TextLayoutManager.this.foText.getMapping(s2, e));
                this.addWordLevels(TextLayoutManager.this.foText.getMappingBidiLevels(s2, e));
            } else {
                for (int i = s2; i < e; ++i) {
                    this.wordChars.append(TextLayoutManager.this.foText.charAt(i));
                }
                this.addWordLevels(TextLayoutManager.this.foText.getBidiLevels(s2, e));
            }
            this.wordIPD += wordAreaInfo.areaIPD.getOpt();
        }

        private void addWordLevels(int[] levels) {
            int numLevels;
            int n = numLevels = levels != null ? levels.length : 0;
            if (numLevels > 0) {
                int need = this.wordLevelsIndex + numLevels;
                if (need <= this.wordLevels.length) {
                    System.arraycopy(levels, 0, this.wordLevels, this.wordLevelsIndex, numLevels);
                } else {
                    throw new IllegalStateException("word levels array too short: expect at least " + need + " entries, but has only " + this.wordLevels.length + " entries");
                }
            }
            this.wordLevelsIndex += numLevels;
        }

        private void addLetterAdjust(AreaInfo wordAreaInfo) {
            int letterSpaceCount = wordAreaInfo.letterSpaceCount;
            int wordLength = wordAreaInfo.getWordLength();
            int taAdjust = this.textArea.getTextLetterSpaceAdjust();
            int n = wordLength;
            for (int i = 0; i < n; ++i) {
                int j = this.letterSpaceAdjustIndex + i;
                if (j > 0) {
                    int k = wordAreaInfo.startIndex + i;
                    MinOptMax adj = k < TextLayoutManager.this.letterSpaceAdjustArray.length ? TextLayoutManager.this.letterSpaceAdjustArray[k] : null;
                    int n2 = this.letterSpaceAdjust[j] = adj == null ? 0 : adj.getOpt();
                }
                if (letterSpaceCount <= 0) continue;
                int n3 = j;
                this.letterSpaceAdjust[n3] = this.letterSpaceAdjust[n3] + taAdjust;
                --letterSpaceCount;
            }
            this.letterSpaceAdjustIndex += wordLength;
        }

        private boolean addGlyphPositionAdjustments(AreaInfo wordAreaInfo) {
            boolean adjusted = false;
            int[][] gpa = wordAreaInfo.gposAdjustments;
            int numAdjusts = gpa != null ? gpa.length : 0;
            int wordLength = wordAreaInfo.getWordLength();
            if (numAdjusts > 0) {
                int need = this.gposAdjustmentsIndex + numAdjusts;
                if (need <= this.gposAdjustments.length) {
                    int n = wordLength;
                    int j = 0;
                    for (int i = 0; i < n; ++i) {
                        if (i >= numAdjusts) continue;
                        int[] wpa1 = this.gposAdjustments[this.gposAdjustmentsIndex + i];
                        int[] wpa2 = gpa[j++];
                        for (int k = 0; k < 4; ++k) {
                            int a = wpa2[k];
                            if (a == 0) continue;
                            int n2 = k;
                            wpa1[n2] = wpa1[n2] + a;
                            adjusted = true;
                        }
                    }
                } else {
                    throw new IllegalStateException("gpos adjustments array too short: expect at least " + need + " entries, but has only " + this.gposAdjustments.length + " entries");
                }
            }
            this.gposAdjustmentsIndex += wordLength;
            return adjusted;
        }

        private void addSpaces() {
            int blockProgressionOffset = 0;
            int numZeroWidthSpaces = 0;
            for (int i = this.areaInfo.startIndex; i < this.areaInfo.breakIndex; ++i) {
                char spaceChar = TextLayoutManager.this.foText.charAt(i);
                if (!CharUtilities.isZeroWidthSpace(spaceChar)) continue;
                ++numZeroWidthSpaces;
            }
            int numSpaces = this.areaInfo.breakIndex - this.areaInfo.startIndex - numZeroWidthSpaces;
            int spaceIPD = this.areaInfo.areaIPD.getOpt() / (numSpaces > 0 ? numSpaces : 1);
            for (int i = this.areaInfo.startIndex; i < this.areaInfo.breakIndex; ++i) {
                char spaceChar = TextLayoutManager.this.foText.charAt(i);
                int level = TextLayoutManager.this.foText.bidiLevelAt(i);
                if (CharUtilities.isZeroWidthSpace(spaceChar)) continue;
                this.textArea.addSpace(spaceChar, spaceIPD, CharUtilities.isAdjustableSpace(spaceChar), blockProgressionOffset, level);
            }
        }
    }

    private final class PendingChange {
        private final AreaInfo areaInfo;
        private final int index;

        private PendingChange(AreaInfo areaInfo, int index2) {
            this.areaInfo = areaInfo;
            this.index = index2;
        }
    }

    private class AreaInfo {
        private final int startIndex;
        private final int breakIndex;
        private int wordCharLength;
        private final int wordSpaceCount;
        private int letterSpaceCount;
        private MinOptMax areaIPD;
        private final boolean isHyphenated;
        private final boolean isSpace;
        private boolean breakOppAfter;
        private final Font font;
        private final int level;
        private final int[][] gposAdjustments;

        AreaInfo(int startIndex, int breakIndex, int wordSpaceCount, int letterSpaceCount, MinOptMax areaIPD, boolean isHyphenated, boolean isSpace2, boolean breakOppAfter, Font font, int level, int[][] gposAdjustments) {
            assert (startIndex <= breakIndex);
            this.startIndex = startIndex;
            this.breakIndex = breakIndex;
            this.wordCharLength = -1;
            this.wordSpaceCount = wordSpaceCount;
            this.letterSpaceCount = letterSpaceCount;
            this.areaIPD = areaIPD;
            this.isHyphenated = isHyphenated;
            this.isSpace = isSpace2;
            this.breakOppAfter = breakOppAfter;
            this.font = font;
            this.level = level;
            this.gposAdjustments = gposAdjustments;
        }

        private int getWordLength() {
            if (this.wordCharLength == -1) {
                if (TextLayoutManager.this.foText.hasMapping(this.startIndex, this.breakIndex)) {
                    this.wordCharLength = TextLayoutManager.this.foText.getMapping(this.startIndex, this.breakIndex).length();
                } else {
                    assert (this.breakIndex >= this.startIndex);
                    this.wordCharLength = this.breakIndex - this.startIndex;
                }
            }
            return this.wordCharLength;
        }

        private void addToAreaIPD(MinOptMax idp) {
            this.areaIPD = this.areaIPD.plus(idp);
        }

        public String toString() {
            return super.toString() + "{" + "interval = [" + this.startIndex + "," + this.breakIndex + "]" + ", isSpace = " + this.isSpace + ", level = " + this.level + ", areaIPD = " + this.areaIPD + ", letterSpaceCount = " + this.letterSpaceCount + ", wordSpaceCount = " + this.wordSpaceCount + ", isHyphenated = " + this.isHyphenated + ", font = " + this.font + "}";
        }
    }
}

