/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf.xref;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.xref.CrossReferenceObject;
import org.apache.fop.pdf.xref.TrailerDictionary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrossReferenceTable
extends CrossReferenceObject {
    private final List<Long> objectReferences;
    private final StringBuilder pdf = new StringBuilder(256);

    public CrossReferenceTable(TrailerDictionary trailerDictionary, long startxref, List<Long> location) {
        super(trailerDictionary, startxref);
        this.objectReferences = location;
    }

    @Override
    public void output(OutputStream stream) throws IOException {
        this.outputXref();
        this.writeTrailer(stream);
    }

    private void outputXref() throws IOException {
        this.pdf.append("xref\n0 ");
        this.pdf.append(this.objectReferences.size() + 1);
        this.pdf.append("\n0000000000 65535 f \n");
        for (Long objectReference : this.objectReferences) {
            String padding2 = "0000000000";
            String s2 = String.valueOf(objectReference);
            if (s2.length() > 10) {
                throw new IOException("PDF file too large. PDF 1.4 cannot grow beyond approx. 9.3GB.");
            }
            String loc = "0000000000".substring(s2.length()) + s2;
            this.pdf.append(loc).append(" 00000 n \n");
        }
    }

    private void writeTrailer(OutputStream stream) throws IOException {
        this.pdf.append("trailer\n");
        stream.write(PDFDocument.encode(this.pdf.toString()));
        PDFDictionary dictionary = this.trailerDictionary.getDictionary();
        dictionary.put("/Size", this.objectReferences.size() + 1);
        dictionary.output(stream);
    }
}

