/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.processor;

import java.util.Vector;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xalan.processor.ProcessorTemplateElem;
import org.apache.xalan.processor.StylesheetHandler;
import org.apache.xalan.processor.XSLTElementDef;
import org.apache.xalan.processor.XSLTElementProcessor;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.ElemExtensionCall;
import org.apache.xalan.templates.ElemLiteralResult;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.templates.XMLNSDecl;
import org.apache.xml.utils.SAXSourceLocator;
import org.apache.xpath.XPath;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ProcessorLRE
extends ProcessorTemplateElem {
    public void startElement(StylesheetHandler handler, String uri, String localName, String rawName, Attributes attributes) throws SAXException {
        try {
            ElemTemplateElement p = handler.getElemTemplateElement();
            boolean excludeXSLDecl = false;
            boolean isLREAsStyleSheet = false;
            if (null == p) {
                StylesheetRoot stylesheet;
                XSLTElementProcessor lreProcessor = handler.popProcessor();
                XSLTElementProcessor stylesheetProcessor = handler.getProcessorFor("http://www.w3.org/1999/XSL/Transform", "stylesheet", "xsl:stylesheet");
                handler.pushProcessor(lreProcessor);
                try {
                    stylesheet = new StylesheetRoot(handler.getSchema(), handler.getStylesheetProcessor().getErrorListener());
                }
                catch (TransformerConfigurationException tfe) {
                    throw new TransformerException(tfe);
                }
                SAXSourceLocator slocator = new SAXSourceLocator();
                SAXSourceLocator locator = handler.getLocator();
                if (null != locator) {
                    slocator.setLineNumber(locator.getLineNumber());
                    slocator.setColumnNumber(locator.getColumnNumber());
                    slocator.setPublicId(locator.getPublicId());
                    slocator.setSystemId(locator.getSystemId());
                }
                stylesheet.setLocaterInfo(slocator);
                stylesheet.setPrefixes(handler.getNamespaceSupport());
                handler.pushStylesheet(stylesheet);
                isLREAsStyleSheet = true;
                AttributesImpl stylesheetAttrs = new AttributesImpl();
                AttributesImpl lreAttrs = new AttributesImpl();
                int n = attributes.getLength();
                int i = 0;
                while (i < n) {
                    String attrLocalName = attributes.getLocalName(i);
                    String attrUri = attributes.getURI(i);
                    String value2 = attributes.getValue(i);
                    if (null != attrUri && attrUri.equals("http://www.w3.org/1999/XSL/Transform")) {
                        stylesheetAttrs.addAttribute(null, attrLocalName, attrLocalName, attributes.getType(i), attributes.getValue(i));
                    } else if (!attrLocalName.startsWith("xmlns:") && !attrLocalName.equals("xmlns") || !value2.equals("http://www.w3.org/1999/XSL/Transform")) {
                        lreAttrs.addAttribute(attrUri, attrLocalName, attributes.getQName(i), attributes.getType(i), attributes.getValue(i));
                    }
                    ++i;
                }
                attributes = lreAttrs;
                try {
                    stylesheetProcessor.setPropertiesFromAttributes(handler, "stylesheet", stylesheetAttrs, stylesheet);
                }
                catch (Exception e) {
                    if (stylesheet.getDeclaredPrefixes() == null || !this.declaredXSLNS(stylesheet)) {
                        throw new SAXException(XSLMessages.createWarning("WG_OLD_XSLT_NS", null));
                    }
                    throw new SAXException(e);
                }
                handler.pushElemTemplateElement(stylesheet);
                ElemTemplate template = new ElemTemplate();
                this.appendAndPush(handler, template);
                XPath rootMatch = new XPath("/", stylesheet, stylesheet, 1, handler.getStylesheetProcessor().getErrorListener());
                template.setMatch(rootMatch);
                stylesheet.setTemplate(template);
                p = handler.getElemTemplateElement();
                excludeXSLDecl = true;
            }
            XSLTElementDef def = this.getElemDef();
            Class classObject = def.getClassObject();
            boolean isExtension = false;
            boolean isComponentDecl = false;
            boolean isUnknownTopLevel = false;
            while (null != p) {
                ElemTemplateElement parentElem;
                if (p instanceof ElemLiteralResult) {
                    parentElem = (ElemLiteralResult)p;
                    isExtension = ((ElemLiteralResult)parentElem).containsExtensionElementURI(uri);
                } else if (p instanceof Stylesheet) {
                    parentElem = (Stylesheet)p;
                    isExtension = ((Stylesheet)parentElem).containsExtensionElementURI(uri);
                    if (!isExtension && null != uri && (uri.equals("http://xml.apache.org/xalan") || uri.equals("http://xml.apache.org/xslt"))) {
                        isComponentDecl = true;
                    } else {
                        isUnknownTopLevel = true;
                    }
                }
                if (isExtension) break;
                p = p.getParentElem();
            }
            ElemTemplateElement elem2 = null;
            try {
                elem2 = isExtension ? new ElemExtensionCall() : (isComponentDecl ? (ElemTemplateElement)classObject.newInstance() : (isUnknownTopLevel ? (ElemTemplateElement)classObject.newInstance() : (ElemTemplateElement)classObject.newInstance()));
                elem2.setDOMBackPointer(handler.getOriginatingNode());
                elem2.setLocaterInfo(handler.getLocator());
                elem2.setPrefixes(handler.getNamespaceSupport(), excludeXSLDecl);
                if (elem2 instanceof ElemLiteralResult) {
                    ((ElemLiteralResult)elem2).setNamespace(uri);
                    ((ElemLiteralResult)elem2).setLocalName(localName);
                    ((ElemLiteralResult)elem2).setRawName(rawName);
                    ((ElemLiteralResult)elem2).setIsLiteralResultAsStylesheet(isLREAsStyleSheet);
                }
            }
            catch (InstantiationException ie) {
                handler.error("ER_FAILED_CREATING_ELEMLITRSLT", null, ie);
            }
            catch (IllegalAccessException iae) {
                handler.error("ER_FAILED_CREATING_ELEMLITRSLT", null, iae);
            }
            this.setPropertiesFromAttributes(handler, rawName, attributes, elem2);
            if (!isExtension && elem2 instanceof ElemLiteralResult && (isExtension = ((ElemLiteralResult)elem2).containsExtensionElementURI(uri))) {
                elem2 = new ElemExtensionCall();
                elem2.setLocaterInfo(handler.getLocator());
                elem2.setPrefixes(handler.getNamespaceSupport());
                ((ElemLiteralResult)elem2).setNamespace(uri);
                ((ElemLiteralResult)elem2).setLocalName(localName);
                ((ElemLiteralResult)elem2).setRawName(rawName);
                this.setPropertiesFromAttributes(handler, rawName, attributes, elem2);
            }
            this.appendAndPush(handler, elem2);
        }
        catch (TransformerException te) {
            throw new SAXException(te);
        }
    }

    public void endElement(StylesheetHandler handler, String uri, String localName, String rawName) throws SAXException {
        ElemTemplateElement elem2 = handler.getElemTemplateElement();
        if (elem2 instanceof ElemLiteralResult && ((ElemLiteralResult)elem2).getIsLiteralResultAsStylesheet()) {
            handler.popStylesheet();
        }
        super.endElement(handler, uri, localName, rawName);
    }

    private boolean declaredXSLNS(Stylesheet stylesheet) {
        Vector declaredPrefixes = stylesheet.getDeclaredPrefixes();
        int n = declaredPrefixes.size();
        int i = 0;
        while (i < n) {
            XMLNSDecl decl = (XMLNSDecl)declaredPrefixes.elementAt(i);
            if (decl.getURI().equals("http://www.w3.org/1999/XSL/Transform")) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

