/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.ps.dsc.events;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSProcSet;
import org.apache.xmlgraphics.ps.PSResource;
import org.apache.xmlgraphics.ps.dsc.events.AbstractDSCComment;

public abstract class AbstractResourceDSCComment
extends AbstractDSCComment {
    private PSResource resource;

    public AbstractResourceDSCComment() {
    }

    public AbstractResourceDSCComment(PSResource resource) {
        this.resource = resource;
    }

    public PSResource getResource() {
        return this.resource;
    }

    public boolean hasValues() {
        return true;
    }

    public void parseValue(String value2) {
        List params = this.splitParams(value2);
        Iterator iter2 = params.iterator();
        String name = (String)iter2.next();
        if ("font".equals(name)) {
            String fontname = (String)iter2.next();
            this.resource = new PSResource(name, fontname);
        } else if ("procset".equals(name)) {
            String procname = (String)iter2.next();
            String version = (String)iter2.next();
            String revision = (String)iter2.next();
            this.resource = new PSProcSet(procname, Float.parseFloat(version), Integer.parseInt(revision));
        } else if ("file".equals(name)) {
            String filename = (String)iter2.next();
            this.resource = new PSResource(name, filename);
        } else if ("form".equals(name)) {
            String formname = (String)iter2.next();
            this.resource = new PSResource(name, formname);
        } else if ("pattern".equals(name)) {
            String patternname = (String)iter2.next();
            this.resource = new PSResource(name, patternname);
        } else if ("encoding".equals(name)) {
            String encodingname = (String)iter2.next();
            this.resource = new PSResource(name, encodingname);
        } else {
            throw new IllegalArgumentException("Invalid resource type: " + name);
        }
    }

    public void generate(PSGenerator gen) throws IOException {
        gen.writeDSCComment(this.getName(), this.getResource());
    }
}

