/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.functions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.apache.xpath.functions.SecuritySupport;

class ObjectFactory {
    private static final String DEFAULT_PROPERTIES_FILENAME = "xalan.properties";
    private static final String SERVICES_PATH = "META-INF/services/";
    private static final boolean DEBUG = false;
    private static Properties fXalanProperties = null;
    private static long fLastModified = -1L;
    static /* synthetic */ Class class$org$apache$xpath$functions$ObjectFactory;

    ObjectFactory() {
    }

    static Object createObject(String factoryId, String fallbackClassName) throws ConfigurationError {
        return ObjectFactory.createObject(factoryId, null, fallbackClassName);
    }

    static Object createObject(String factoryId, String propertiesFilename, String fallbackClassName) throws ConfigurationError {
        Class factoryClass = ObjectFactory.lookUpFactoryClass(factoryId, propertiesFilename, fallbackClassName);
        if (factoryClass == null) {
            throw new ConfigurationError("Provider for " + factoryId + " cannot be found", null);
        }
        try {
            Object instance = factoryClass.newInstance();
            ObjectFactory.debugPrintln("created new instance of factory " + factoryId);
            return instance;
        }
        catch (Exception x) {
            throw new ConfigurationError("Provider for factory " + factoryId + " could not be instantiated: " + x, x);
        }
    }

    static Class lookUpFactoryClass(String factoryId) throws ConfigurationError {
        return ObjectFactory.lookUpFactoryClass(factoryId, null, null);
    }

    static Class lookUpFactoryClass(String factoryId, String propertiesFilename, String fallbackClassName) throws ConfigurationError {
        String factoryClassName = ObjectFactory.lookUpFactoryClassName(factoryId, propertiesFilename, fallbackClassName);
        ClassLoader cl = ObjectFactory.findClassLoader();
        if (factoryClassName == null) {
            factoryClassName = fallbackClassName;
        }
        try {
            Class providerClass = ObjectFactory.findProviderClass(factoryClassName, cl, true);
            ObjectFactory.debugPrintln("created new instance of " + providerClass + " using ClassLoader: " + cl);
            return providerClass;
        }
        catch (ClassNotFoundException x) {
            throw new ConfigurationError("Provider " + factoryClassName + " not found", x);
        }
        catch (Exception x) {
            throw new ConfigurationError("Provider " + factoryClassName + " could not be instantiated: " + x, x);
        }
    }

    static String lookUpFactoryClassName(String factoryId, String propertiesFilename, String fallbackClassName) {
        SecuritySupport ss = SecuritySupport.getInstance();
        try {
            String systemProp = ss.getSystemProperty(factoryId);
            if (systemProp != null) {
                ObjectFactory.debugPrintln("found system property, value=" + systemProp);
                return systemProp;
            }
        }
        catch (SecurityException se) {
            // empty catch block
        }
        String factoryClassName = null;
        if (propertiesFilename == null) {
            File propertiesFile = null;
            boolean propertiesFileExists = false;
            try {
                String javah = ss.getSystemProperty("java.home");
                propertiesFilename = javah + File.separator + "lib" + File.separator + DEFAULT_PROPERTIES_FILENAME;
                propertiesFile = new File(propertiesFilename);
                propertiesFileExists = ss.getFileExists(propertiesFile);
            }
            catch (SecurityException e) {
                fLastModified = -1L;
                fXalanProperties = null;
            }
            Class clazz = class$org$apache$xpath$functions$ObjectFactory == null ? (class$org$apache$xpath$functions$ObjectFactory = ObjectFactory.class$("org.apache.xpath.functions.ObjectFactory")) : class$org$apache$xpath$functions$ObjectFactory;
            synchronized (clazz) {
                boolean loadProperties = false;
                try {
                    if (fLastModified >= 0L) {
                        if (propertiesFileExists && fLastModified < (fLastModified = ss.getLastModified(propertiesFile))) {
                            loadProperties = true;
                        } else if (!propertiesFileExists) {
                            fLastModified = -1L;
                            fXalanProperties = null;
                        }
                    } else if (propertiesFileExists) {
                        loadProperties = true;
                        fLastModified = ss.getLastModified(propertiesFile);
                    }
                    if (loadProperties) {
                        fXalanProperties = new Properties();
                        FileInputStream fis = ss.getFileInputStream(propertiesFile);
                        fXalanProperties.load(fis);
                        fis.close();
                    }
                }
                catch (Exception x) {
                    fXalanProperties = null;
                    fLastModified = -1L;
                }
            }
            if (fXalanProperties != null) {
                factoryClassName = fXalanProperties.getProperty(factoryId);
            }
        } else {
            try {
                FileInputStream fis = ss.getFileInputStream(new File(propertiesFilename));
                Properties props = new Properties();
                props.load(fis);
                fis.close();
                factoryClassName = props.getProperty(factoryId);
            }
            catch (Exception x) {
                // empty catch block
            }
        }
        if (factoryClassName != null) {
            ObjectFactory.debugPrintln("found in " + propertiesFilename + ", value=" + factoryClassName);
            return factoryClassName;
        }
        return ObjectFactory.findJarServiceProviderName(factoryId);
    }

    private static void debugPrintln(String msg) {
    }

    static ClassLoader findClassLoader() throws ConfigurationError {
        ClassLoader system;
        SecuritySupport ss = SecuritySupport.getInstance();
        ClassLoader context = ss.getContextClassLoader();
        ClassLoader chain2 = system = ss.getSystemClassLoader();
        while (true) {
            if (context == chain2) {
                ClassLoader current = (class$org$apache$xpath$functions$ObjectFactory == null ? (class$org$apache$xpath$functions$ObjectFactory = ObjectFactory.class$("org.apache.xpath.functions.ObjectFactory")) : class$org$apache$xpath$functions$ObjectFactory).getClassLoader();
                chain2 = system;
                while (true) {
                    if (current == chain2) {
                        return system;
                    }
                    if (chain2 == null) break;
                    chain2 = ss.getParentClassLoader(chain2);
                }
                return current;
            }
            if (chain2 == null) break;
            chain2 = ss.getParentClassLoader(chain2);
        }
        return context;
    }

    static Object newInstance(String className, ClassLoader cl, boolean doFallback) throws ConfigurationError {
        try {
            Class providerClass = ObjectFactory.findProviderClass(className, cl, doFallback);
            Object instance = providerClass.newInstance();
            ObjectFactory.debugPrintln("created new instance of " + providerClass + " using ClassLoader: " + cl);
            return instance;
        }
        catch (ClassNotFoundException x) {
            throw new ConfigurationError("Provider " + className + " not found", x);
        }
        catch (Exception x) {
            throw new ConfigurationError("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    static Class findProviderClass(String className, ClassLoader cl, boolean doFallback) throws ClassNotFoundException, ConfigurationError {
        Class<?> providerClass;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPackageAccess(className);
        }
        if (cl == null) {
            providerClass = Class.forName(className);
        } else {
            try {
                providerClass = cl.loadClass(className);
            }
            catch (ClassNotFoundException x) {
                if (doFallback) {
                    ClassLoader current = (class$org$apache$xpath$functions$ObjectFactory == null ? (class$org$apache$xpath$functions$ObjectFactory = ObjectFactory.class$("org.apache.xpath.functions.ObjectFactory")) : class$org$apache$xpath$functions$ObjectFactory).getClassLoader();
                    if (current == null) {
                        providerClass = Class.forName(className);
                    }
                    if (cl != current) {
                        cl = current;
                        providerClass = cl.loadClass(className);
                    }
                    throw x;
                }
                throw x;
            }
        }
        return providerClass;
    }

    private static String findJarServiceProviderName(String factoryId) {
        BufferedReader rd;
        ClassLoader current;
        SecuritySupport ss = SecuritySupport.getInstance();
        String serviceId = SERVICES_PATH + factoryId;
        InputStream is = null;
        ClassLoader cl = ObjectFactory.findClassLoader();
        is = ss.getResourceAsStream(cl, serviceId);
        if (is == null && cl != (current = (class$org$apache$xpath$functions$ObjectFactory == null ? (class$org$apache$xpath$functions$ObjectFactory = ObjectFactory.class$("org.apache.xpath.functions.ObjectFactory")) : class$org$apache$xpath$functions$ObjectFactory).getClassLoader())) {
            cl = current;
            is = ss.getResourceAsStream(cl, serviceId);
        }
        if (is == null) {
            return null;
        }
        ObjectFactory.debugPrintln("found jar resource=" + serviceId + " using ClassLoader: " + cl);
        try {
            rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            rd = new BufferedReader(new InputStreamReader(is));
        }
        String factoryClassName = null;
        try {
            factoryClassName = rd.readLine();
            rd.close();
        }
        catch (IOException x) {
            return null;
        }
        if (factoryClassName != null && !"".equals(factoryClassName)) {
            ObjectFactory.debugPrintln("found in resource, value=" + factoryClassName);
            return factoryClassName;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ConfigurationError
    extends Error {
        private Exception exception;

        ConfigurationError(String msg, Exception x) {
            super(msg);
            this.exception = x;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

