/*
 * Decompiled with CFR 0.152.
 */
package org.gedcom4j.io;

import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Encoding {
    ASCII("ASCII"),
    ANSEL("ANSEL"),
    UNICODE_BIG_ENDIAN("UNICODE"),
    UNICODE_LITTLE_ENDIAN("UNICODE"),
    UTF_8("UTF-8");

    private String characterSetName;

    public static Set<String> getSupportedCharacterSetNames() {
        TreeSet<String> result2 = new TreeSet<String>();
        for (Encoding e : Encoding.values()) {
            result2.add(e.characterSetName);
        }
        return result2;
    }

    public static boolean isValidCharacterSetName(String characterSetName) {
        for (Encoding e : Encoding.values()) {
            if (!e.characterSetName.equals(characterSetName)) continue;
            return true;
        }
        return false;
    }

    private Encoding(String characterSetName) {
        this.characterSetName = characterSetName;
    }

    public String getCharacterSetName() {
        return this.characterSetName;
    }
}

