/*
 * Decompiled with CFR 0.152.
 */
package org.gedcom4j.validate;

import java.util.ArrayList;
import java.util.Iterator;
import org.gedcom4j.model.AbstractCitation;
import org.gedcom4j.model.AbstractElement;
import org.gedcom4j.model.Event;
import org.gedcom4j.model.Multimedia;
import org.gedcom4j.model.StringWithCustomTags;
import org.gedcom4j.validate.AbstractValidator;
import org.gedcom4j.validate.AddressValidator;
import org.gedcom4j.validate.CitationValidator;
import org.gedcom4j.validate.GedcomValidator;
import org.gedcom4j.validate.MultimediaValidator;
import org.gedcom4j.validate.PlaceValidator;

public class EventValidator
extends AbstractValidator {
    private Event e;

    public EventValidator(GedcomValidator rootValidator, Event e) {
        this.rootValidator = rootValidator;
        this.e = e;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void validate() {
        if (this.e == null) {
            this.addError("Event is null and cannot be validated or autorepaired");
            return;
        }
        if (this.e.address != null) {
            new AddressValidator(this.rootValidator, this.e.address).validate();
        }
        this.checkOptionalString(this.e.age, "age", (Object)this.e);
        this.checkOptionalString(this.e.cause, "cause", (Object)this.e);
        if (this.e.citations == null) {
            if (!this.rootValidator.autorepair) {
                this.rootValidator.addError("Event has null list of citations", this.e);
                return;
            }
            this.e.citations = new ArrayList<AbstractCitation>();
            this.rootValidator.addInfo("Event had null list of citations - repaired", this.e);
        } else {
            for (AbstractCitation c : this.e.citations) {
                new CitationValidator(this.rootValidator, c).validate();
            }
        }
        this.checkCustomTags(this.e);
        this.checkOptionalString(this.e.date, "date", (Object)this.e);
        this.checkOptionalString(this.e.description, "description", (Object)this.e);
        if (this.e.emails == null) {
            if (this.rootValidator.autorepair) {
                this.e.emails = new ArrayList<StringWithCustomTags>();
                this.rootValidator.addInfo("Event had null list of emails - repaired", this.e);
            } else {
                this.rootValidator.addError("Event has null list of emails", this.e);
            }
        } else {
            for (StringWithCustomTags swct : this.e.emails) {
                this.checkRequiredString(swct, "email", (Object)this.e);
            }
        }
        if (this.e.faxNumbers == null) {
            if (this.rootValidator.autorepair) {
                this.e.faxNumbers = new ArrayList<StringWithCustomTags>();
                this.rootValidator.addInfo("Event had null list of fax numbers - repaired", this.e);
            } else {
                this.rootValidator.addError("Event has null list of fax numbers", this.e);
            }
        } else {
            for (StringWithCustomTags swct : this.e.faxNumbers) {
                this.checkRequiredString(swct, "fax number", (Object)this.e);
            }
        }
        if (this.e.multimedia == null) {
            if (this.rootValidator.autorepair) {
                this.e.multimedia = new ArrayList<Multimedia>();
                this.rootValidator.addInfo("Event had null list of multimedia - repaired", this.e);
            } else {
                this.rootValidator.addError("Event has null list of multimedia", this.e);
            }
        } else {
            for (Multimedia m : this.e.multimedia) {
                new MultimediaValidator(this.rootValidator, m).validate();
            }
        }
        this.checkNotes(this.e.notes, this.e);
        if (this.e.phoneNumbers == null) {
            if (this.rootValidator.autorepair) {
                this.e.faxNumbers = new ArrayList<StringWithCustomTags>();
                this.rootValidator.addInfo("Event had null list of phone numbers - repaired", this.e);
            } else {
                this.rootValidator.addError("Event has null list of phone numbers", this.e);
            }
        } else {
            for (StringWithCustomTags swct : this.e.phoneNumbers) {
                this.checkRequiredString(swct, "phone numbe", (Object)this.e);
            }
        }
        if (this.e.place != null) {
            new PlaceValidator(this.rootValidator, this.e.place).validate();
        }
        this.checkOptionalString(this.e.religiousAffiliation, "religious affiliation", (Object)this.e);
        this.checkOptionalString(this.e.respAgency, "responsible agency", (Object)this.e);
        this.checkOptionalString(this.e.restrictionNotice, "restriction notice", (Object)this.e);
        this.checkOptionalString(this.e.subType, "subtype", (Object)this.e);
        if (this.e.wwwUrls == null) {
            if (this.rootValidator.autorepair) {
                this.e.wwwUrls = new ArrayList<StringWithCustomTags>();
                this.rootValidator.addInfo("Event had null list of www urls - repaired", this.e);
                return;
            }
            this.rootValidator.addError("Event has null list of www url", this.e);
            return;
        }
        Iterator<AbstractElement> i$ = this.e.wwwUrls.iterator();
        while (i$.hasNext()) {
            StringWithCustomTags swct;
            swct = (StringWithCustomTags)i$.next();
            this.checkRequiredString(swct, "www url", (Object)this.e);
        }
    }
}

