/*
 * Decompiled with CFR 0.152.
 */
package org.gedcom4j.validate;

import java.util.ArrayList;
import org.gedcom4j.model.AbstractCitation;
import org.gedcom4j.model.Family;
import org.gedcom4j.model.FamilyEvent;
import org.gedcom4j.model.Individual;
import org.gedcom4j.model.LdsSpouseSealing;
import org.gedcom4j.model.Multimedia;
import org.gedcom4j.model.Submitter;
import org.gedcom4j.validate.AbstractValidator;
import org.gedcom4j.validate.CitationValidator;
import org.gedcom4j.validate.EventValidator;
import org.gedcom4j.validate.GedcomValidator;
import org.gedcom4j.validate.IndividualValidator;
import org.gedcom4j.validate.LdsSpouseSealingValidator;
import org.gedcom4j.validate.MultimediaValidator;
import org.gedcom4j.validate.SubmitterValidator;

public class FamilyValidator
extends AbstractValidator {
    private Family f;

    public FamilyValidator(GedcomValidator gedcomValidator, Family f) {
        this.rootValidator = gedcomValidator;
        this.f = f;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void validate() {
        this.checkOptionalString(this.f.automatedRecordId, "Automated record id", (Object)this.f);
        this.checkChangeDate(this.f.changeDate, this.f);
        if (this.f.children == null) {
            if (this.rootValidator.autorepair) {
                this.f.children = new ArrayList<Individual>();
                this.rootValidator.addInfo("Family's collection of children was null - repaired", this.f);
            } else {
                this.rootValidator.addError("Family's collection of children is null", this.f);
            }
        } else {
            for (Individual individual : this.f.children) {
                if (individual != null) continue;
                this.rootValidator.addError("Family with xref '" + this.f.xref + "' has a null entry in children collection", this.f);
            }
        }
        if (this.f.citations == null) {
            if (this.rootValidator.autorepair) {
                this.f.citations = new ArrayList<AbstractCitation>();
                this.addInfo("citations collection for family was null - rootValidator.autorepaired", this.f);
            } else {
                this.addError("citations collection for family is null", this.f);
            }
        } else {
            for (AbstractCitation abstractCitation : this.f.citations) {
                new CitationValidator(this.rootValidator, abstractCitation).validate();
            }
        }
        this.checkCustomTags(this.f);
        for (FamilyEvent familyEvent : this.f.events) {
            new EventValidator(this.rootValidator, familyEvent).validate();
        }
        if (this.f.husband != null) {
            new IndividualValidator(this.rootValidator, this.f.husband).validate();
        }
        if (this.f.wife != null) {
            new IndividualValidator(this.rootValidator, this.f.wife).validate();
        }
        if (this.f.ldsSpouseSealings == null) {
            if (this.rootValidator.autorepair) {
                this.f.ldsSpouseSealings = new ArrayList<LdsSpouseSealing>();
                this.addInfo("LDS spouse sealings collection for family was null - rootValidator.autorepaired", this.f);
            } else {
                this.addError("LDS spouse sealings collection for family is null", this.f);
            }
        } else {
            for (LdsSpouseSealing ldsSpouseSealing : this.f.ldsSpouseSealings) {
                new LdsSpouseSealingValidator(this.rootValidator, ldsSpouseSealing).validate();
            }
        }
        if (this.f.multimedia == null) {
            if (this.rootValidator.autorepair) {
                this.f.multimedia = new ArrayList<Multimedia>();
                this.addInfo("Multimedia collection for family was null - rootValidator.autorepaired", this.f);
            } else {
                this.addError("Multimedia collection for family is null", this.f);
            }
        } else {
            for (Multimedia multimedia : this.f.multimedia) {
                new MultimediaValidator(this.rootValidator, multimedia).validate();
            }
        }
        this.checkNotes(this.f.notes, this.f);
        this.checkOptionalString(this.f.numChildren, "number of children", (Object)this.f);
        this.checkOptionalString(this.f.recFileNumber, "record file number", (Object)this.f);
        this.checkOptionalString(this.f.restrictionNotice, "restriction notice", (Object)this.f);
        if (this.f.submitters == null) {
            if (!this.rootValidator.autorepair) {
                this.addInfo("Submitters collection is missing on family", this.f);
                return;
            }
            this.f.submitters = new ArrayList<Submitter>();
            this.addInfo("Submitters collection was missing on family - repaired", this.f);
        } else {
            for (Submitter submitter : this.f.submitters) {
                new SubmitterValidator(this.rootValidator, submitter).validate();
            }
        }
        this.checkUserReferences(this.f.userReferences, this.f);
    }
}

