/*
 * Decompiled with CFR 0.152.
 */
package org.gedcom4j.validate;

import java.util.ArrayList;
import org.gedcom4j.model.AbstractCitation;
import org.gedcom4j.model.Association;
import org.gedcom4j.model.Individual;
import org.gedcom4j.model.IndividualAttribute;
import org.gedcom4j.model.IndividualEvent;
import org.gedcom4j.model.PersonalName;
import org.gedcom4j.model.StringWithCustomTags;
import org.gedcom4j.model.Submitter;
import org.gedcom4j.validate.AbstractValidator;
import org.gedcom4j.validate.CitationValidator;
import org.gedcom4j.validate.EventValidator;
import org.gedcom4j.validate.GedcomValidator;
import org.gedcom4j.validate.PersonalNameValidator;
import org.gedcom4j.validate.SubmitterValidator;

class IndividualValidator
extends AbstractValidator {
    private final Individual individual;

    public IndividualValidator(GedcomValidator gedcomValidator, Individual individual) {
        this.rootValidator = gedcomValidator;
        this.individual = individual;
    }

    protected void validate() {
        if (this.individual == null) {
            this.addError("Individual is null");
            return;
        }
        this.checkXref(this.individual);
        if (this.individual.names == null) {
            if (this.rootValidator.autorepair) {
                this.individual.names = new ArrayList<PersonalName>();
                this.rootValidator.addInfo("Individual " + this.individual.xref + " had no list of names - repaired", this.individual);
            } else {
                this.rootValidator.addError("Individual " + this.individual.xref + " has no list of names", this.individual);
            }
        } else {
            for (PersonalName pn : this.individual.names) {
                new PersonalNameValidator(this.rootValidator, pn).validate();
            }
        }
        this.checkAliases();
        this.checkAssociations();
        this.checkCitations();
        this.checkIndividualAttributes();
        this.checkSubmitters();
        this.checkIndividualEvents();
    }

    private void checkAliases() {
        if (this.individual.aliases == null) {
            if (this.rootValidator.autorepair) {
                this.individual.aliases = new ArrayList<StringWithCustomTags>();
                this.addInfo("aliases collection for individual was null - rootValidator.autorepaired", this.individual);
            } else {
                this.addError("aliases collection for individual is null", this.individual);
            }
        } else {
            this.checkStringTagList(this.individual.aliases, "aliases on individual", false);
        }
    }

    private void checkAssociations() {
        if (this.individual.associations == null) {
            if (this.rootValidator.autorepair) {
                this.individual.associations = new ArrayList<Association>();
                this.addInfo("associations collection for individual was null - rootValidator.autorepaired", this.individual);
            } else {
                this.addError("associations collection for individual is null", this.individual);
            }
        } else {
            for (Association a : this.individual.associations) {
                if (a == null) {
                    this.addError("associations collection for individual contains null entry", this.individual);
                    continue;
                }
                this.checkRequiredString(a.associatedEntityType, "associated entity type", (Object)a);
                this.checkXref(a, "associatedEntityXref");
            }
        }
    }

    private void checkCitations() {
        if (this.individual.citations == null) {
            if (this.rootValidator.autorepair) {
                this.individual.citations = new ArrayList<AbstractCitation>();
                this.addInfo("citations collection for individual was null - rootValidator.autorepaired", this.individual);
            } else {
                this.addError("citations collection for individual is null", this.individual);
            }
        } else {
            for (AbstractCitation c : this.individual.citations) {
                new CitationValidator(this.rootValidator, c).validate();
            }
        }
    }

    private void checkIndividualAttributes() {
        if (this.individual.attributes == null) {
            if (this.rootValidator.autorepair) {
                this.individual.attributes = new ArrayList<IndividualAttribute>();
                this.addInfo("attributes collection for individual was null - rootValidator.autorepaired", this.individual);
            } else {
                this.addError("attributes collection for individual is null", this.individual);
            }
        } else {
            for (IndividualAttribute a : this.individual.attributes) {
                if (a.type != null) continue;
                this.addError("Individual attribute requires a type", a);
            }
        }
    }

    private void checkIndividualEvents() {
        if (this.individual.events == null) {
            if (this.rootValidator.autorepair) {
                this.individual.events = new ArrayList<IndividualEvent>();
                this.addInfo("events collection for individual was null - rootValidator.autorepaired", this.individual);
            } else {
                this.addError("events collection for individual is null", this.individual);
            }
        } else {
            for (IndividualEvent a : this.individual.events) {
                if (a.type == null) {
                    this.addError("Individual event requires a type", a);
                }
                new EventValidator(this.rootValidator, a).validate();
            }
        }
    }

    private void checkSubmitters() {
        if (this.individual.ancestorInterest == null) {
            if (this.rootValidator.autorepair) {
                this.individual.ancestorInterest = new ArrayList<Submitter>();
                this.addInfo("ancestorInterest collection for individual was null - rootValidator.autorepaired", this.individual);
            } else {
                this.addError("ancestorInterest collection for individual is null", this.individual);
            }
        } else {
            for (Submitter submitter : this.individual.ancestorInterest) {
                new SubmitterValidator(this.rootValidator, submitter).validate();
            }
        }
        if (this.individual.descendantInterest == null) {
            if (this.rootValidator.autorepair) {
                this.individual.descendantInterest = new ArrayList<Submitter>();
                this.addInfo("descendantInterest collection for individual was null - rootValidator.autorepaired", this.individual);
            } else {
                this.addError("descendantInterest collection for individual is null", this.individual);
            }
        } else {
            for (Submitter submitter : this.individual.descendantInterest) {
                new SubmitterValidator(this.rootValidator, submitter).validate();
            }
        }
    }
}

