/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.script.app;

import fi.evolver.script.FileUtils;
import fi.evolver.script.Shell;
import fi.evolver.script.Step;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class Xfce {
    private static final Path CONFIG_DIR = Shell.HOME.resolve(".config");
    private static final Path AUTOSTART_DIR = CONFIG_DIR.resolve("autostart");

    public static void writeUserConfigDir(Path configDirSource) throws IOException {
        try (Step step = Step.start("Configure Xfce");){
            Path target = CONFIG_DIR.resolve("xfce4");
            if (Files.exists(target, new LinkOption[0])) {
                Files.move(target, target.resolveSibling("xfce4-old"), new CopyOption[0]);
            }
            Shell.user("tar", "xzf", configDirSource.toString(), "-C", CONFIG_DIR.toString());
        }
    }

    public static void configureGnomeKeyringAutostart() throws IOException {
        try (Step step = Step.start("Configure Gnome Keyring autostart");){
            Files.createDirectories(AUTOSTART_DIR, new FileAttribute[0]);
            FileUtils.write(AUTOSTART_DIR.resolve("gnome-keyring-ssh.desktop"), "[Desktop Entry]\nX-XFCE-Autostart-Override=true\n");
            Shell.sudo("sed", "-i", "-E", "s/^use-ssh-agent/no-use-ssh-agent/", "/etc/X11/Xsession.options");
        }
    }

    public static void addAutostartScript(String desktopEntryFilename, String name, String execString) throws IOException {
        try (Step step = Step.start("Add autostart script: %s".formatted(name));){
            Files.createDirectories(AUTOSTART_DIR, new FileAttribute[0]);
            FileUtils.write(AUTOSTART_DIR.resolve(desktopEntryFilename), "[Desktop Entry]\nType=Application\nName=%s\nExec=%s\nTerminal=false\nNoDisplay=false\nOnlyShowIn=XFCE;\n".formatted(name, execString));
        }
    }
}

