package io.bitsensor.plugins.java.sql.handler;

import io.bitsensor.lib.entity.proto.Invocation.SQLInvocation.Builder;
import io.bitsensor.plugins.java.core.handler.HandlerManager;

import java.sql.Statement;

import static io.bitsensor.plugins.java.core.handler.Handler.ExecutionMoment.POST_HANDLE;
import static io.bitsensor.plugins.java.core.handler.Handler.ExecutionMoment.PRE_HANDLE;

public class SQLStatementHandlerManager extends HandlerManager<SQLHandler> implements SQLInvocationHandler {

    /**
     * Runs all handlers that should be executed before a SQL statement is executed.
     */
    @Override
    public void preHandle(Statement statement, Builder builder) {
        for (SQLHandler sqlHandler : getHandlers()) {
            if (sqlHandler.getExecutionMoment() == PRE_HANDLE)
                sqlHandler.handle(statement, builder);
        }
    }

    /**
     * Runs all handlers that should be executed after a SQL query is executed.
     */
    @Override
    public void postHandle(Statement statement, Builder builder) {
        for (SQLHandler sqlHandler : getHandlers()) {
            if (sqlHandler.getExecutionMoment() == POST_HANDLE)
                sqlHandler.handle(statement, builder);
        }
    }
}
