/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.codetf.v3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.codemodder.codetf.v3.ChangeSet;
import io.codemodder.codetf.v3.Finding;
import io.codemodder.codetf.v3.FixMetadata;
import io.codemodder.codetf.v3.FixQuality;
import io.codemodder.codetf.v3.FixStatus;
import io.codemodder.codetf.v3.FixStatusType;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class FixResult {
    private final Finding finding;
    private final FixStatus fixStatus;
    private final List<ChangeSet> changeSets;
    private final FixMetadata fixMetadata;
    private final FixQuality fixQuality;
    private final List<String> reasoningSteps;

    @JsonCreator
    public FixResult(@JsonProperty(value="finding") Finding finding, @JsonProperty(value="fixStatus") FixStatus fixStatus, @JsonProperty(value="changeSets") List<ChangeSet> changeSets, @JsonProperty(value="fixMetadata") FixMetadata fixMetadata, @JsonProperty(value="fixQuality") FixQuality fixQuality, @JsonProperty(value="reasoningSteps") List<String> reasoningSteps) {
        this.finding = Objects.requireNonNull(finding, "finding cannot be null");
        this.fixStatus = Objects.requireNonNull(fixStatus, "fixStatus cannot be null");
        this.changeSets = changeSets != null ? changeSets : Collections.emptyList();
        this.fixMetadata = fixMetadata;
        this.fixQuality = fixQuality;
        this.reasoningSteps = reasoningSteps;
        if (fixStatus.getStatus() == FixStatusType.FIXED) {
            if (changeSets == null || changeSets.isEmpty()) {
                throw new IllegalArgumentException("changeSets must be provided for fixed results");
            }
            if (fixMetadata == null) {
                throw new IllegalArgumentException("fixMetadata must be provided for fixed results");
            }
        }
    }

    public Finding getFinding() {
        return this.finding;
    }

    public FixStatus getFixStatus() {
        return this.fixStatus;
    }

    public List<ChangeSet> getChangeSets() {
        return this.changeSets;
    }

    public FixMetadata getFixMetadata() {
        return this.fixMetadata;
    }

    public FixQuality getFixQuality() {
        return this.fixQuality;
    }

    public List<String> getReasoningSteps() {
        return this.reasoningSteps;
    }
}

