/*
 * Decompiled with CFR 0.152.
 */
package cronapi.odata.server;

import com.google.gson.JsonObject;
import cronapi.QueryManager;
import cronapi.RestClient;
import cronapi.Var;
import cronapi.jdbc.DatabaseMetadata;
import cronapi.jdbc.DatabaseMetadataFactory;
import cronapi.odata.server.JPQLParserUtil;
import cronapi.odata.server.NativeQueryUtils;
import cronapi.odata.server.ODataQuery;
import cronapi.odata.server.ODataQueryInterface;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Parameter;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SetOperationList;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.uri.UriInfo;
import org.apache.olingo.odata2.api.uri.expression.CommonExpression;
import org.apache.olingo.odata2.api.uri.expression.OrderByExpression;
import org.apache.olingo.odata2.core.edm.provider.EdmSimplePropertyImplProv;
import org.apache.olingo.odata2.jpa.processor.core.ODataExpressionParser;
import org.apache.olingo.odata2.jpa.processor.core.ODataJPAConfig;
import org.apache.olingo.odata2.jpa.processor.core.ODataParameterizedWhereExpressionUtil;
import org.apache.olingo.odata2.jpa.processor.core.access.data.VirtualClassInterface;
import org.apache.openjpa.jdbc.sql.DBDictionary;

public class NativeQuery
extends ODataQuery
implements Query,
ODataQueryInterface {
    public static final String REPLACEMENT = "$$__$$";
    public static ThreadLocal<NativeQuery> CURRENT_REST_QUERY = new ThreadLocal();
    private int maxParam;
    private String sql;
    private Var lastResult;
    private Long count = 0L;
    private String method;
    private UriInfo uriInfo;
    private JsonObject customQuery;
    private EntityManager em;
    private EdmEntityType entity;
    private String metadataSQL;

    public NativeQuery(JsonObject query, String method, String type, String sqlQuery, UriInfo uriInfo, JsonObject customQuery, EntityManager em) {
        super(query, method, type, sqlQuery, uriInfo);
        this.method = method;
        this.sql = sqlQuery;
        this.uriInfo = uriInfo;
        this.customQuery = customQuery;
        this.em = em;
        try {
            this.entity = uriInfo.getTargetEntitySet().getEntityType();
            Map parameterizedMap = ODataParameterizedWhereExpressionUtil.getParameterizedQueryMap();
            this.maxParam = 0;
            if (parameterizedMap != null && parameterizedMap.size() > 0) {
                for (Map.Entry parameterEntry : parameterizedMap.entrySet()) {
                    Map positionalParameters = (Map)parameterEntry.getValue();
                    for (Map.Entry param : positionalParameters.entrySet()) {
                        if ((Integer)param.getKey() <= this.maxParam) continue;
                        this.maxParam = (Integer)param.getKey();
                    }
                }
            }
            this.processInputs();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private void processInputs() throws EdmException {
        List<String> inputs = JPQLParserUtil.parseParams(this.sql);
        int i = this.maxParam;
        for (String param : inputs) {
            this.sql = JPQLParserUtil.replaceToken(this.sql, ":" + param, "?" + ++i);
        }
        if (inputs.size() > 0) {
            i = this.maxParam;
            for (String param : inputs) {
                ++i;
                String strValue = RestClient.getRestClient().getParameter(param);
                if (this.customQuery == null || strValue != null && !QueryManager.hasParameterValue(this.customQuery, param)) {
                    Var requestParam = Var.valueOf(strValue);
                    this.setParameter(i, requestParam.getObject());
                    continue;
                }
                LinkedHashMap<String, Var> customValues = new LinkedHashMap<String, Var>();
                customValues.put("entityName", Var.valueOf(this.uriInfo.getTargetEntitySet().getName()));
                this.setParameter(i, QueryManager.getParameterValue(this.customQuery, param, customValues).getObject());
            }
        }
        this.maxParam = i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement prepare(Connection connection, String sql, Integer returnKeys) throws Exception {
        Integer version;
        PreparedStatement query;
        List<String> params = JPQLParserUtil.parseParams(sql, '?');
        LinkedHashMap<Integer, String> mapping = new LinkedHashMap<Integer, String>();
        int i = 0;
        for (String param : params) {
            ++i;
            sql = JPQLParserUtil.replaceToken(sql, "?" + param, "?");
            if (this.metadataSQL != null) {
                this.metadataSQL = JPQLParserUtil.replaceToken(this.metadataSQL, "?" + param, "?");
            }
            mapping.put(i, param);
        }
        PreparedStatement metadataQuery = query = returnKeys != null ? connection.prepareStatement(sql, returnKeys) : connection.prepareStatement(sql);
        String database = connection.getMetaData().getDatabaseProductName();
        DBDictionary dictionary = DatabaseMetadataFactory.getMetadata(database).getDictionary(connection);
        if (database.equalsIgnoreCase("Microsoft SQL Server") && this.metadataSQL != null && (version = Integer.valueOf(connection.getMetaData().getDatabaseProductVersion().split("\\.")[0])) < 11) {
            metadataQuery = returnKeys != null ? connection.prepareStatement(this.metadataSQL, returnKeys) : connection.prepareStatement(this.metadataSQL);
        }
        try {
            NativeQueryUtils.setQueryParams(params, mapping, dictionary, metadataQuery, query, this.parameters);
        }
        finally {
            if (metadataQuery != query) {
                metadataQuery.close();
            }
        }
        return query;
    }

    private String countSQL(Statement statement, Connection connection) throws Exception {
        PlainSelect select = (PlainSelect)((Select)statement).getSelectBody();
        select.setOrderByElements(List.of());
        this.metadataSQL = statement.toString();
        return DatabaseMetadataFactory.getMetadata(connection.getMetaData().getDatabaseProductName()).count(statement, connection);
    }

    private String limit(Statement statement, Connection connection) throws Exception {
        int top = this.uriInfo.getTop() != null ? this.uriInfo.getTop() : 100;
        int skip = this.uriInfo.getSkip() != null ? this.uriInfo.getSkip() : 0;
        this.metadataSQL = statement.toString();
        return DatabaseMetadataFactory.getMetadata(connection.getMetaData().getDatabaseProductName()).limit(statement, connection, top, skip);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getResultList() {
        LinkedList list = new LinkedList();
        try {
            Object expression;
            Object sqlToExecute;
            Statement statement;
            if (!this.em.getTransaction().isActive()) {
                this.em.getTransaction().begin();
            }
            Connection connection = (Connection)this.em.unwrap(Connection.class);
            HashMap<String, Map> parameterizedExpressionMap = new HashMap<String, Map>();
            String whereExpression = null;
            if (this.uriInfo.getFilter() != null) {
                whereExpression = ODataExpressionParser.parseToJPAWhereExpression((CommonExpression)this.uriInfo.getFilter(), null, (String)"?", (String)connection.getMetaData().getDatabaseProductName());
                parameterizedExpressionMap.put(whereExpression, ODataExpressionParser.getPositionalParameters());
                ODataParameterizedWhereExpressionUtil.setParameterizedQueryMap(parameterizedExpressionMap);
                ODataExpressionParser.reInitializePositionalParameters();
            }
            if (this.uriInfo.getKeyPredicates().size() > 0) {
                whereExpression = ODataExpressionParser.parseKeyPredicates((List)this.uriInfo.getKeyPredicates(), null, (String)"?", (String)connection.getMetaData().getDatabaseProductName(), (String)"GET");
                parameterizedExpressionMap.put(whereExpression, ODataExpressionParser.getPositionalParameters());
                ODataParameterizedWhereExpressionUtil.setParameterizedQueryMap(parameterizedExpressionMap);
                ODataExpressionParser.reInitializePositionalParameters();
            }
            if (((Select)(statement = CCJSqlParserUtil.parse((String)(sqlToExecute = this.sql)))).getSelectBody() instanceof SetOperationList) {
                sqlToExecute = "select * from (" + this.sql + ") CRONAPP_ALIAS";
                statement = CCJSqlParserUtil.parse((String)sqlToExecute);
            }
            if (((Select)statement).getSelectBody() instanceof PlainSelect) {
                PlainSelect selectStatement = (PlainSelect)((Select)statement).getSelectBody();
                if (StringUtils.isNotBlank((CharSequence)whereExpression)) {
                    Expression where = selectStatement.getWhere();
                    expression = CCJSqlParserUtil.parseExpression((String)whereExpression);
                    if (where != null) {
                        where = CCJSqlParserUtil.parseExpression((String)("(" + selectStatement.getWhere().toString() + ")"));
                        expression = new AndExpression(where, expression);
                    } else if (expression instanceof Parenthesis) {
                        expression = ((Parenthesis)expression).getExpression();
                    }
                    selectStatement.setWhere(expression);
                }
                if (this.uriInfo.getOrderBy() != null) {
                    String orderExpression = ODataExpressionParser.parseToJPAOrderByExpression((OrderByExpression)this.uriInfo.getOrderBy(), null);
                    selectStatement.setOrderByElements(((PlainSelect)((Select)CCJSqlParserUtil.parse((String)("SELECT * FROM FOO ORDER BY " + orderExpression))).getSelectBody()).getOrderByElements());
                }
            }
            sqlToExecute = this.uriInfo.isCount() ? this.countSQL(statement, connection) : this.limit(statement, connection);
            try (PreparedStatement ps = this.prepare(connection, (String)sqlToExecute, null);
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    if (this.uriInfo.isCount()) {
                        expression = List.of(Long.valueOf(rs.getLong("CRONAPP_COUNT")));
                        return expression;
                    }
                    LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                    DBDictionary metadata = DatabaseMetadataFactory.getMetadata(connection.getMetaData().getDatabaseProductName()).getDictionary(connection);
                    for (String name : this.entity.getPropertyNames()) {
                        EdmSimplePropertyImplProv property = (EdmSimplePropertyImplProv)this.entity.getProperty(name);
                        if (name.equals(ODataJPAConfig.COMPOSITE_KEY_NAME) || property.getProperty().getMapping().isCalculated()) continue;
                        if (property.getProperty().getMapping().getIndex() != null) {
                            map.put(name, NativeQueryUtils.getObject(metadata, rs, property.getProperty().getMapping().getIndex(), property));
                        } else {
                            map.put(name, NativeQueryUtils.getObject(metadata, rs, rs.findColumn(name), property));
                        }
                        if (!rs.wasNull()) continue;
                        map.put(name, null);
                    }
                    list.add(map);
                }
                return list;
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public boolean delete(Object entity) {
        return this.save(entity) != null;
    }

    public Object save(Object objectToSave) {
        block23: {
            try {
                PlainSelect selectStatement;
                if (!this.em.getTransaction().isActive()) {
                    this.em.getTransaction().begin();
                }
                Connection connection = (Connection)this.em.unwrap(Connection.class);
                String whereExpression = null;
                HashMap<String, Map> parameterizedExpressionMap = new HashMap<String, Map>();
                if (this.uriInfo.getFilter() != null) {
                    whereExpression = ODataExpressionParser.parseToJPAWhereExpression((CommonExpression)this.uriInfo.getFilter(), null, (String)"?", (String)connection.getMetaData().getDatabaseProductName());
                    parameterizedExpressionMap.put(whereExpression, ODataExpressionParser.getPositionalParameters());
                    ODataParameterizedWhereExpressionUtil.setParameterizedQueryMap(parameterizedExpressionMap);
                    ODataExpressionParser.reInitializePositionalParameters();
                }
                if (this.uriInfo.getKeyPredicates().size() > 0) {
                    whereExpression = ODataExpressionParser.parseKeyPredicates((List)this.uriInfo.getKeyPredicates(), null, (String)"?", (String)connection.getMetaData().getDatabaseProductName(), (String)"PUT");
                    parameterizedExpressionMap.put(whereExpression, ODataExpressionParser.getPositionalParameters());
                    ODataParameterizedWhereExpressionUtil.setParameterizedQueryMap(parameterizedExpressionMap);
                    ODataExpressionParser.reInitializePositionalParameters();
                }
                Var varObject = Var.valueOf(objectToSave);
                Statement statement = CCJSqlParserUtil.parse((String)this.sql);
                if (!(((Select)statement).getSelectBody() instanceof PlainSelect) || !((selectStatement = (PlainSelect)((Select)statement).getSelectBody()).getFromItem() instanceof Table)) break block23;
                Table table = (Table)selectStatement.getFromItem();
                String mainTable = table.getFullyQualifiedName();
                String mainAlias = table.getAlias() != null ? table.getAlias().getName() : null;
                Object columns = "(";
                Object values = "(";
                Object update = "";
                int i = this.maxParam;
                if (!this.method.equalsIgnoreCase("DELETE")) {
                    for (String name : this.entity.getPropertyNames()) {
                        EdmSimplePropertyImplProv property;
                        if (name.equals(ODataJPAConfig.COMPOSITE_KEY_NAME) || !(property = (EdmSimplePropertyImplProv)this.entity.getProperty(name)).getProperty().getMapping().isUpdatable() || !this.method.equalsIgnoreCase("POST") && !((VirtualClassInterface)objectToSave).containsKey(name.toLowerCase())) continue;
                        Object value = varObject.get(name.toLowerCase());
                        if (property.getProperty().getFacets().isAutoGenerated()) continue;
                        ++i;
                        if (((String)columns).length() > 1) {
                            columns = (String)columns + ", ";
                            values = (String)values + ", ";
                        }
                        if (((String)update).length() > 0) {
                            update = (String)update + ", ";
                        }
                        columns = (String)columns + name;
                        values = (String)values + "?" + i;
                        update = (String)update + name + " = ?" + i;
                        this.setParameter(i, value);
                    }
                    columns = (String)columns + ")";
                    values = (String)values + ")";
                }
                String database = connection.getMetaData().getDatabaseProductName();
                DatabaseMetadata metadata = DatabaseMetadataFactory.getMetadata(database);
                String saveSQL = metadata.getInsertSQL(mainTable, mainAlias, (String)columns, (String)values, null);
                if (this.method.equalsIgnoreCase("PUT") || this.method.equalsIgnoreCase("DELETE")) {
                    Expression where = selectStatement.getWhere();
                    Object existingWhere = "";
                    if (where != null) {
                        existingWhere = "(" + selectStatement.getWhere().toString() + ") AND ";
                    }
                    if (StringUtils.isNotBlank((CharSequence)whereExpression)) {
                        Expression whereExpressionParsed;
                        String tmpWhereExpression = whereExpression;
                        if (where == null && (whereExpressionParsed = CCJSqlParserUtil.parseExpression((String)whereExpression)) instanceof Parenthesis) {
                            tmpWhereExpression = ((Parenthesis)whereExpressionParsed).getExpression().toString();
                        }
                        existingWhere = (String)existingWhere + tmpWhereExpression;
                    }
                    saveSQL = this.method.equalsIgnoreCase("PUT") ? metadata.getUpdateSQL(mainTable, mainAlias, (String)columns, (String)update, (String)existingWhere) : metadata.getDeleteSQL(mainTable, mainAlias, (String)columns, (String)update, (String)existingWhere);
                }
                try (PreparedStatement ps = this.prepare(connection, saveSQL, 1);){
                    Map<String, Object> keys;
                    if (ps.executeUpdate() == 0) {
                        throw new RuntimeException("Not Found");
                    }
                    if (this.method.equalsIgnoreCase("POST") && (keys = metadata.getGenerated(this.entity, ps, connection)) != null) {
                        keys.entrySet().forEach(entry -> ((VirtualClassInterface)objectToSave).set((String)entry.getKey(), entry.getValue()));
                    }
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        if (this.method.equalsIgnoreCase("POST") || this.method.equalsIgnoreCase("DELETE")) {
            return objectToSave;
        }
        List list = this.getResultList();
        if (list.size() == 0) {
            throw new RuntimeException("Not Found");
        }
        return Var.valueOf(list.get(0));
    }

    @Override
    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    @Override
    public Var getLastResult() {
        return this.lastResult;
    }

    @Override
    public Long count() {
        return this.count;
    }

    @Override
    public void setLastResult(Var value) {
        this.lastResult = value;
    }

    public Object getSingleResult() {
        return this.getResultList().get(0);
    }

    public int executeUpdate() {
        return 0;
    }

    public Query setMaxResults(int maxResult) {
        this.parameters.put("MaxResults", maxResult);
        return this;
    }

    public int getMaxResults() {
        return this.parameters.containsKey("MaxResults") ? (Integer)this.parameters.get("MaxResults") : -1;
    }

    public Query setFirstResult(int startPosition) {
        this.parameters.put("FirstResult", startPosition);
        return this;
    }

    public int getFirstResult() {
        return this.parameters.containsKey("FirstResult") ? (Integer)this.parameters.get("FirstResult") : -1;
    }

    public Query setHint(String hintName, Object value) {
        this.parameters.put("hintName", value);
        return this;
    }

    public Map<String, Object> getHints() {
        return null;
    }

    private void putParameter(int index, Object value) {
        this.parameters.put(String.valueOf(index), value);
    }

    public <T> Query setParameter(Parameter<T> param, T value) {
        this.putParameter(param.getPosition(), value);
        return this;
    }

    public Query setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        this.putParameter(param.getPosition(), value);
        return this;
    }

    public Query setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        this.putParameter(param.getPosition(), value);
        return this;
    }

    public Query setParameter(String name, Object value) {
        this.parameters.put(name, value);
        return this;
    }

    public Query setParameter(String name, Calendar value, TemporalType temporalType) {
        this.parameters.put(name, value);
        return this;
    }

    public Query setParameter(String name, Date value, TemporalType temporalType) {
        this.parameters.put(name, value);
        return this;
    }

    public Query setParameter(int position, Object value) {
        this.putParameter(position, value);
        return this;
    }

    public Query setParameter(int position, Calendar value, TemporalType temporalType) {
        this.putParameter(position, value);
        return this;
    }

    public Query setParameter(int position, Date value, TemporalType temporalType) {
        this.putParameter(position, value);
        return this;
    }

    public Set<Parameter<?>> getParameters() {
        return null;
    }

    public Parameter<?> getParameter(String name) {
        return null;
    }

    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        return null;
    }

    public Parameter<?> getParameter(int position) {
        return null;
    }

    public <T> Parameter<T> getParameter(int position, Class<T> type) {
        return null;
    }

    public boolean isBound(Parameter<?> param) {
        return false;
    }

    public <T> T getParameterValue(Parameter<T> param) {
        return null;
    }

    public Object getParameterValue(String name) {
        return this.parameters.get(name);
    }

    public Object getParameterValue(int position) {
        return null;
    }

    public Query setFlushMode(FlushModeType flushMode) {
        return null;
    }

    public FlushModeType getFlushMode() {
        return null;
    }

    public Query setLockMode(LockModeType lockMode) {
        return null;
    }

    public LockModeType getLockMode() {
        return null;
    }

    public <T> T unwrap(Class<T> cls) {
        return null;
    }

    @Override
    public UriInfo getUriInfo() {
        return this.uriInfo;
    }
}

